# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.customer_name_entity_1 import CustomerNameEntity1
from fdxapi.models.domicile_entity import DomicileEntity
from fdxapi.models.industry_code import IndustryCode


class BusinessCustomerEntity(object):

    """Implementation of the 'Business Customer entity' model.

    The business customer information, only used if 'type' is 'BUSINESS'.

    Attributes:
        name (str): Name of business customer
        registered_agents (List[CustomerNameEntity1]): A list of registered
            agents who act on behalf of the business customer
        registered_id (str): The registered tax identification number (TIN) or
            other identifier of business customer
        industry_code (IndustryCode): Industry code and type
        domicile (DomicileEntity): The country and region of the business
            customer's location
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "name": 'name',
        "registered_agents": 'registeredAgents',
        "registered_id": 'registeredId',
        "industry_code": 'industryCode',
        "domicile": 'domicile'
    }

    _optionals = [
        'name',
        'registered_agents',
        'registered_id',
        'industry_code',
        'domicile',
    ]

    def __init__(self,
                 name=APIHelper.SKIP,
                 registered_agents=APIHelper.SKIP,
                 registered_id=APIHelper.SKIP,
                 industry_code=APIHelper.SKIP,
                 domicile=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the BusinessCustomerEntity class"""

        # Initialize members of the class
        if name is not APIHelper.SKIP:
            self.name = name 
        if registered_agents is not APIHelper.SKIP:
            self.registered_agents = registered_agents 
        if registered_id is not APIHelper.SKIP:
            self.registered_id = registered_id 
        if industry_code is not APIHelper.SKIP:
            self.industry_code = industry_code 
        if domicile is not APIHelper.SKIP:
            self.domicile = domicile 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        name = dictionary.get("name") if dictionary.get("name") else APIHelper.SKIP
        registered_agents = None
        if dictionary.get('registeredAgents') is not None:
            registered_agents = [CustomerNameEntity1.from_dictionary(x) for x in dictionary.get('registeredAgents')]
        else:
            registered_agents = APIHelper.SKIP
        registered_id = dictionary.get("registeredId") if dictionary.get("registeredId") else APIHelper.SKIP
        industry_code = IndustryCode.from_dictionary(dictionary.get('industryCode')) if 'industryCode' in dictionary.keys() else APIHelper.SKIP
        domicile = DomicileEntity.from_dictionary(dictionary.get('domicile')) if 'domicile' in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(name,
                   registered_agents,
                   registered_id,
                   industry_code,
                   domicile,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'name={(self.name if hasattr(self, "name") else None)!r}, '
                f'registered_agents={(self.registered_agents if hasattr(self, "registered_agents") else None)!r}, '
                f'registered_id={(self.registered_id if hasattr(self, "registered_id") else None)!r}, '
                f'industry_code={(self.industry_code if hasattr(self, "industry_code") else None)!r}, '
                f'domicile={(self.domicile if hasattr(self, "domicile") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'name={(self.name if hasattr(self, "name") else None)!s}, '
                f'registered_agents={(self.registered_agents if hasattr(self, "registered_agents") else None)!s}, '
                f'registered_id={(self.registered_id if hasattr(self, "registered_id") else None)!s}, '
                f'industry_code={(self.industry_code if hasattr(self, "industry_code") else None)!s}, '
                f'domicile={(self.domicile if hasattr(self, "domicile") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
