# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class BusinessName(object):

    """Implementation of the 'Business name' model.

    The employer's name

    Attributes:
        name_1 (str): Name line 1
        name_2 (str): Name line 2
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "name_1": 'name1',
        "name_2": 'name2'
    }

    _optionals = [
        'name_1',
        'name_2',
    ]

    def __init__(self,
                 name_1=APIHelper.SKIP,
                 name_2=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the BusinessName class"""

        # Initialize members of the class
        if name_1 is not APIHelper.SKIP:
            self.name_1 = name_1 
        if name_2 is not APIHelper.SKIP:
            self.name_2 = name_2 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        name_1 = dictionary.get("name1") if dictionary.get("name1") else APIHelper.SKIP
        name_2 = dictionary.get("name2") if dictionary.get("name2") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(name_1,
                   name_2,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'name_1={(self.name_1 if hasattr(self, "name_1") else None)!r}, '
                f'name_2={(self.name_2 if hasattr(self, "name_2") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'name_1={(self.name_1 if hasattr(self, "name_1") else None)!s}, '
                f'name_2={(self.name_2 if hasattr(self, "name_2") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
