# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.hateoas_link import HateoasLink
from fdxapi.models.operation_entity import OperationEntity


class CapabilityEntity(object):

    """Implementation of the 'Capability entity' model.

    The response object for the API /capability request

    Attributes:
        fdx_versions (List[FdxVersion]): The FDX schema versions supported by
            one or more operations
        allowed_connections (int): The number of concurrent connections
            allowed for this client
        active_connections (int): The current number of active connections for
            this client
        message_format (MessageFormat2): Defaults to JSON
        operations (List[OperationEntity]): The FDX API endpoints supported
        jwks_url (HateoasLink): The URL to retrieve the JWKS public keys from
            the data provider, needed to enable payload level encryption above
            the TLS layer
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "fdx_versions": 'fdxVersions',
        "allowed_connections": 'allowedConnections',
        "active_connections": 'activeConnections',
        "message_format": 'messageFormat',
        "operations": 'operations',
        "jwks_url": 'jwksUrl'
    }

    _optionals = [
        'fdx_versions',
        'allowed_connections',
        'active_connections',
        'message_format',
        'operations',
        'jwks_url',
    ]

    def __init__(self,
                 fdx_versions=APIHelper.SKIP,
                 allowed_connections=APIHelper.SKIP,
                 active_connections=APIHelper.SKIP,
                 message_format=APIHelper.SKIP,
                 operations=APIHelper.SKIP,
                 jwks_url=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the CapabilityEntity class"""

        # Initialize members of the class
        if fdx_versions is not APIHelper.SKIP:
            self.fdx_versions = fdx_versions 
        if allowed_connections is not APIHelper.SKIP:
            self.allowed_connections = allowed_connections 
        if active_connections is not APIHelper.SKIP:
            self.active_connections = active_connections 
        if message_format is not APIHelper.SKIP:
            self.message_format = message_format 
        if operations is not APIHelper.SKIP:
            self.operations = operations 
        if jwks_url is not APIHelper.SKIP:
            self.jwks_url = jwks_url 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        fdx_versions = dictionary.get("fdxVersions") if dictionary.get("fdxVersions") else APIHelper.SKIP
        allowed_connections = dictionary.get("allowedConnections") if dictionary.get("allowedConnections") else APIHelper.SKIP
        active_connections = dictionary.get("activeConnections") if dictionary.get("activeConnections") else APIHelper.SKIP
        message_format = dictionary.get("messageFormat") if dictionary.get("messageFormat") else APIHelper.SKIP
        operations = None
        if dictionary.get('operations') is not None:
            operations = [OperationEntity.from_dictionary(x) for x in dictionary.get('operations')]
        else:
            operations = APIHelper.SKIP
        jwks_url = HateoasLink.from_dictionary(dictionary.get('jwksUrl')) if 'jwksUrl' in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(fdx_versions,
                   allowed_connections,
                   active_connections,
                   message_format,
                   operations,
                   jwks_url,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'fdx_versions={(self.fdx_versions if hasattr(self, "fdx_versions") else None)!r}, '
                f'allowed_connections={(self.allowed_connections if hasattr(self, "allowed_connections") else None)!r}, '
                f'active_connections={(self.active_connections if hasattr(self, "active_connections") else None)!r}, '
                f'message_format={(self.message_format if hasattr(self, "message_format") else None)!r}, '
                f'operations={(self.operations if hasattr(self, "operations") else None)!r}, '
                f'jwks_url={(self.jwks_url if hasattr(self, "jwks_url") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'fdx_versions={(self.fdx_versions if hasattr(self, "fdx_versions") else None)!s}, '
                f'allowed_connections={(self.allowed_connections if hasattr(self, "allowed_connections") else None)!s}, '
                f'active_connections={(self.active_connections if hasattr(self, "active_connections") else None)!s}, '
                f'message_format={(self.message_format if hasattr(self, "message_format") else None)!s}, '
                f'operations={(self.operations if hasattr(self, "operations") else None)!s}, '
                f'jwks_url={(self.jwks_url if hasattr(self, "jwks_url") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
