# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class CertificationMetricEntity(object):

    """Implementation of the 'Certification Metric entity' model.

    A single certification performance metric

    Attributes:
        report_start_timestamp (datetime): When the reported metrics period
            began
        report_end_timestamp (datetime): When the reported metrics period ended
        metrics_name (str): Any provider descriptive name for the measurement.
            Optional, can be omitted if operationIds are returned
        operation_ids (List[FdxResourceOperationId]): One or more Operation
            IDs for which these metrics apply. Optional, can be omitted if
            metricsName is returned
        response_time_average (float): The self-reported average response time
            in milliseconds for all combined data responses
        average_up_time (float): See the Certification Performance section
            that describes how this measurement will be calculated, defines
            the % of availability during the measurement
        report_timestamp (datetime): Time when these performance and
            availability metrics were created
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "report_start_timestamp": 'reportStartTimestamp',
        "report_end_timestamp": 'reportEndTimestamp',
        "metrics_name": 'metricsName',
        "operation_ids": 'operationIds',
        "response_time_average": 'responseTimeAverage',
        "average_up_time": 'averageUpTime',
        "report_timestamp": 'reportTimestamp'
    }

    _optionals = [
        'report_start_timestamp',
        'report_end_timestamp',
        'metrics_name',
        'operation_ids',
        'response_time_average',
        'average_up_time',
        'report_timestamp',
    ]

    def __init__(self,
                 report_start_timestamp=APIHelper.SKIP,
                 report_end_timestamp=APIHelper.SKIP,
                 metrics_name=APIHelper.SKIP,
                 operation_ids=APIHelper.SKIP,
                 response_time_average=APIHelper.SKIP,
                 average_up_time=APIHelper.SKIP,
                 report_timestamp=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the CertificationMetricEntity class"""

        # Initialize members of the class
        if report_start_timestamp is not APIHelper.SKIP:
            self.report_start_timestamp = APIHelper.apply_datetime_converter(report_start_timestamp, APIHelper.RFC3339DateTime) if report_start_timestamp else None 
        if report_end_timestamp is not APIHelper.SKIP:
            self.report_end_timestamp = APIHelper.apply_datetime_converter(report_end_timestamp, APIHelper.RFC3339DateTime) if report_end_timestamp else None 
        if metrics_name is not APIHelper.SKIP:
            self.metrics_name = metrics_name 
        if operation_ids is not APIHelper.SKIP:
            self.operation_ids = operation_ids 
        if response_time_average is not APIHelper.SKIP:
            self.response_time_average = response_time_average 
        if average_up_time is not APIHelper.SKIP:
            self.average_up_time = average_up_time 
        if report_timestamp is not APIHelper.SKIP:
            self.report_timestamp = APIHelper.apply_datetime_converter(report_timestamp, APIHelper.RFC3339DateTime) if report_timestamp else None 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        report_start_timestamp = APIHelper.RFC3339DateTime.from_value(dictionary.get("reportStartTimestamp")).datetime if dictionary.get("reportStartTimestamp") else APIHelper.SKIP
        report_end_timestamp = APIHelper.RFC3339DateTime.from_value(dictionary.get("reportEndTimestamp")).datetime if dictionary.get("reportEndTimestamp") else APIHelper.SKIP
        metrics_name = dictionary.get("metricsName") if dictionary.get("metricsName") else APIHelper.SKIP
        operation_ids = dictionary.get("operationIds") if dictionary.get("operationIds") else APIHelper.SKIP
        response_time_average = dictionary.get("responseTimeAverage") if dictionary.get("responseTimeAverage") else APIHelper.SKIP
        average_up_time = dictionary.get("averageUpTime") if dictionary.get("averageUpTime") else APIHelper.SKIP
        report_timestamp = APIHelper.RFC3339DateTime.from_value(dictionary.get("reportTimestamp")).datetime if dictionary.get("reportTimestamp") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(report_start_timestamp,
                   report_end_timestamp,
                   metrics_name,
                   operation_ids,
                   response_time_average,
                   average_up_time,
                   report_timestamp,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'report_start_timestamp={(self.report_start_timestamp if hasattr(self, "report_start_timestamp") else None)!r}, '
                f'report_end_timestamp={(self.report_end_timestamp if hasattr(self, "report_end_timestamp") else None)!r}, '
                f'metrics_name={(self.metrics_name if hasattr(self, "metrics_name") else None)!r}, '
                f'operation_ids={(self.operation_ids if hasattr(self, "operation_ids") else None)!r}, '
                f'response_time_average={(self.response_time_average if hasattr(self, "response_time_average") else None)!r}, '
                f'average_up_time={(self.average_up_time if hasattr(self, "average_up_time") else None)!r}, '
                f'report_timestamp={(self.report_timestamp if hasattr(self, "report_timestamp") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'report_start_timestamp={(self.report_start_timestamp if hasattr(self, "report_start_timestamp") else None)!s}, '
                f'report_end_timestamp={(self.report_end_timestamp if hasattr(self, "report_end_timestamp") else None)!s}, '
                f'metrics_name={(self.metrics_name if hasattr(self, "metrics_name") else None)!s}, '
                f'operation_ids={(self.operation_ids if hasattr(self, "operation_ids") else None)!s}, '
                f'response_time_average={(self.response_time_average if hasattr(self, "response_time_average") else None)!s}, '
                f'average_up_time={(self.average_up_time if hasattr(self, "average_up_time") else None)!s}, '
                f'report_timestamp={(self.report_timestamp if hasattr(self, "report_timestamp") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
