# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class CommercialCodeEntity(object):

    """Implementation of the 'Commercial Code entity' model.

    The code for a specific treasury management defined field.
    The [X9 BTRS/BTR3 standard](https://x9.org/standards/btrs/) (formerly
    named BAI2) for corporate and treasury data elements is proposed to
    provide the basis of (or starting point for) representing summary,
    account, and transaction codes for the Corp/Treasury Entity, subject to
    any necessary modifications useful to the members of the FDX consortium
    and users of the API specification

    Attributes:
        mtype (TreasuryManagementType): The source of Treasury Management
            account definition; one of BAI, BTRS, ISO, SWIFT
        code (str): The code of the Treasury Management defined field
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "mtype": 'type',
        "code": 'code'
    }

    _optionals = [
        'mtype',
        'code',
    ]

    def __init__(self,
                 mtype=APIHelper.SKIP,
                 code=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the CommercialCodeEntity class"""

        # Initialize members of the class
        if mtype is not APIHelper.SKIP:
            self.mtype = mtype 
        if code is not APIHelper.SKIP:
            self.code = code 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        mtype = dictionary.get("type") if dictionary.get("type") else APIHelper.SKIP
        code = dictionary.get("code") if dictionary.get("code") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(mtype,
                   code,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'mtype={(self.mtype if hasattr(self, "mtype") else None)!r}, '
                f'code={(self.code if hasattr(self, "code") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'mtype={(self.mtype if hasattr(self, "mtype") else None)!s}, '
                f'code={(self.code if hasattr(self, "code") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
