# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class ConsentGrantResourceEntity(object):

    """Implementation of the 'Consent Grant Resource entity' model.

    Entity of permissioned resources

    Attributes:
        resource_type (ConsentResourceType3): Type of resource to be
            permissioned
        resource_id (str): Identifier of resource to be permissioned
        data_clusters (List[DataCluster]): Names of clusters of data elements
            permissioned
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "resource_type": 'resourceType',
        "resource_id": 'resourceId',
        "data_clusters": 'dataClusters'
    }

    def __init__(self,
                 resource_type=None,
                 resource_id=None,
                 data_clusters=None,
                 additional_properties=None):
        """Constructor for the ConsentGrantResourceEntity class"""

        # Initialize members of the class
        self.resource_type = resource_type 
        self.resource_id = resource_id 
        self.data_clusters = data_clusters 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        resource_type = dictionary.get("resourceType") if dictionary.get("resourceType") else None
        resource_id = dictionary.get("resourceId") if dictionary.get("resourceId") else None
        data_clusters = dictionary.get("dataClusters") if dictionary.get("dataClusters") else None
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(resource_type,
                   resource_id,
                   data_clusters,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'resource_type={self.resource_type!r}, '
                f'resource_id={self.resource_id!r}, '
                f'data_clusters={self.data_clusters!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'resource_type={self.resource_type!s}, '
                f'resource_id={self.resource_id!s}, '
                f'data_clusters={self.data_clusters!s}, '
                f'additional_properties={self.additional_properties!s})')
