# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.consent_requested_resource_entity import ConsentRequestedResourceEntity


class ConsentRequestEntity(object):

    """Implementation of the 'Consent Request entity' model.

    Details of request to create new consent grant. This schema is to be used
    in POST request to Data Provider's `POST /par` endpoint using the Pushed
    Authorization Request (PAR) method

    Attributes:
        duration_type (ConsentDurationType): The type of duration of the
            consent
        duration_period (int): The consent duration in days from day of
            original grant
        lookback_period (int): Period, in days, for which historical data may
            be requested; measured from request time, not grant time
        resources (List[ConsentRequestedResourceEntity]): The requested
            resource entities
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "duration_type": 'durationType',
        "duration_period": 'durationPeriod',
        "lookback_period": 'lookbackPeriod',
        "resources": 'resources'
    }

    _optionals = [
        'duration_type',
        'duration_period',
        'lookback_period',
        'resources',
    ]

    def __init__(self,
                 duration_type=APIHelper.SKIP,
                 duration_period=APIHelper.SKIP,
                 lookback_period=APIHelper.SKIP,
                 resources=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the ConsentRequestEntity class"""

        # Initialize members of the class
        if duration_type is not APIHelper.SKIP:
            self.duration_type = duration_type 
        if duration_period is not APIHelper.SKIP:
            self.duration_period = duration_period 
        if lookback_period is not APIHelper.SKIP:
            self.lookback_period = lookback_period 
        if resources is not APIHelper.SKIP:
            self.resources = resources 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        duration_type = dictionary.get("durationType") if dictionary.get("durationType") else APIHelper.SKIP
        duration_period = dictionary.get("durationPeriod") if dictionary.get("durationPeriod") else APIHelper.SKIP
        lookback_period = dictionary.get("lookbackPeriod") if dictionary.get("lookbackPeriod") else APIHelper.SKIP
        resources = None
        if dictionary.get('resources') is not None:
            resources = [ConsentRequestedResourceEntity.from_dictionary(x) for x in dictionary.get('resources')]
        else:
            resources = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(duration_type,
                   duration_period,
                   lookback_period,
                   resources,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'duration_type={(self.duration_type if hasattr(self, "duration_type") else None)!r}, '
                f'duration_period={(self.duration_period if hasattr(self, "duration_period") else None)!r}, '
                f'lookback_period={(self.lookback_period if hasattr(self, "lookback_period") else None)!r}, '
                f'resources={(self.resources if hasattr(self, "resources") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'duration_type={(self.duration_type if hasattr(self, "duration_type") else None)!s}, '
                f'duration_period={(self.duration_period if hasattr(self, "duration_period") else None)!s}, '
                f'lookback_period={(self.lookback_period if hasattr(self, "lookback_period") else None)!s}, '
                f'resources={(self.resources if hasattr(self, "resources") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
