# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class ConsentRevocationEntity(object):

    """Implementation of the 'Consent Revocation entity' model.

    Details of request to revoke consent grant

    Attributes:
        status (ConsentGrantStatus1): The status of the consent = REVOKED
        reason (ConsentUpdateReason1): The reason for consent revocation
        initiator (PartyType1): The party initiating consent revocation
        updated_time (datetime): When the consent grant was revoked
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "status": 'status',
        "reason": 'reason',
        "initiator": 'initiator',
        "updated_time": 'updatedTime'
    }

    _optionals = [
        'status',
        'reason',
        'initiator',
        'updated_time',
    ]

    def __init__(self,
                 status=APIHelper.SKIP,
                 reason=APIHelper.SKIP,
                 initiator=APIHelper.SKIP,
                 updated_time=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the ConsentRevocationEntity class"""

        # Initialize members of the class
        if status is not APIHelper.SKIP:
            self.status = status 
        if reason is not APIHelper.SKIP:
            self.reason = reason 
        if initiator is not APIHelper.SKIP:
            self.initiator = initiator 
        if updated_time is not APIHelper.SKIP:
            self.updated_time = APIHelper.apply_datetime_converter(updated_time, APIHelper.RFC3339DateTime) if updated_time else None 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        status = dictionary.get("status") if dictionary.get("status") else APIHelper.SKIP
        reason = dictionary.get("reason") if dictionary.get("reason") else APIHelper.SKIP
        initiator = dictionary.get("initiator") if dictionary.get("initiator") else APIHelper.SKIP
        updated_time = APIHelper.RFC3339DateTime.from_value(dictionary.get("updatedTime")).datetime if dictionary.get("updatedTime") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(status,
                   reason,
                   initiator,
                   updated_time,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'status={(self.status if hasattr(self, "status") else None)!r}, '
                f'reason={(self.reason if hasattr(self, "reason") else None)!r}, '
                f'initiator={(self.initiator if hasattr(self, "initiator") else None)!r}, '
                f'updated_time={(self.updated_time if hasattr(self, "updated_time") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'status={(self.status if hasattr(self, "status") else None)!s}, '
                f'reason={(self.reason if hasattr(self, "reason") else None)!s}, '
                f'initiator={(self.initiator if hasattr(self, "initiator") else None)!s}, '
                f'updated_time={(self.updated_time if hasattr(self, "updated_time") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
