# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.consent_revocation_entity import ConsentRevocationEntity


class ConsentRevocationListEntity(object):

    """Implementation of the 'Consent Revocation List entity' model.

    List of consent grant revocation requests

    Attributes:
        revocations (List[ConsentRevocationEntity]): The list of revocation
            requests
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "revocations": 'revocations'
    }

    _optionals = [
        'revocations',
    ]

    def __init__(self,
                 revocations=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the ConsentRevocationListEntity class"""

        # Initialize members of the class
        if revocations is not APIHelper.SKIP:
            self.revocations = revocations 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        revocations = None
        if dictionary.get('revocations') is not None:
            revocations = [ConsentRevocationEntity.from_dictionary(x) for x in dictionary.get('revocations')]
        else:
            revocations = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(revocations,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'revocations={(self.revocations if hasattr(self, "revocations") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'revocations={(self.revocations if hasattr(self, "revocations") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
