# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class ConsentRevocationRequestEntity(object):

    """Implementation of the 'Consent revocation request entity' model.

    Details of request to revoke consent grant

    Attributes:
        reason (ConsentUpdateReason1): The reason for consent revocation
        initiator (PartyType2): The party initiating revocation
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "reason": 'reason',
        "initiator": 'initiator'
    }

    _optionals = [
        'reason',
        'initiator',
    ]

    def __init__(self,
                 reason=APIHelper.SKIP,
                 initiator=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the ConsentRevocationRequestEntity class"""

        # Initialize members of the class
        if reason is not APIHelper.SKIP:
            self.reason = reason 
        if initiator is not APIHelper.SKIP:
            self.initiator = initiator 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        reason = dictionary.get("reason") if dictionary.get("reason") else APIHelper.SKIP
        initiator = dictionary.get("initiator") if dictionary.get("initiator") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(reason,
                   initiator,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'reason={(self.reason if hasattr(self, "reason") else None)!r}, '
                f'initiator={(self.initiator if hasattr(self, "initiator") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'reason={(self.reason if hasattr(self, "reason") else None)!s}, '
                f'initiator={(self.initiator if hasattr(self, "initiator") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
