# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper


class DateAndAmount(object):

    """Implementation of the 'Date and Amount' model.

    Date, description, and amount. When used in 1098-Q, description is optional

    Attributes:
        date (date): Date of amount. When used in 1098-Q, date of last payment
            in month
        description (str): Description of amount. When used in 1098-Q, may use
            MonthAbbreviation
        amount (float): Amount of payment or receipt. When used in 1098-Q,
            monthly total
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "date": 'date',
        "description": 'description',
        "amount": 'amount'
    }

    _optionals = [
        'date',
        'description',
        'amount',
    ]

    def __init__(self,
                 date=APIHelper.SKIP,
                 description=APIHelper.SKIP,
                 amount=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the DateAndAmount class"""

        # Initialize members of the class
        if date is not APIHelper.SKIP:
            self.date = date 
        if description is not APIHelper.SKIP:
            self.description = description 
        if amount is not APIHelper.SKIP:
            self.amount = amount 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        date = dateutil.parser.parse(dictionary.get('date')).date() if dictionary.get('date') else APIHelper.SKIP
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        amount = dictionary.get("amount") if dictionary.get("amount") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(date,
                   description,
                   amount,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'date={(self.date if hasattr(self, "date") else None)!r}, '
                f'description={(self.description if hasattr(self, "description") else None)!r}, '
                f'amount={(self.amount if hasattr(self, "amount") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'date={(self.date if hasattr(self, "date") else None)!s}, '
                f'description={(self.description if hasattr(self, "description") else None)!s}, '
                f'amount={(self.amount if hasattr(self, "amount") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
