# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class DomicileEntity(object):

    """Implementation of the 'Domicile entity' model.

    The country and region of the business customer's location

    Attributes:
        region (str): Country sub-division; state or province or territory
        country (Iso3166CountryCode2): ISO 3166 Country Code
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "region": 'region',
        "country": 'country'
    }

    _optionals = [
        'region',
        'country',
    ]

    def __init__(self,
                 region=APIHelper.SKIP,
                 country=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the DomicileEntity class"""

        # Initialize members of the class
        if region is not APIHelper.SKIP:
            self.region = region 
        if country is not APIHelper.SKIP:
            self.country = country 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        region = dictionary.get("region") if dictionary.get("region") else APIHelper.SKIP
        country = dictionary.get("country") if dictionary.get("country") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(region,
                   country,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'region={(self.region if hasattr(self, "region") else None)!r}, '
                f'country={(self.country if hasattr(self, "country") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'region={(self.region if hasattr(self, "region") else None)!s}, '
                f'country={(self.country if hasattr(self, "country") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
