# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class ElectronicAddressEntity(object):

    """Implementation of the 'Electronic Address entity' model.

    Electronic address details

    Attributes:
        email_address_text (str): Value of the email address
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "email_address_text": 'emailAddressText'
    }

    _optionals = [
        'email_address_text',
    ]

    def __init__(self,
                 email_address_text=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the ElectronicAddressEntity class"""

        # Initialize members of the class
        if email_address_text is not APIHelper.SKIP:
            self.email_address_text = email_address_text 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        email_address_text = dictionary.get("emailAddressText") if dictionary.get("emailAddressText") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(email_address_text,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'email_address_text={(self.email_address_text if hasattr(self, "email_address_text") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'email_address_text={(self.email_address_text if hasattr(self, "email_address_text") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
