# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.business_name import BusinessName
from fdxapi.models.contacts_entity import ContactsEntity


class EmployerEntity1(object):

    """Implementation of the 'Employer entity1' model.

    The employer for the job/position

    Attributes:
        employer_id (str): Provider's long-term persistent id for the employer
        name (BusinessName): The employer's name
        dbas (List[str]): Array of Doing Business As names for this employer
        tax_id (str): Country specific Tax Id associated with this employer
            (FEIN in USA or BN in Canada)
        tax_id_country (Iso3166CountryCode): Country originating the
            employer's taxId element
        contacts (ContactsEntity): Employer's various contact information
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "name": 'name',
        "employer_id": 'employerId',
        "dbas": 'dbas',
        "tax_id": 'taxId',
        "tax_id_country": 'taxIdCountry',
        "contacts": 'contacts'
    }

    _optionals = [
        'employer_id',
        'dbas',
        'tax_id',
        'tax_id_country',
        'contacts',
    ]

    def __init__(self,
                 name=None,
                 employer_id=APIHelper.SKIP,
                 dbas=APIHelper.SKIP,
                 tax_id=APIHelper.SKIP,
                 tax_id_country=APIHelper.SKIP,
                 contacts=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the EmployerEntity1 class"""

        # Initialize members of the class
        if employer_id is not APIHelper.SKIP:
            self.employer_id = employer_id 
        self.name = name 
        if dbas is not APIHelper.SKIP:
            self.dbas = dbas 
        if tax_id is not APIHelper.SKIP:
            self.tax_id = tax_id 
        if tax_id_country is not APIHelper.SKIP:
            self.tax_id_country = tax_id_country 
        if contacts is not APIHelper.SKIP:
            self.contacts = contacts 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        name = BusinessName.from_dictionary(dictionary.get('name')) if dictionary.get('name') else None
        employer_id = dictionary.get("employerId") if dictionary.get("employerId") else APIHelper.SKIP
        dbas = dictionary.get("dbas") if dictionary.get("dbas") else APIHelper.SKIP
        tax_id = dictionary.get("taxId") if dictionary.get("taxId") else APIHelper.SKIP
        tax_id_country = dictionary.get("taxIdCountry") if dictionary.get("taxIdCountry") else APIHelper.SKIP
        contacts = ContactsEntity.from_dictionary(dictionary.get('contacts')) if 'contacts' in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(name,
                   employer_id,
                   dbas,
                   tax_id,
                   tax_id_country,
                   contacts,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'employer_id={(self.employer_id if hasattr(self, "employer_id") else None)!r}, '
                f'name={self.name!r}, '
                f'dbas={(self.dbas if hasattr(self, "dbas") else None)!r}, '
                f'tax_id={(self.tax_id if hasattr(self, "tax_id") else None)!r}, '
                f'tax_id_country={(self.tax_id_country if hasattr(self, "tax_id_country") else None)!r}, '
                f'contacts={(self.contacts if hasattr(self, "contacts") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'employer_id={(self.employer_id if hasattr(self, "employer_id") else None)!s}, '
                f'name={self.name!s}, '
                f'dbas={(self.dbas if hasattr(self, "dbas") else None)!s}, '
                f'tax_id={(self.tax_id if hasattr(self, "tax_id") else None)!s}, '
                f'tax_id_country={(self.tax_id_country if hasattr(self, "tax_id_country") else None)!s}, '
                f'contacts={(self.contacts if hasattr(self, "contacts") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
