# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class Error1(object):

    """Implementation of the 'Error1' model.

    An error entity which can be used at the API level for error responses or
    at the account level to indicate a problem specific to a particular
    account. See the error codes and descriptions defined in the latest FDX
    API Specification document, section 6.2 Errors

    Attributes:
        code (str): Error code defined by FDX API Specification or Data
            Provider indicating the error situation which has occurred
        message (str): End user displayable information which might help the
            customer diagnose an error
        debug_message (str): Message used to debug the root cause of the
            error. Contents should not be used in consumer's business logic.
            Can change at any time and should only be used for consumer to
            communicate with the data provider about an issue. Provider can
            include an error GUID in message for their use.
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "code": 'code',
        "message": 'message',
        "debug_message": 'debugMessage'
    }

    _optionals = [
        'code',
        'message',
        'debug_message',
    ]

    def __init__(self,
                 code=APIHelper.SKIP,
                 message=APIHelper.SKIP,
                 debug_message=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the Error1 class"""

        # Initialize members of the class
        if code is not APIHelper.SKIP:
            self.code = code 
        if message is not APIHelper.SKIP:
            self.message = message 
        if debug_message is not APIHelper.SKIP:
            self.debug_message = debug_message 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        code = dictionary.get("code") if dictionary.get("code") else APIHelper.SKIP
        message = dictionary.get("message") if dictionary.get("message") else APIHelper.SKIP
        debug_message = dictionary.get("debugMessage") if dictionary.get("debugMessage") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(code,
                   message,
                   debug_message,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'code={(self.code if hasattr(self, "code") else None)!r}, '
                f'message={(self.message if hasattr(self, "message") else None)!r}, '
                f'debug_message={(self.debug_message if hasattr(self, "debug_message") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'code={(self.code if hasattr(self, "code") else None)!s}, '
                f'message={(self.message if hasattr(self, "message") else None)!s}, '
                f'debug_message={(self.debug_message if hasattr(self, "debug_message") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
