# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.date_and_amount import DateAndAmount
from fdxapi.models.description_and_amount import DescriptionAndAmount
from fdxapi.models.error_1 import Error1
from fdxapi.models.hateoas_link import HateoasLink
from fdxapi.models.tax_form_attribute import TaxFormAttribute
from fdxapi.models.tax_party_1 import TaxParty1
from fdxapi.models.tax_party_8 import TaxParty8


class FarmRentalIncomeStatement(object):

    """Implementation of the 'Farm Rental Income Statement' model.

    Farm Rental Income Statement for IRS Form 4835

    Attributes:
        tax_year (int): Year for which taxes are being paid
        corrected (bool): True to indicate this is a corrected tax form
        account_id (str): Long-term persistent identity of the source account.
            Not the account number
        tax_form_id (str): Long-term persistent id for this tax form.
            Depending upon the data provider, this may be the same id as the
            enclosing tax statement id, or this may be a different id, or this
            id may be omitted.
        tax_form_date (date): Date of production or delivery of the tax form
        additional_information (str): Additional explanation text or content
            about this tax form
        tax_form_type (TypeFormType1): Enumerated name of the tax form entity
            e.g. "TaxW2"
        issuer (TaxParty8): Issuer's name, address, phone, and TIN. Issuer
            data need only be transmitted on enclosing TaxStatement, if it is
            the same on all its included tax forms.
        recipient (TaxParty1): Recipient's name, address, phone, and TIN.
            Recipient data need only be transmitted on enclosing TaxStatement,
            if it is the same on all its included tax forms.
        attributes (List[TaxFormAttribute]): Additional attributes for this
            tax form when defined fields are not available. Some specific
            additional attributes already defined by providers: Fields
            required by [IRS
            FIRE](https://www.irs.gov/e-file-providers/filing-information-retur
            ns-electronically-fire): Name Control, Type of Identification
            Number (EIN, SSN, ITIN, ATIN). (ATIN is tax ID number for pending
            adoptions.) Tax form provider field for taxpayer notification:
            Recipient Email Address.
        error (Error1): Present if an error was encountered while retrieving
            this form
        links (List[HateoasLink]): Links to retrieve this form as data or
            image, or to invoke other APIs
        income_from_production (float): Box 1, Income from production of
            livestock, produce, grains, and other crops
        coop_distributions (float): Box 2a, Cooperative distributions
        ag_program_payments (float): Box 3a, Agricultural program payments
        ccc_loans (float): Box 4a, Commodity Credit Corporation (CCC) loans
            reported under election
        crop_insurance_proceeds (float): Box 5a, Crop insurance proceeds and
            federal crop disaster payments
        other_income (List[DescriptionAndAmount]): Box 6, Other income
        car_and_truck (float): Box 8, Car and truck expenses
        chemicals (float): Box 9, Chemicals
        conservation (float): Box 10, Conservation expenses
        custom_hire_expenses (float): Box 11, Custom hire (machine work)
        depreciation (float): Box 12, Depreciation
        employee_benefit_programs (float): Box 13, Employee benefit programs
        feed (float): Box 14, Feed
        fertilizers (float): Box 15, Fertilizers and lime
        freight (float): Box 16, Freight and trucking
        fuel (float): Box 17, Gasoline, fuel, and oil
        insurance (float): Box 18, Insurance (other than health)
        mortgage_interest (float): Box 19a, Mortgage Interest
        other_interest (float): Box 19b, Other interest
        labor_hired (float): Box 20, Labor hired
        pension (float): Box 21, Pension and profit-sharing plans
        equipment_rent (float): Box 22a, Rent or lease: Vehicles, machinery,
            equipment
        other_rent (float): Box 22b, Rent or lease: Other
        repairs (float): Box 23, Repairs and maintenance
        seeds (float): Box 24, Seeds and plants
        storage (float): Box 25, Storage and warehousing
        supplies (float): Box 26, Supplies
        taxes (float): Box 27, Taxes
        utilities (float): Box 28, Utilities
        veterinary (float): Box 29, Veterinary, breeding, and medicine
        other_expenses (List[DescriptionAndAmount]): Box 30, Other expenses
        capital_expenditures (List[DateAndAmount]): Capital expenditures, for
            use in calculating Depreciation
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "tax_year": 'taxYear',
        "corrected": 'corrected',
        "account_id": 'accountId',
        "tax_form_id": 'taxFormId',
        "tax_form_date": 'taxFormDate',
        "additional_information": 'additionalInformation',
        "tax_form_type": 'taxFormType',
        "issuer": 'issuer',
        "recipient": 'recipient',
        "attributes": 'attributes',
        "error": 'error',
        "links": 'links',
        "income_from_production": 'incomeFromProduction',
        "coop_distributions": 'coopDistributions',
        "ag_program_payments": 'agProgramPayments',
        "ccc_loans": 'cccLoans',
        "crop_insurance_proceeds": 'cropInsuranceProceeds',
        "other_income": 'otherIncome',
        "car_and_truck": 'carAndTruck',
        "chemicals": 'chemicals',
        "conservation": 'conservation',
        "custom_hire_expenses": 'customHireExpenses',
        "depreciation": 'depreciation',
        "employee_benefit_programs": 'employeeBenefitPrograms',
        "feed": 'feed',
        "fertilizers": 'fertilizers',
        "freight": 'freight',
        "fuel": 'fuel',
        "insurance": 'insurance',
        "mortgage_interest": 'mortgageInterest',
        "other_interest": 'otherInterest',
        "labor_hired": 'laborHired',
        "pension": 'pension',
        "equipment_rent": 'equipmentRent',
        "other_rent": 'otherRent',
        "repairs": 'repairs',
        "seeds": 'seeds',
        "storage": 'storage',
        "supplies": 'supplies',
        "taxes": 'taxes',
        "utilities": 'utilities',
        "veterinary": 'veterinary',
        "other_expenses": 'otherExpenses',
        "capital_expenditures": 'capitalExpenditures'
    }

    _optionals = [
        'tax_year',
        'corrected',
        'account_id',
        'tax_form_id',
        'tax_form_date',
        'additional_information',
        'tax_form_type',
        'issuer',
        'recipient',
        'attributes',
        'error',
        'links',
        'income_from_production',
        'coop_distributions',
        'ag_program_payments',
        'ccc_loans',
        'crop_insurance_proceeds',
        'other_income',
        'car_and_truck',
        'chemicals',
        'conservation',
        'custom_hire_expenses',
        'depreciation',
        'employee_benefit_programs',
        'feed',
        'fertilizers',
        'freight',
        'fuel',
        'insurance',
        'mortgage_interest',
        'other_interest',
        'labor_hired',
        'pension',
        'equipment_rent',
        'other_rent',
        'repairs',
        'seeds',
        'storage',
        'supplies',
        'taxes',
        'utilities',
        'veterinary',
        'other_expenses',
        'capital_expenditures',
    ]

    def __init__(self,
                 tax_year=APIHelper.SKIP,
                 corrected=APIHelper.SKIP,
                 account_id=APIHelper.SKIP,
                 tax_form_id=APIHelper.SKIP,
                 tax_form_date=APIHelper.SKIP,
                 additional_information=APIHelper.SKIP,
                 tax_form_type=APIHelper.SKIP,
                 issuer=APIHelper.SKIP,
                 recipient=APIHelper.SKIP,
                 attributes=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 income_from_production=APIHelper.SKIP,
                 coop_distributions=APIHelper.SKIP,
                 ag_program_payments=APIHelper.SKIP,
                 ccc_loans=APIHelper.SKIP,
                 crop_insurance_proceeds=APIHelper.SKIP,
                 other_income=APIHelper.SKIP,
                 car_and_truck=APIHelper.SKIP,
                 chemicals=APIHelper.SKIP,
                 conservation=APIHelper.SKIP,
                 custom_hire_expenses=APIHelper.SKIP,
                 depreciation=APIHelper.SKIP,
                 employee_benefit_programs=APIHelper.SKIP,
                 feed=APIHelper.SKIP,
                 fertilizers=APIHelper.SKIP,
                 freight=APIHelper.SKIP,
                 fuel=APIHelper.SKIP,
                 insurance=APIHelper.SKIP,
                 mortgage_interest=APIHelper.SKIP,
                 other_interest=APIHelper.SKIP,
                 labor_hired=APIHelper.SKIP,
                 pension=APIHelper.SKIP,
                 equipment_rent=APIHelper.SKIP,
                 other_rent=APIHelper.SKIP,
                 repairs=APIHelper.SKIP,
                 seeds=APIHelper.SKIP,
                 storage=APIHelper.SKIP,
                 supplies=APIHelper.SKIP,
                 taxes=APIHelper.SKIP,
                 utilities=APIHelper.SKIP,
                 veterinary=APIHelper.SKIP,
                 other_expenses=APIHelper.SKIP,
                 capital_expenditures=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the FarmRentalIncomeStatement class"""

        # Initialize members of the class
        if tax_year is not APIHelper.SKIP:
            self.tax_year = tax_year 
        if corrected is not APIHelper.SKIP:
            self.corrected = corrected 
        if account_id is not APIHelper.SKIP:
            self.account_id = account_id 
        if tax_form_id is not APIHelper.SKIP:
            self.tax_form_id = tax_form_id 
        if tax_form_date is not APIHelper.SKIP:
            self.tax_form_date = tax_form_date 
        if additional_information is not APIHelper.SKIP:
            self.additional_information = additional_information 
        if tax_form_type is not APIHelper.SKIP:
            self.tax_form_type = tax_form_type 
        if issuer is not APIHelper.SKIP:
            self.issuer = issuer 
        if recipient is not APIHelper.SKIP:
            self.recipient = recipient 
        if attributes is not APIHelper.SKIP:
            self.attributes = attributes 
        if error is not APIHelper.SKIP:
            self.error = error 
        if links is not APIHelper.SKIP:
            self.links = links 
        if income_from_production is not APIHelper.SKIP:
            self.income_from_production = income_from_production 
        if coop_distributions is not APIHelper.SKIP:
            self.coop_distributions = coop_distributions 
        if ag_program_payments is not APIHelper.SKIP:
            self.ag_program_payments = ag_program_payments 
        if ccc_loans is not APIHelper.SKIP:
            self.ccc_loans = ccc_loans 
        if crop_insurance_proceeds is not APIHelper.SKIP:
            self.crop_insurance_proceeds = crop_insurance_proceeds 
        if other_income is not APIHelper.SKIP:
            self.other_income = other_income 
        if car_and_truck is not APIHelper.SKIP:
            self.car_and_truck = car_and_truck 
        if chemicals is not APIHelper.SKIP:
            self.chemicals = chemicals 
        if conservation is not APIHelper.SKIP:
            self.conservation = conservation 
        if custom_hire_expenses is not APIHelper.SKIP:
            self.custom_hire_expenses = custom_hire_expenses 
        if depreciation is not APIHelper.SKIP:
            self.depreciation = depreciation 
        if employee_benefit_programs is not APIHelper.SKIP:
            self.employee_benefit_programs = employee_benefit_programs 
        if feed is not APIHelper.SKIP:
            self.feed = feed 
        if fertilizers is not APIHelper.SKIP:
            self.fertilizers = fertilizers 
        if freight is not APIHelper.SKIP:
            self.freight = freight 
        if fuel is not APIHelper.SKIP:
            self.fuel = fuel 
        if insurance is not APIHelper.SKIP:
            self.insurance = insurance 
        if mortgage_interest is not APIHelper.SKIP:
            self.mortgage_interest = mortgage_interest 
        if other_interest is not APIHelper.SKIP:
            self.other_interest = other_interest 
        if labor_hired is not APIHelper.SKIP:
            self.labor_hired = labor_hired 
        if pension is not APIHelper.SKIP:
            self.pension = pension 
        if equipment_rent is not APIHelper.SKIP:
            self.equipment_rent = equipment_rent 
        if other_rent is not APIHelper.SKIP:
            self.other_rent = other_rent 
        if repairs is not APIHelper.SKIP:
            self.repairs = repairs 
        if seeds is not APIHelper.SKIP:
            self.seeds = seeds 
        if storage is not APIHelper.SKIP:
            self.storage = storage 
        if supplies is not APIHelper.SKIP:
            self.supplies = supplies 
        if taxes is not APIHelper.SKIP:
            self.taxes = taxes 
        if utilities is not APIHelper.SKIP:
            self.utilities = utilities 
        if veterinary is not APIHelper.SKIP:
            self.veterinary = veterinary 
        if other_expenses is not APIHelper.SKIP:
            self.other_expenses = other_expenses 
        if capital_expenditures is not APIHelper.SKIP:
            self.capital_expenditures = capital_expenditures 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        tax_year = dictionary.get("taxYear") if dictionary.get("taxYear") else APIHelper.SKIP
        corrected = dictionary.get("corrected") if "corrected" in dictionary.keys() else APIHelper.SKIP
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        tax_form_id = dictionary.get("taxFormId") if dictionary.get("taxFormId") else APIHelper.SKIP
        tax_form_date = dateutil.parser.parse(dictionary.get('taxFormDate')).date() if dictionary.get('taxFormDate') else APIHelper.SKIP
        additional_information = dictionary.get("additionalInformation") if dictionary.get("additionalInformation") else APIHelper.SKIP
        tax_form_type = dictionary.get("taxFormType") if dictionary.get("taxFormType") else APIHelper.SKIP
        issuer = TaxParty8.from_dictionary(dictionary.get('issuer')) if 'issuer' in dictionary.keys() else APIHelper.SKIP
        recipient = TaxParty1.from_dictionary(dictionary.get('recipient')) if 'recipient' in dictionary.keys() else APIHelper.SKIP
        attributes = None
        if dictionary.get('attributes') is not None:
            attributes = [TaxFormAttribute.from_dictionary(x) for x in dictionary.get('attributes')]
        else:
            attributes = APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        income_from_production = dictionary.get("incomeFromProduction") if dictionary.get("incomeFromProduction") else APIHelper.SKIP
        coop_distributions = dictionary.get("coopDistributions") if dictionary.get("coopDistributions") else APIHelper.SKIP
        ag_program_payments = dictionary.get("agProgramPayments") if dictionary.get("agProgramPayments") else APIHelper.SKIP
        ccc_loans = dictionary.get("cccLoans") if dictionary.get("cccLoans") else APIHelper.SKIP
        crop_insurance_proceeds = dictionary.get("cropInsuranceProceeds") if dictionary.get("cropInsuranceProceeds") else APIHelper.SKIP
        other_income = None
        if dictionary.get('otherIncome') is not None:
            other_income = [DescriptionAndAmount.from_dictionary(x) for x in dictionary.get('otherIncome')]
        else:
            other_income = APIHelper.SKIP
        car_and_truck = dictionary.get("carAndTruck") if dictionary.get("carAndTruck") else APIHelper.SKIP
        chemicals = dictionary.get("chemicals") if dictionary.get("chemicals") else APIHelper.SKIP
        conservation = dictionary.get("conservation") if dictionary.get("conservation") else APIHelper.SKIP
        custom_hire_expenses = dictionary.get("customHireExpenses") if dictionary.get("customHireExpenses") else APIHelper.SKIP
        depreciation = dictionary.get("depreciation") if dictionary.get("depreciation") else APIHelper.SKIP
        employee_benefit_programs = dictionary.get("employeeBenefitPrograms") if dictionary.get("employeeBenefitPrograms") else APIHelper.SKIP
        feed = dictionary.get("feed") if dictionary.get("feed") else APIHelper.SKIP
        fertilizers = dictionary.get("fertilizers") if dictionary.get("fertilizers") else APIHelper.SKIP
        freight = dictionary.get("freight") if dictionary.get("freight") else APIHelper.SKIP
        fuel = dictionary.get("fuel") if dictionary.get("fuel") else APIHelper.SKIP
        insurance = dictionary.get("insurance") if dictionary.get("insurance") else APIHelper.SKIP
        mortgage_interest = dictionary.get("mortgageInterest") if dictionary.get("mortgageInterest") else APIHelper.SKIP
        other_interest = dictionary.get("otherInterest") if dictionary.get("otherInterest") else APIHelper.SKIP
        labor_hired = dictionary.get("laborHired") if dictionary.get("laborHired") else APIHelper.SKIP
        pension = dictionary.get("pension") if dictionary.get("pension") else APIHelper.SKIP
        equipment_rent = dictionary.get("equipmentRent") if dictionary.get("equipmentRent") else APIHelper.SKIP
        other_rent = dictionary.get("otherRent") if dictionary.get("otherRent") else APIHelper.SKIP
        repairs = dictionary.get("repairs") if dictionary.get("repairs") else APIHelper.SKIP
        seeds = dictionary.get("seeds") if dictionary.get("seeds") else APIHelper.SKIP
        storage = dictionary.get("storage") if dictionary.get("storage") else APIHelper.SKIP
        supplies = dictionary.get("supplies") if dictionary.get("supplies") else APIHelper.SKIP
        taxes = dictionary.get("taxes") if dictionary.get("taxes") else APIHelper.SKIP
        utilities = dictionary.get("utilities") if dictionary.get("utilities") else APIHelper.SKIP
        veterinary = dictionary.get("veterinary") if dictionary.get("veterinary") else APIHelper.SKIP
        other_expenses = None
        if dictionary.get('otherExpenses') is not None:
            other_expenses = [DescriptionAndAmount.from_dictionary(x) for x in dictionary.get('otherExpenses')]
        else:
            other_expenses = APIHelper.SKIP
        capital_expenditures = None
        if dictionary.get('capitalExpenditures') is not None:
            capital_expenditures = [DateAndAmount.from_dictionary(x) for x in dictionary.get('capitalExpenditures')]
        else:
            capital_expenditures = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(tax_year,
                   corrected,
                   account_id,
                   tax_form_id,
                   tax_form_date,
                   additional_information,
                   tax_form_type,
                   issuer,
                   recipient,
                   attributes,
                   error,
                   links,
                   income_from_production,
                   coop_distributions,
                   ag_program_payments,
                   ccc_loans,
                   crop_insurance_proceeds,
                   other_income,
                   car_and_truck,
                   chemicals,
                   conservation,
                   custom_hire_expenses,
                   depreciation,
                   employee_benefit_programs,
                   feed,
                   fertilizers,
                   freight,
                   fuel,
                   insurance,
                   mortgage_interest,
                   other_interest,
                   labor_hired,
                   pension,
                   equipment_rent,
                   other_rent,
                   repairs,
                   seeds,
                   storage,
                   supplies,
                   taxes,
                   utilities,
                   veterinary,
                   other_expenses,
                   capital_expenditures,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!r}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!r}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!r}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!r}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!r}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!r}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!r}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!r}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!r}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!r}, '
                f'error={(self.error if hasattr(self, "error") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'income_from_production={(self.income_from_production if hasattr(self, "income_from_production") else None)!r}, '
                f'coop_distributions={(self.coop_distributions if hasattr(self, "coop_distributions") else None)!r}, '
                f'ag_program_payments={(self.ag_program_payments if hasattr(self, "ag_program_payments") else None)!r}, '
                f'ccc_loans={(self.ccc_loans if hasattr(self, "ccc_loans") else None)!r}, '
                f'crop_insurance_proceeds={(self.crop_insurance_proceeds if hasattr(self, "crop_insurance_proceeds") else None)!r}, '
                f'other_income={(self.other_income if hasattr(self, "other_income") else None)!r}, '
                f'car_and_truck={(self.car_and_truck if hasattr(self, "car_and_truck") else None)!r}, '
                f'chemicals={(self.chemicals if hasattr(self, "chemicals") else None)!r}, '
                f'conservation={(self.conservation if hasattr(self, "conservation") else None)!r}, '
                f'custom_hire_expenses={(self.custom_hire_expenses if hasattr(self, "custom_hire_expenses") else None)!r}, '
                f'depreciation={(self.depreciation if hasattr(self, "depreciation") else None)!r}, '
                f'employee_benefit_programs={(self.employee_benefit_programs if hasattr(self, "employee_benefit_programs") else None)!r}, '
                f'feed={(self.feed if hasattr(self, "feed") else None)!r}, '
                f'fertilizers={(self.fertilizers if hasattr(self, "fertilizers") else None)!r}, '
                f'freight={(self.freight if hasattr(self, "freight") else None)!r}, '
                f'fuel={(self.fuel if hasattr(self, "fuel") else None)!r}, '
                f'insurance={(self.insurance if hasattr(self, "insurance") else None)!r}, '
                f'mortgage_interest={(self.mortgage_interest if hasattr(self, "mortgage_interest") else None)!r}, '
                f'other_interest={(self.other_interest if hasattr(self, "other_interest") else None)!r}, '
                f'labor_hired={(self.labor_hired if hasattr(self, "labor_hired") else None)!r}, '
                f'pension={(self.pension if hasattr(self, "pension") else None)!r}, '
                f'equipment_rent={(self.equipment_rent if hasattr(self, "equipment_rent") else None)!r}, '
                f'other_rent={(self.other_rent if hasattr(self, "other_rent") else None)!r}, '
                f'repairs={(self.repairs if hasattr(self, "repairs") else None)!r}, '
                f'seeds={(self.seeds if hasattr(self, "seeds") else None)!r}, '
                f'storage={(self.storage if hasattr(self, "storage") else None)!r}, '
                f'supplies={(self.supplies if hasattr(self, "supplies") else None)!r}, '
                f'taxes={(self.taxes if hasattr(self, "taxes") else None)!r}, '
                f'utilities={(self.utilities if hasattr(self, "utilities") else None)!r}, '
                f'veterinary={(self.veterinary if hasattr(self, "veterinary") else None)!r}, '
                f'other_expenses={(self.other_expenses if hasattr(self, "other_expenses") else None)!r}, '
                f'capital_expenditures={(self.capital_expenditures if hasattr(self, "capital_expenditures") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!s}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!s}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!s}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!s}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!s}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!s}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!s}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!s}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!s}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!s}, '
                f'error={(self.error if hasattr(self, "error") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'income_from_production={(self.income_from_production if hasattr(self, "income_from_production") else None)!s}, '
                f'coop_distributions={(self.coop_distributions if hasattr(self, "coop_distributions") else None)!s}, '
                f'ag_program_payments={(self.ag_program_payments if hasattr(self, "ag_program_payments") else None)!s}, '
                f'ccc_loans={(self.ccc_loans if hasattr(self, "ccc_loans") else None)!s}, '
                f'crop_insurance_proceeds={(self.crop_insurance_proceeds if hasattr(self, "crop_insurance_proceeds") else None)!s}, '
                f'other_income={(self.other_income if hasattr(self, "other_income") else None)!s}, '
                f'car_and_truck={(self.car_and_truck if hasattr(self, "car_and_truck") else None)!s}, '
                f'chemicals={(self.chemicals if hasattr(self, "chemicals") else None)!s}, '
                f'conservation={(self.conservation if hasattr(self, "conservation") else None)!s}, '
                f'custom_hire_expenses={(self.custom_hire_expenses if hasattr(self, "custom_hire_expenses") else None)!s}, '
                f'depreciation={(self.depreciation if hasattr(self, "depreciation") else None)!s}, '
                f'employee_benefit_programs={(self.employee_benefit_programs if hasattr(self, "employee_benefit_programs") else None)!s}, '
                f'feed={(self.feed if hasattr(self, "feed") else None)!s}, '
                f'fertilizers={(self.fertilizers if hasattr(self, "fertilizers") else None)!s}, '
                f'freight={(self.freight if hasattr(self, "freight") else None)!s}, '
                f'fuel={(self.fuel if hasattr(self, "fuel") else None)!s}, '
                f'insurance={(self.insurance if hasattr(self, "insurance") else None)!s}, '
                f'mortgage_interest={(self.mortgage_interest if hasattr(self, "mortgage_interest") else None)!s}, '
                f'other_interest={(self.other_interest if hasattr(self, "other_interest") else None)!s}, '
                f'labor_hired={(self.labor_hired if hasattr(self, "labor_hired") else None)!s}, '
                f'pension={(self.pension if hasattr(self, "pension") else None)!s}, '
                f'equipment_rent={(self.equipment_rent if hasattr(self, "equipment_rent") else None)!s}, '
                f'other_rent={(self.other_rent if hasattr(self, "other_rent") else None)!s}, '
                f'repairs={(self.repairs if hasattr(self, "repairs") else None)!s}, '
                f'seeds={(self.seeds if hasattr(self, "seeds") else None)!s}, '
                f'storage={(self.storage if hasattr(self, "storage") else None)!s}, '
                f'supplies={(self.supplies if hasattr(self, "supplies") else None)!s}, '
                f'taxes={(self.taxes if hasattr(self, "taxes") else None)!s}, '
                f'utilities={(self.utilities if hasattr(self, "utilities") else None)!s}, '
                f'veterinary={(self.veterinary if hasattr(self, "veterinary") else None)!s}, '
                f'other_expenses={(self.other_expenses if hasattr(self, "other_expenses") else None)!s}, '
                f'capital_expenditures={(self.capital_expenditures if hasattr(self, "capital_expenditures") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
