# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.code_and_amount import CodeAndAmount
from fdxapi.models.error_1 import Error1
from fdxapi.models.hateoas_link import HateoasLink
from fdxapi.models.tax_form_attribute import TaxFormAttribute
from fdxapi.models.tax_party_1 import TaxParty1
from fdxapi.models.tax_party_2 import TaxParty2
from fdxapi.models.tax_party_8 import TaxParty8


class Form1041K11(object):

    """Implementation of the 'Form 1041 K-11' model.

    Beneficiary's Share of Income, Deductions, Credits, etc.

    Attributes:
        tax_year (int): Year for which taxes are being paid
        corrected (bool): True to indicate this is a corrected tax form
        account_id (str): Long-term persistent identity of the source account.
            Not the account number
        tax_form_id (str): Long-term persistent id for this tax form.
            Depending upon the data provider, this may be the same id as the
            enclosing tax statement id, or this may be a different id, or this
            id may be omitted.
        tax_form_date (date): Date of production or delivery of the tax form
        additional_information (str): Additional explanation text or content
            about this tax form
        tax_form_type (TypeFormType1): Enumerated name of the tax form entity
            e.g. "TaxW2"
        issuer (TaxParty8): Issuer's name, address, phone, and TIN. Issuer
            data need only be transmitted on enclosing TaxStatement, if it is
            the same on all its included tax forms.
        recipient (TaxParty1): Recipient's name, address, phone, and TIN.
            Recipient data need only be transmitted on enclosing TaxStatement,
            if it is the same on all its included tax forms.
        attributes (List[TaxFormAttribute]): Additional attributes for this
            tax form when defined fields are not available. Some specific
            additional attributes already defined by providers: Fields
            required by [IRS
            FIRE](https://www.irs.gov/e-file-providers/filing-information-retur
            ns-electronically-fire): Name Control, Type of Identification
            Number (EIN, SSN, ITIN, ATIN). (ATIN is tax ID number for pending
            adoptions.) Tax form provider field for taxpayer notification:
            Recipient Email Address.
        error (Error1): Present if an error was encountered while retrieving
            this form
        links (List[HateoasLink]): Links to retrieve this form as data or
            image, or to invoke other APIs
        final_k_1 (bool): Final K-1
        amended_k_1 (bool): Amended K-1
        fiscal_year_begin (date): Fiscal year begin date
        fiscal_year_end (date): Fiscal year end date
        form_1041_t (bool): Box D, Check if Form 1041-T was filed
        date_1041_t (date): Box D, and enter the date it was filed
        final_1041 (bool): Box E, Check if this is the final Form 1041 for the
            estate or trust
        domestic (bool): Box H, Domestic beneficiary
        foreign (bool): Box H, Foreign beneficiary
        interest_income (float): Box 1, Interest income
        ordinary_dividends (float): Box 2a, Ordinary dividends
        qualified_dividends (float): Box 2b, Qualified dividends
        net_short_term_gain (float): Box 3, Net short-term capital gain
        net_long_term_gain (float): Box 4a, Net long-term capital gain
        gain_28_rate (float): Box 4b, 28% rate gain
        unrecaptured_1250_gain (float): Box 4c, Unrecaptured section 1250 gain
        other_portfolio_income (float): Box 5, Other portfolio and nonbusiness
            income
        ordinary_business_income (float): Box 6, Ordinary business income
        net_rental_real_estate_income (float): Box 7, Net rental real estate
            income
        other_rental_income (float): Box 8, Other rental income
        directly_apportioned_deductions (List[CodeAndAmount]): Box 9, Directly
            apportioned deductions
        estate_tax_deduction (float): Box 10, Estate tax deduction
        final_year_deductions (List[CodeAndAmount]): Box 11, Final year
            deductions
        fiduciary (TaxParty2): Box C, Fiduciary's name and address
        amt_adjustments (List[CodeAndAmount]): Box 12, Alternative minimum tax
            adjustment
        credits (List[CodeAndAmount]): Box 13, Credits and credit recapture
        other_info (List[CodeAndAmount]): Box 14, Other information
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "tax_year": 'taxYear',
        "corrected": 'corrected',
        "account_id": 'accountId',
        "tax_form_id": 'taxFormId',
        "tax_form_date": 'taxFormDate',
        "additional_information": 'additionalInformation',
        "tax_form_type": 'taxFormType',
        "issuer": 'issuer',
        "recipient": 'recipient',
        "attributes": 'attributes',
        "error": 'error',
        "links": 'links',
        "final_k_1": 'finalK1',
        "amended_k_1": 'amendedK1',
        "fiscal_year_begin": 'fiscalYearBegin',
        "fiscal_year_end": 'fiscalYearEnd',
        "form_1041_t": 'form1041T',
        "date_1041_t": 'date1041T',
        "final_1041": 'final1041',
        "domestic": 'domestic',
        "foreign": 'foreign',
        "interest_income": 'interestIncome',
        "ordinary_dividends": 'ordinaryDividends',
        "qualified_dividends": 'qualifiedDividends',
        "net_short_term_gain": 'netShortTermGain',
        "net_long_term_gain": 'netLongTermGain',
        "gain_28_rate": 'gain28Rate',
        "unrecaptured_1250_gain": 'unrecaptured1250Gain',
        "other_portfolio_income": 'otherPortfolioIncome',
        "ordinary_business_income": 'ordinaryBusinessIncome',
        "net_rental_real_estate_income": 'netRentalRealEstateIncome',
        "other_rental_income": 'otherRentalIncome',
        "directly_apportioned_deductions": 'directlyApportionedDeductions',
        "estate_tax_deduction": 'estateTaxDeduction',
        "final_year_deductions": 'finalYearDeductions',
        "fiduciary": 'fiduciary',
        "amt_adjustments": 'amtAdjustments',
        "credits": 'credits',
        "other_info": 'otherInfo'
    }

    _optionals = [
        'tax_year',
        'corrected',
        'account_id',
        'tax_form_id',
        'tax_form_date',
        'additional_information',
        'tax_form_type',
        'issuer',
        'recipient',
        'attributes',
        'error',
        'links',
        'final_k_1',
        'amended_k_1',
        'fiscal_year_begin',
        'fiscal_year_end',
        'form_1041_t',
        'date_1041_t',
        'final_1041',
        'domestic',
        'foreign',
        'interest_income',
        'ordinary_dividends',
        'qualified_dividends',
        'net_short_term_gain',
        'net_long_term_gain',
        'gain_28_rate',
        'unrecaptured_1250_gain',
        'other_portfolio_income',
        'ordinary_business_income',
        'net_rental_real_estate_income',
        'other_rental_income',
        'directly_apportioned_deductions',
        'estate_tax_deduction',
        'final_year_deductions',
        'fiduciary',
        'amt_adjustments',
        'credits',
        'other_info',
    ]

    def __init__(self,
                 tax_year=APIHelper.SKIP,
                 corrected=APIHelper.SKIP,
                 account_id=APIHelper.SKIP,
                 tax_form_id=APIHelper.SKIP,
                 tax_form_date=APIHelper.SKIP,
                 additional_information=APIHelper.SKIP,
                 tax_form_type=APIHelper.SKIP,
                 issuer=APIHelper.SKIP,
                 recipient=APIHelper.SKIP,
                 attributes=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 final_k_1=APIHelper.SKIP,
                 amended_k_1=APIHelper.SKIP,
                 fiscal_year_begin=APIHelper.SKIP,
                 fiscal_year_end=APIHelper.SKIP,
                 form_1041_t=APIHelper.SKIP,
                 date_1041_t=APIHelper.SKIP,
                 final_1041=APIHelper.SKIP,
                 domestic=APIHelper.SKIP,
                 foreign=APIHelper.SKIP,
                 interest_income=APIHelper.SKIP,
                 ordinary_dividends=APIHelper.SKIP,
                 qualified_dividends=APIHelper.SKIP,
                 net_short_term_gain=APIHelper.SKIP,
                 net_long_term_gain=APIHelper.SKIP,
                 gain_28_rate=APIHelper.SKIP,
                 unrecaptured_1250_gain=APIHelper.SKIP,
                 other_portfolio_income=APIHelper.SKIP,
                 ordinary_business_income=APIHelper.SKIP,
                 net_rental_real_estate_income=APIHelper.SKIP,
                 other_rental_income=APIHelper.SKIP,
                 directly_apportioned_deductions=APIHelper.SKIP,
                 estate_tax_deduction=APIHelper.SKIP,
                 final_year_deductions=APIHelper.SKIP,
                 fiduciary=APIHelper.SKIP,
                 amt_adjustments=APIHelper.SKIP,
                 credits=APIHelper.SKIP,
                 other_info=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the Form1041K11 class"""

        # Initialize members of the class
        if tax_year is not APIHelper.SKIP:
            self.tax_year = tax_year 
        if corrected is not APIHelper.SKIP:
            self.corrected = corrected 
        if account_id is not APIHelper.SKIP:
            self.account_id = account_id 
        if tax_form_id is not APIHelper.SKIP:
            self.tax_form_id = tax_form_id 
        if tax_form_date is not APIHelper.SKIP:
            self.tax_form_date = tax_form_date 
        if additional_information is not APIHelper.SKIP:
            self.additional_information = additional_information 
        if tax_form_type is not APIHelper.SKIP:
            self.tax_form_type = tax_form_type 
        if issuer is not APIHelper.SKIP:
            self.issuer = issuer 
        if recipient is not APIHelper.SKIP:
            self.recipient = recipient 
        if attributes is not APIHelper.SKIP:
            self.attributes = attributes 
        if error is not APIHelper.SKIP:
            self.error = error 
        if links is not APIHelper.SKIP:
            self.links = links 
        if final_k_1 is not APIHelper.SKIP:
            self.final_k_1 = final_k_1 
        if amended_k_1 is not APIHelper.SKIP:
            self.amended_k_1 = amended_k_1 
        if fiscal_year_begin is not APIHelper.SKIP:
            self.fiscal_year_begin = fiscal_year_begin 
        if fiscal_year_end is not APIHelper.SKIP:
            self.fiscal_year_end = fiscal_year_end 
        if form_1041_t is not APIHelper.SKIP:
            self.form_1041_t = form_1041_t 
        if date_1041_t is not APIHelper.SKIP:
            self.date_1041_t = date_1041_t 
        if final_1041 is not APIHelper.SKIP:
            self.final_1041 = final_1041 
        if domestic is not APIHelper.SKIP:
            self.domestic = domestic 
        if foreign is not APIHelper.SKIP:
            self.foreign = foreign 
        if interest_income is not APIHelper.SKIP:
            self.interest_income = interest_income 
        if ordinary_dividends is not APIHelper.SKIP:
            self.ordinary_dividends = ordinary_dividends 
        if qualified_dividends is not APIHelper.SKIP:
            self.qualified_dividends = qualified_dividends 
        if net_short_term_gain is not APIHelper.SKIP:
            self.net_short_term_gain = net_short_term_gain 
        if net_long_term_gain is not APIHelper.SKIP:
            self.net_long_term_gain = net_long_term_gain 
        if gain_28_rate is not APIHelper.SKIP:
            self.gain_28_rate = gain_28_rate 
        if unrecaptured_1250_gain is not APIHelper.SKIP:
            self.unrecaptured_1250_gain = unrecaptured_1250_gain 
        if other_portfolio_income is not APIHelper.SKIP:
            self.other_portfolio_income = other_portfolio_income 
        if ordinary_business_income is not APIHelper.SKIP:
            self.ordinary_business_income = ordinary_business_income 
        if net_rental_real_estate_income is not APIHelper.SKIP:
            self.net_rental_real_estate_income = net_rental_real_estate_income 
        if other_rental_income is not APIHelper.SKIP:
            self.other_rental_income = other_rental_income 
        if directly_apportioned_deductions is not APIHelper.SKIP:
            self.directly_apportioned_deductions = directly_apportioned_deductions 
        if estate_tax_deduction is not APIHelper.SKIP:
            self.estate_tax_deduction = estate_tax_deduction 
        if final_year_deductions is not APIHelper.SKIP:
            self.final_year_deductions = final_year_deductions 
        if fiduciary is not APIHelper.SKIP:
            self.fiduciary = fiduciary 
        if amt_adjustments is not APIHelper.SKIP:
            self.amt_adjustments = amt_adjustments 
        if credits is not APIHelper.SKIP:
            self.credits = credits 
        if other_info is not APIHelper.SKIP:
            self.other_info = other_info 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        tax_year = dictionary.get("taxYear") if dictionary.get("taxYear") else APIHelper.SKIP
        corrected = dictionary.get("corrected") if "corrected" in dictionary.keys() else APIHelper.SKIP
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        tax_form_id = dictionary.get("taxFormId") if dictionary.get("taxFormId") else APIHelper.SKIP
        tax_form_date = dateutil.parser.parse(dictionary.get('taxFormDate')).date() if dictionary.get('taxFormDate') else APIHelper.SKIP
        additional_information = dictionary.get("additionalInformation") if dictionary.get("additionalInformation") else APIHelper.SKIP
        tax_form_type = dictionary.get("taxFormType") if dictionary.get("taxFormType") else APIHelper.SKIP
        issuer = TaxParty8.from_dictionary(dictionary.get('issuer')) if 'issuer' in dictionary.keys() else APIHelper.SKIP
        recipient = TaxParty1.from_dictionary(dictionary.get('recipient')) if 'recipient' in dictionary.keys() else APIHelper.SKIP
        attributes = None
        if dictionary.get('attributes') is not None:
            attributes = [TaxFormAttribute.from_dictionary(x) for x in dictionary.get('attributes')]
        else:
            attributes = APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        final_k_1 = dictionary.get("finalK1") if "finalK1" in dictionary.keys() else APIHelper.SKIP
        amended_k_1 = dictionary.get("amendedK1") if "amendedK1" in dictionary.keys() else APIHelper.SKIP
        fiscal_year_begin = dateutil.parser.parse(dictionary.get('fiscalYearBegin')).date() if dictionary.get('fiscalYearBegin') else APIHelper.SKIP
        fiscal_year_end = dateutil.parser.parse(dictionary.get('fiscalYearEnd')).date() if dictionary.get('fiscalYearEnd') else APIHelper.SKIP
        form_1041_t = dictionary.get("form1041T") if "form1041T" in dictionary.keys() else APIHelper.SKIP
        date_1041_t = dateutil.parser.parse(dictionary.get('date1041T')).date() if dictionary.get('date1041T') else APIHelper.SKIP
        final_1041 = dictionary.get("final1041") if "final1041" in dictionary.keys() else APIHelper.SKIP
        domestic = dictionary.get("domestic") if "domestic" in dictionary.keys() else APIHelper.SKIP
        foreign = dictionary.get("foreign") if "foreign" in dictionary.keys() else APIHelper.SKIP
        interest_income = dictionary.get("interestIncome") if dictionary.get("interestIncome") else APIHelper.SKIP
        ordinary_dividends = dictionary.get("ordinaryDividends") if dictionary.get("ordinaryDividends") else APIHelper.SKIP
        qualified_dividends = dictionary.get("qualifiedDividends") if dictionary.get("qualifiedDividends") else APIHelper.SKIP
        net_short_term_gain = dictionary.get("netShortTermGain") if dictionary.get("netShortTermGain") else APIHelper.SKIP
        net_long_term_gain = dictionary.get("netLongTermGain") if dictionary.get("netLongTermGain") else APIHelper.SKIP
        gain_28_rate = dictionary.get("gain28Rate") if dictionary.get("gain28Rate") else APIHelper.SKIP
        unrecaptured_1250_gain = dictionary.get("unrecaptured1250Gain") if dictionary.get("unrecaptured1250Gain") else APIHelper.SKIP
        other_portfolio_income = dictionary.get("otherPortfolioIncome") if dictionary.get("otherPortfolioIncome") else APIHelper.SKIP
        ordinary_business_income = dictionary.get("ordinaryBusinessIncome") if dictionary.get("ordinaryBusinessIncome") else APIHelper.SKIP
        net_rental_real_estate_income = dictionary.get("netRentalRealEstateIncome") if dictionary.get("netRentalRealEstateIncome") else APIHelper.SKIP
        other_rental_income = dictionary.get("otherRentalIncome") if dictionary.get("otherRentalIncome") else APIHelper.SKIP
        directly_apportioned_deductions = None
        if dictionary.get('directlyApportionedDeductions') is not None:
            directly_apportioned_deductions = [CodeAndAmount.from_dictionary(x) for x in dictionary.get('directlyApportionedDeductions')]
        else:
            directly_apportioned_deductions = APIHelper.SKIP
        estate_tax_deduction = dictionary.get("estateTaxDeduction") if dictionary.get("estateTaxDeduction") else APIHelper.SKIP
        final_year_deductions = None
        if dictionary.get('finalYearDeductions') is not None:
            final_year_deductions = [CodeAndAmount.from_dictionary(x) for x in dictionary.get('finalYearDeductions')]
        else:
            final_year_deductions = APIHelper.SKIP
        fiduciary = TaxParty2.from_dictionary(dictionary.get('fiduciary')) if 'fiduciary' in dictionary.keys() else APIHelper.SKIP
        amt_adjustments = None
        if dictionary.get('amtAdjustments') is not None:
            amt_adjustments = [CodeAndAmount.from_dictionary(x) for x in dictionary.get('amtAdjustments')]
        else:
            amt_adjustments = APIHelper.SKIP
        credits = None
        if dictionary.get('credits') is not None:
            credits = [CodeAndAmount.from_dictionary(x) for x in dictionary.get('credits')]
        else:
            credits = APIHelper.SKIP
        other_info = None
        if dictionary.get('otherInfo') is not None:
            other_info = [CodeAndAmount.from_dictionary(x) for x in dictionary.get('otherInfo')]
        else:
            other_info = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(tax_year,
                   corrected,
                   account_id,
                   tax_form_id,
                   tax_form_date,
                   additional_information,
                   tax_form_type,
                   issuer,
                   recipient,
                   attributes,
                   error,
                   links,
                   final_k_1,
                   amended_k_1,
                   fiscal_year_begin,
                   fiscal_year_end,
                   form_1041_t,
                   date_1041_t,
                   final_1041,
                   domestic,
                   foreign,
                   interest_income,
                   ordinary_dividends,
                   qualified_dividends,
                   net_short_term_gain,
                   net_long_term_gain,
                   gain_28_rate,
                   unrecaptured_1250_gain,
                   other_portfolio_income,
                   ordinary_business_income,
                   net_rental_real_estate_income,
                   other_rental_income,
                   directly_apportioned_deductions,
                   estate_tax_deduction,
                   final_year_deductions,
                   fiduciary,
                   amt_adjustments,
                   credits,
                   other_info,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!r}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!r}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!r}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!r}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!r}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!r}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!r}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!r}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!r}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!r}, '
                f'error={(self.error if hasattr(self, "error") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'final_k_1={(self.final_k_1 if hasattr(self, "final_k_1") else None)!r}, '
                f'amended_k_1={(self.amended_k_1 if hasattr(self, "amended_k_1") else None)!r}, '
                f'fiscal_year_begin={(self.fiscal_year_begin if hasattr(self, "fiscal_year_begin") else None)!r}, '
                f'fiscal_year_end={(self.fiscal_year_end if hasattr(self, "fiscal_year_end") else None)!r}, '
                f'form_1041_t={(self.form_1041_t if hasattr(self, "form_1041_t") else None)!r}, '
                f'date_1041_t={(self.date_1041_t if hasattr(self, "date_1041_t") else None)!r}, '
                f'final_1041={(self.final_1041 if hasattr(self, "final_1041") else None)!r}, '
                f'domestic={(self.domestic if hasattr(self, "domestic") else None)!r}, '
                f'foreign={(self.foreign if hasattr(self, "foreign") else None)!r}, '
                f'interest_income={(self.interest_income if hasattr(self, "interest_income") else None)!r}, '
                f'ordinary_dividends={(self.ordinary_dividends if hasattr(self, "ordinary_dividends") else None)!r}, '
                f'qualified_dividends={(self.qualified_dividends if hasattr(self, "qualified_dividends") else None)!r}, '
                f'net_short_term_gain={(self.net_short_term_gain if hasattr(self, "net_short_term_gain") else None)!r}, '
                f'net_long_term_gain={(self.net_long_term_gain if hasattr(self, "net_long_term_gain") else None)!r}, '
                f'gain_28_rate={(self.gain_28_rate if hasattr(self, "gain_28_rate") else None)!r}, '
                f'unrecaptured_1250_gain={(self.unrecaptured_1250_gain if hasattr(self, "unrecaptured_1250_gain") else None)!r}, '
                f'other_portfolio_income={(self.other_portfolio_income if hasattr(self, "other_portfolio_income") else None)!r}, '
                f'ordinary_business_income={(self.ordinary_business_income if hasattr(self, "ordinary_business_income") else None)!r}, '
                f'net_rental_real_estate_income={(self.net_rental_real_estate_income if hasattr(self, "net_rental_real_estate_income") else None)!r}, '
                f'other_rental_income={(self.other_rental_income if hasattr(self, "other_rental_income") else None)!r}, '
                f'directly_apportioned_deductions={(self.directly_apportioned_deductions if hasattr(self, "directly_apportioned_deductions") else None)!r}, '
                f'estate_tax_deduction={(self.estate_tax_deduction if hasattr(self, "estate_tax_deduction") else None)!r}, '
                f'final_year_deductions={(self.final_year_deductions if hasattr(self, "final_year_deductions") else None)!r}, '
                f'fiduciary={(self.fiduciary if hasattr(self, "fiduciary") else None)!r}, '
                f'amt_adjustments={(self.amt_adjustments if hasattr(self, "amt_adjustments") else None)!r}, '
                f'credits={(self.credits if hasattr(self, "credits") else None)!r}, '
                f'other_info={(self.other_info if hasattr(self, "other_info") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!s}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!s}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!s}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!s}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!s}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!s}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!s}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!s}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!s}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!s}, '
                f'error={(self.error if hasattr(self, "error") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'final_k_1={(self.final_k_1 if hasattr(self, "final_k_1") else None)!s}, '
                f'amended_k_1={(self.amended_k_1 if hasattr(self, "amended_k_1") else None)!s}, '
                f'fiscal_year_begin={(self.fiscal_year_begin if hasattr(self, "fiscal_year_begin") else None)!s}, '
                f'fiscal_year_end={(self.fiscal_year_end if hasattr(self, "fiscal_year_end") else None)!s}, '
                f'form_1041_t={(self.form_1041_t if hasattr(self, "form_1041_t") else None)!s}, '
                f'date_1041_t={(self.date_1041_t if hasattr(self, "date_1041_t") else None)!s}, '
                f'final_1041={(self.final_1041 if hasattr(self, "final_1041") else None)!s}, '
                f'domestic={(self.domestic if hasattr(self, "domestic") else None)!s}, '
                f'foreign={(self.foreign if hasattr(self, "foreign") else None)!s}, '
                f'interest_income={(self.interest_income if hasattr(self, "interest_income") else None)!s}, '
                f'ordinary_dividends={(self.ordinary_dividends if hasattr(self, "ordinary_dividends") else None)!s}, '
                f'qualified_dividends={(self.qualified_dividends if hasattr(self, "qualified_dividends") else None)!s}, '
                f'net_short_term_gain={(self.net_short_term_gain if hasattr(self, "net_short_term_gain") else None)!s}, '
                f'net_long_term_gain={(self.net_long_term_gain if hasattr(self, "net_long_term_gain") else None)!s}, '
                f'gain_28_rate={(self.gain_28_rate if hasattr(self, "gain_28_rate") else None)!s}, '
                f'unrecaptured_1250_gain={(self.unrecaptured_1250_gain if hasattr(self, "unrecaptured_1250_gain") else None)!s}, '
                f'other_portfolio_income={(self.other_portfolio_income if hasattr(self, "other_portfolio_income") else None)!s}, '
                f'ordinary_business_income={(self.ordinary_business_income if hasattr(self, "ordinary_business_income") else None)!s}, '
                f'net_rental_real_estate_income={(self.net_rental_real_estate_income if hasattr(self, "net_rental_real_estate_income") else None)!s}, '
                f'other_rental_income={(self.other_rental_income if hasattr(self, "other_rental_income") else None)!s}, '
                f'directly_apportioned_deductions={(self.directly_apportioned_deductions if hasattr(self, "directly_apportioned_deductions") else None)!s}, '
                f'estate_tax_deduction={(self.estate_tax_deduction if hasattr(self, "estate_tax_deduction") else None)!s}, '
                f'final_year_deductions={(self.final_year_deductions if hasattr(self, "final_year_deductions") else None)!s}, '
                f'fiduciary={(self.fiduciary if hasattr(self, "fiduciary") else None)!s}, '
                f'amt_adjustments={(self.amt_adjustments if hasattr(self, "amt_adjustments") else None)!s}, '
                f'credits={(self.credits if hasattr(self, "credits") else None)!s}, '
                f'other_info={(self.other_info if hasattr(self, "other_info") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
