# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.error_1 import Error1
from fdxapi.models.form_1042_s_agent_1 import Form1042SAgent1
from fdxapi.models.form_1042_s_agent_2 import Form1042SAgent2
from fdxapi.models.form_1042_s_agent_3 import Form1042SAgent3
from fdxapi.models.form_1042_s_agent_4 import Form1042SAgent4
from fdxapi.models.form_1042_s_recipient_1 import Form1042SRecipient1
from fdxapi.models.hateoas_link import HateoasLink
from fdxapi.models.state_and_local_tax_withholding_1 import StateAndLocalTaxWithholding1
from fdxapi.models.tax_form_attribute import TaxFormAttribute
from fdxapi.models.tax_party_1 import TaxParty1
from fdxapi.models.tax_party_8 import TaxParty8


class Form1042S1(object):

    """Implementation of the 'Form 1042-S1' model.

    Foreign Person's U.S. Source Income Subject to Withholding

    Attributes:
        tax_year (int): Year for which taxes are being paid
        corrected (bool): True to indicate this is a corrected tax form
        account_id (str): Long-term persistent identity of the source account.
            Not the account number
        tax_form_id (str): Long-term persistent id for this tax form.
            Depending upon the data provider, this may be the same id as the
            enclosing tax statement id, or this may be a different id, or this
            id may be omitted.
        tax_form_date (date): Date of production or delivery of the tax form
        additional_information (str): Additional explanation text or content
            about this tax form
        tax_form_type (TypeFormType1): Enumerated name of the tax form entity
            e.g. "TaxW2"
        issuer (TaxParty8): Issuer's name, address, phone, and TIN. Issuer
            data need only be transmitted on enclosing TaxStatement, if it is
            the same on all its included tax forms.
        recipient (TaxParty1): Recipient's name, address, phone, and TIN.
            Recipient data need only be transmitted on enclosing TaxStatement,
            if it is the same on all its included tax forms.
        attributes (List[TaxFormAttribute]): Additional attributes for this
            tax form when defined fields are not available. Some specific
            additional attributes already defined by providers: Fields
            required by [IRS
            FIRE](https://www.irs.gov/e-file-providers/filing-information-retur
            ns-electronically-fire): Name Control, Type of Identification
            Number (EIN, SSN, ITIN, ATIN). (ATIN is tax ID number for pending
            adoptions.) Tax form provider field for taxpayer notification:
            Recipient Email Address.
        error (Error1): Present if an error was encountered while retrieving
            this form
        links (List[HateoasLink]): Links to retrieve this form as data or
            image, or to invoke other APIs
        form_id (str): Unique form identifier
        amended (bool): Amended
        amendment_number (int): Amendment number
        income_type_code (str): Box 1, Income code
        gross_income (float): Box 2, Gross income
        chapter_indicator (str): Box 3, Chapter indicator
        ch_3_exemption_code (str): Box 3a, Exemption code
        ch_3_tax_rate (float): Box 3b, Tax rate
        ch_4_exemption_code (str): Box 4a, Exemption code
        ch_4_tax_rate (float): Box 4b, Tax rate
        withholding_allowance (float): Box 5, Withholding allowance
        net_income (float): Box 6, Net income
        federal_tax_withheld (float): Box 7a, Federal tax withheld
        escrow_procedures_applied (bool): Box 7b, Check if federal tax
            withheld was not deposited with the IRS because escrow procedures
            were applied
        subsequent_year (bool): Box 7c, Check if withholding occurred in
            subsequent year with respect to a partnership interest
        other_agents_tax_withheld (float): Box 8, Tax withheld by other agents
        recipient_repaid_amount (float): Box 9, Overwithheld tax repaid to
            recipient pursuant to adjustment procedures
        total_tax_withholding_credit (float): Box 10, Total withholding credit
        withholding_agent_tax_paid (float): Box 11, Tax paid by withholding
            agent (amounts not withheld)
        withholding_agent (Form1042SAgent1): Boxes 12a-i, Withholding agent
        form_1042_recipient (Form1042SRecipient1): Boxes 13a-j, 13l, Recipient
            for Form 1042-S
        account_number (str): Box 13k, Recipient account number
        primary (Form1042SAgent2): Boxes 14a-b, Primary Withholding Agent
        prorata_basis_reporting (bool): Box 15, Check if pro-rata basis
            reporting
        intermediary (Form1042SAgent3): Boxes 15a-i, Intermediary or flow thru
            entity
        payer (Form1042SAgent4): Boxes 16a-e, Payer
        state_and_local (StateAndLocalTaxWithholding1): Box 17, State and
            Local tax withholding
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "tax_year": 'taxYear',
        "corrected": 'corrected',
        "account_id": 'accountId',
        "tax_form_id": 'taxFormId',
        "tax_form_date": 'taxFormDate',
        "additional_information": 'additionalInformation',
        "tax_form_type": 'taxFormType',
        "issuer": 'issuer',
        "recipient": 'recipient',
        "attributes": 'attributes',
        "error": 'error',
        "links": 'links',
        "form_id": 'formId',
        "amended": 'amended',
        "amendment_number": 'amendmentNumber',
        "income_type_code": 'incomeTypeCode',
        "gross_income": 'grossIncome',
        "chapter_indicator": 'chapterIndicator',
        "ch_3_exemption_code": 'ch3ExemptionCode',
        "ch_3_tax_rate": 'ch3TaxRate',
        "ch_4_exemption_code": 'ch4ExemptionCode',
        "ch_4_tax_rate": 'ch4TaxRate',
        "withholding_allowance": 'withholdingAllowance',
        "net_income": 'netIncome',
        "federal_tax_withheld": 'federalTaxWithheld',
        "escrow_procedures_applied": 'escrowProceduresApplied',
        "subsequent_year": 'subsequentYear',
        "other_agents_tax_withheld": 'otherAgentsTaxWithheld',
        "recipient_repaid_amount": 'recipientRepaidAmount',
        "total_tax_withholding_credit": 'totalTaxWithholdingCredit',
        "withholding_agent_tax_paid": 'withholdingAgentTaxPaid',
        "withholding_agent": 'withholdingAgent',
        "form_1042_recipient": 'form1042Recipient',
        "account_number": 'accountNumber',
        "primary": 'primary',
        "prorata_basis_reporting": 'prorataBasisReporting',
        "intermediary": 'intermediary',
        "payer": 'payer',
        "state_and_local": 'stateAndLocal'
    }

    _optionals = [
        'tax_year',
        'corrected',
        'account_id',
        'tax_form_id',
        'tax_form_date',
        'additional_information',
        'tax_form_type',
        'issuer',
        'recipient',
        'attributes',
        'error',
        'links',
        'form_id',
        'amended',
        'amendment_number',
        'income_type_code',
        'gross_income',
        'chapter_indicator',
        'ch_3_exemption_code',
        'ch_3_tax_rate',
        'ch_4_exemption_code',
        'ch_4_tax_rate',
        'withholding_allowance',
        'net_income',
        'federal_tax_withheld',
        'escrow_procedures_applied',
        'subsequent_year',
        'other_agents_tax_withheld',
        'recipient_repaid_amount',
        'total_tax_withholding_credit',
        'withholding_agent_tax_paid',
        'withholding_agent',
        'form_1042_recipient',
        'account_number',
        'primary',
        'prorata_basis_reporting',
        'intermediary',
        'payer',
        'state_and_local',
    ]

    def __init__(self,
                 tax_year=APIHelper.SKIP,
                 corrected=APIHelper.SKIP,
                 account_id=APIHelper.SKIP,
                 tax_form_id=APIHelper.SKIP,
                 tax_form_date=APIHelper.SKIP,
                 additional_information=APIHelper.SKIP,
                 tax_form_type=APIHelper.SKIP,
                 issuer=APIHelper.SKIP,
                 recipient=APIHelper.SKIP,
                 attributes=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 form_id=APIHelper.SKIP,
                 amended=APIHelper.SKIP,
                 amendment_number=APIHelper.SKIP,
                 income_type_code=APIHelper.SKIP,
                 gross_income=APIHelper.SKIP,
                 chapter_indicator=APIHelper.SKIP,
                 ch_3_exemption_code=APIHelper.SKIP,
                 ch_3_tax_rate=APIHelper.SKIP,
                 ch_4_exemption_code=APIHelper.SKIP,
                 ch_4_tax_rate=APIHelper.SKIP,
                 withholding_allowance=APIHelper.SKIP,
                 net_income=APIHelper.SKIP,
                 federal_tax_withheld=APIHelper.SKIP,
                 escrow_procedures_applied=APIHelper.SKIP,
                 subsequent_year=APIHelper.SKIP,
                 other_agents_tax_withheld=APIHelper.SKIP,
                 recipient_repaid_amount=APIHelper.SKIP,
                 total_tax_withholding_credit=APIHelper.SKIP,
                 withholding_agent_tax_paid=APIHelper.SKIP,
                 withholding_agent=APIHelper.SKIP,
                 form_1042_recipient=APIHelper.SKIP,
                 account_number=APIHelper.SKIP,
                 primary=APIHelper.SKIP,
                 prorata_basis_reporting=APIHelper.SKIP,
                 intermediary=APIHelper.SKIP,
                 payer=APIHelper.SKIP,
                 state_and_local=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the Form1042S1 class"""

        # Initialize members of the class
        if tax_year is not APIHelper.SKIP:
            self.tax_year = tax_year 
        if corrected is not APIHelper.SKIP:
            self.corrected = corrected 
        if account_id is not APIHelper.SKIP:
            self.account_id = account_id 
        if tax_form_id is not APIHelper.SKIP:
            self.tax_form_id = tax_form_id 
        if tax_form_date is not APIHelper.SKIP:
            self.tax_form_date = tax_form_date 
        if additional_information is not APIHelper.SKIP:
            self.additional_information = additional_information 
        if tax_form_type is not APIHelper.SKIP:
            self.tax_form_type = tax_form_type 
        if issuer is not APIHelper.SKIP:
            self.issuer = issuer 
        if recipient is not APIHelper.SKIP:
            self.recipient = recipient 
        if attributes is not APIHelper.SKIP:
            self.attributes = attributes 
        if error is not APIHelper.SKIP:
            self.error = error 
        if links is not APIHelper.SKIP:
            self.links = links 
        if form_id is not APIHelper.SKIP:
            self.form_id = form_id 
        if amended is not APIHelper.SKIP:
            self.amended = amended 
        if amendment_number is not APIHelper.SKIP:
            self.amendment_number = amendment_number 
        if income_type_code is not APIHelper.SKIP:
            self.income_type_code = income_type_code 
        if gross_income is not APIHelper.SKIP:
            self.gross_income = gross_income 
        if chapter_indicator is not APIHelper.SKIP:
            self.chapter_indicator = chapter_indicator 
        if ch_3_exemption_code is not APIHelper.SKIP:
            self.ch_3_exemption_code = ch_3_exemption_code 
        if ch_3_tax_rate is not APIHelper.SKIP:
            self.ch_3_tax_rate = ch_3_tax_rate 
        if ch_4_exemption_code is not APIHelper.SKIP:
            self.ch_4_exemption_code = ch_4_exemption_code 
        if ch_4_tax_rate is not APIHelper.SKIP:
            self.ch_4_tax_rate = ch_4_tax_rate 
        if withholding_allowance is not APIHelper.SKIP:
            self.withholding_allowance = withholding_allowance 
        if net_income is not APIHelper.SKIP:
            self.net_income = net_income 
        if federal_tax_withheld is not APIHelper.SKIP:
            self.federal_tax_withheld = federal_tax_withheld 
        if escrow_procedures_applied is not APIHelper.SKIP:
            self.escrow_procedures_applied = escrow_procedures_applied 
        if subsequent_year is not APIHelper.SKIP:
            self.subsequent_year = subsequent_year 
        if other_agents_tax_withheld is not APIHelper.SKIP:
            self.other_agents_tax_withheld = other_agents_tax_withheld 
        if recipient_repaid_amount is not APIHelper.SKIP:
            self.recipient_repaid_amount = recipient_repaid_amount 
        if total_tax_withholding_credit is not APIHelper.SKIP:
            self.total_tax_withholding_credit = total_tax_withholding_credit 
        if withholding_agent_tax_paid is not APIHelper.SKIP:
            self.withholding_agent_tax_paid = withholding_agent_tax_paid 
        if withholding_agent is not APIHelper.SKIP:
            self.withholding_agent = withholding_agent 
        if form_1042_recipient is not APIHelper.SKIP:
            self.form_1042_recipient = form_1042_recipient 
        if account_number is not APIHelper.SKIP:
            self.account_number = account_number 
        if primary is not APIHelper.SKIP:
            self.primary = primary 
        if prorata_basis_reporting is not APIHelper.SKIP:
            self.prorata_basis_reporting = prorata_basis_reporting 
        if intermediary is not APIHelper.SKIP:
            self.intermediary = intermediary 
        if payer is not APIHelper.SKIP:
            self.payer = payer 
        if state_and_local is not APIHelper.SKIP:
            self.state_and_local = state_and_local 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        tax_year = dictionary.get("taxYear") if dictionary.get("taxYear") else APIHelper.SKIP
        corrected = dictionary.get("corrected") if "corrected" in dictionary.keys() else APIHelper.SKIP
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        tax_form_id = dictionary.get("taxFormId") if dictionary.get("taxFormId") else APIHelper.SKIP
        tax_form_date = dateutil.parser.parse(dictionary.get('taxFormDate')).date() if dictionary.get('taxFormDate') else APIHelper.SKIP
        additional_information = dictionary.get("additionalInformation") if dictionary.get("additionalInformation") else APIHelper.SKIP
        tax_form_type = dictionary.get("taxFormType") if dictionary.get("taxFormType") else APIHelper.SKIP
        issuer = TaxParty8.from_dictionary(dictionary.get('issuer')) if 'issuer' in dictionary.keys() else APIHelper.SKIP
        recipient = TaxParty1.from_dictionary(dictionary.get('recipient')) if 'recipient' in dictionary.keys() else APIHelper.SKIP
        attributes = None
        if dictionary.get('attributes') is not None:
            attributes = [TaxFormAttribute.from_dictionary(x) for x in dictionary.get('attributes')]
        else:
            attributes = APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        form_id = dictionary.get("formId") if dictionary.get("formId") else APIHelper.SKIP
        amended = dictionary.get("amended") if "amended" in dictionary.keys() else APIHelper.SKIP
        amendment_number = dictionary.get("amendmentNumber") if dictionary.get("amendmentNumber") else APIHelper.SKIP
        income_type_code = dictionary.get("incomeTypeCode") if dictionary.get("incomeTypeCode") else APIHelper.SKIP
        gross_income = dictionary.get("grossIncome") if dictionary.get("grossIncome") else APIHelper.SKIP
        chapter_indicator = dictionary.get("chapterIndicator") if dictionary.get("chapterIndicator") else APIHelper.SKIP
        ch_3_exemption_code = dictionary.get("ch3ExemptionCode") if dictionary.get("ch3ExemptionCode") else APIHelper.SKIP
        ch_3_tax_rate = dictionary.get("ch3TaxRate") if dictionary.get("ch3TaxRate") else APIHelper.SKIP
        ch_4_exemption_code = dictionary.get("ch4ExemptionCode") if dictionary.get("ch4ExemptionCode") else APIHelper.SKIP
        ch_4_tax_rate = dictionary.get("ch4TaxRate") if dictionary.get("ch4TaxRate") else APIHelper.SKIP
        withholding_allowance = dictionary.get("withholdingAllowance") if dictionary.get("withholdingAllowance") else APIHelper.SKIP
        net_income = dictionary.get("netIncome") if dictionary.get("netIncome") else APIHelper.SKIP
        federal_tax_withheld = dictionary.get("federalTaxWithheld") if dictionary.get("federalTaxWithheld") else APIHelper.SKIP
        escrow_procedures_applied = dictionary.get("escrowProceduresApplied") if "escrowProceduresApplied" in dictionary.keys() else APIHelper.SKIP
        subsequent_year = dictionary.get("subsequentYear") if "subsequentYear" in dictionary.keys() else APIHelper.SKIP
        other_agents_tax_withheld = dictionary.get("otherAgentsTaxWithheld") if dictionary.get("otherAgentsTaxWithheld") else APIHelper.SKIP
        recipient_repaid_amount = dictionary.get("recipientRepaidAmount") if dictionary.get("recipientRepaidAmount") else APIHelper.SKIP
        total_tax_withholding_credit = dictionary.get("totalTaxWithholdingCredit") if dictionary.get("totalTaxWithholdingCredit") else APIHelper.SKIP
        withholding_agent_tax_paid = dictionary.get("withholdingAgentTaxPaid") if dictionary.get("withholdingAgentTaxPaid") else APIHelper.SKIP
        withholding_agent = Form1042SAgent1.from_dictionary(dictionary.get('withholdingAgent')) if 'withholdingAgent' in dictionary.keys() else APIHelper.SKIP
        form_1042_recipient = Form1042SRecipient1.from_dictionary(dictionary.get('form1042Recipient')) if 'form1042Recipient' in dictionary.keys() else APIHelper.SKIP
        account_number = dictionary.get("accountNumber") if dictionary.get("accountNumber") else APIHelper.SKIP
        primary = Form1042SAgent2.from_dictionary(dictionary.get('primary')) if 'primary' in dictionary.keys() else APIHelper.SKIP
        prorata_basis_reporting = dictionary.get("prorataBasisReporting") if "prorataBasisReporting" in dictionary.keys() else APIHelper.SKIP
        intermediary = Form1042SAgent3.from_dictionary(dictionary.get('intermediary')) if 'intermediary' in dictionary.keys() else APIHelper.SKIP
        payer = Form1042SAgent4.from_dictionary(dictionary.get('payer')) if 'payer' in dictionary.keys() else APIHelper.SKIP
        state_and_local = StateAndLocalTaxWithholding1.from_dictionary(dictionary.get('stateAndLocal')) if 'stateAndLocal' in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(tax_year,
                   corrected,
                   account_id,
                   tax_form_id,
                   tax_form_date,
                   additional_information,
                   tax_form_type,
                   issuer,
                   recipient,
                   attributes,
                   error,
                   links,
                   form_id,
                   amended,
                   amendment_number,
                   income_type_code,
                   gross_income,
                   chapter_indicator,
                   ch_3_exemption_code,
                   ch_3_tax_rate,
                   ch_4_exemption_code,
                   ch_4_tax_rate,
                   withholding_allowance,
                   net_income,
                   federal_tax_withheld,
                   escrow_procedures_applied,
                   subsequent_year,
                   other_agents_tax_withheld,
                   recipient_repaid_amount,
                   total_tax_withholding_credit,
                   withholding_agent_tax_paid,
                   withholding_agent,
                   form_1042_recipient,
                   account_number,
                   primary,
                   prorata_basis_reporting,
                   intermediary,
                   payer,
                   state_and_local,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!r}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!r}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!r}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!r}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!r}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!r}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!r}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!r}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!r}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!r}, '
                f'error={(self.error if hasattr(self, "error") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'form_id={(self.form_id if hasattr(self, "form_id") else None)!r}, '
                f'amended={(self.amended if hasattr(self, "amended") else None)!r}, '
                f'amendment_number={(self.amendment_number if hasattr(self, "amendment_number") else None)!r}, '
                f'income_type_code={(self.income_type_code if hasattr(self, "income_type_code") else None)!r}, '
                f'gross_income={(self.gross_income if hasattr(self, "gross_income") else None)!r}, '
                f'chapter_indicator={(self.chapter_indicator if hasattr(self, "chapter_indicator") else None)!r}, '
                f'ch_3_exemption_code={(self.ch_3_exemption_code if hasattr(self, "ch_3_exemption_code") else None)!r}, '
                f'ch_3_tax_rate={(self.ch_3_tax_rate if hasattr(self, "ch_3_tax_rate") else None)!r}, '
                f'ch_4_exemption_code={(self.ch_4_exemption_code if hasattr(self, "ch_4_exemption_code") else None)!r}, '
                f'ch_4_tax_rate={(self.ch_4_tax_rate if hasattr(self, "ch_4_tax_rate") else None)!r}, '
                f'withholding_allowance={(self.withholding_allowance if hasattr(self, "withholding_allowance") else None)!r}, '
                f'net_income={(self.net_income if hasattr(self, "net_income") else None)!r}, '
                f'federal_tax_withheld={(self.federal_tax_withheld if hasattr(self, "federal_tax_withheld") else None)!r}, '
                f'escrow_procedures_applied={(self.escrow_procedures_applied if hasattr(self, "escrow_procedures_applied") else None)!r}, '
                f'subsequent_year={(self.subsequent_year if hasattr(self, "subsequent_year") else None)!r}, '
                f'other_agents_tax_withheld={(self.other_agents_tax_withheld if hasattr(self, "other_agents_tax_withheld") else None)!r}, '
                f'recipient_repaid_amount={(self.recipient_repaid_amount if hasattr(self, "recipient_repaid_amount") else None)!r}, '
                f'total_tax_withholding_credit={(self.total_tax_withholding_credit if hasattr(self, "total_tax_withholding_credit") else None)!r}, '
                f'withholding_agent_tax_paid={(self.withholding_agent_tax_paid if hasattr(self, "withholding_agent_tax_paid") else None)!r}, '
                f'withholding_agent={(self.withholding_agent if hasattr(self, "withholding_agent") else None)!r}, '
                f'form_1042_recipient={(self.form_1042_recipient if hasattr(self, "form_1042_recipient") else None)!r}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!r}, '
                f'primary={(self.primary if hasattr(self, "primary") else None)!r}, '
                f'prorata_basis_reporting={(self.prorata_basis_reporting if hasattr(self, "prorata_basis_reporting") else None)!r}, '
                f'intermediary={(self.intermediary if hasattr(self, "intermediary") else None)!r}, '
                f'payer={(self.payer if hasattr(self, "payer") else None)!r}, '
                f'state_and_local={(self.state_and_local if hasattr(self, "state_and_local") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!s}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!s}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!s}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!s}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!s}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!s}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!s}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!s}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!s}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!s}, '
                f'error={(self.error if hasattr(self, "error") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'form_id={(self.form_id if hasattr(self, "form_id") else None)!s}, '
                f'amended={(self.amended if hasattr(self, "amended") else None)!s}, '
                f'amendment_number={(self.amendment_number if hasattr(self, "amendment_number") else None)!s}, '
                f'income_type_code={(self.income_type_code if hasattr(self, "income_type_code") else None)!s}, '
                f'gross_income={(self.gross_income if hasattr(self, "gross_income") else None)!s}, '
                f'chapter_indicator={(self.chapter_indicator if hasattr(self, "chapter_indicator") else None)!s}, '
                f'ch_3_exemption_code={(self.ch_3_exemption_code if hasattr(self, "ch_3_exemption_code") else None)!s}, '
                f'ch_3_tax_rate={(self.ch_3_tax_rate if hasattr(self, "ch_3_tax_rate") else None)!s}, '
                f'ch_4_exemption_code={(self.ch_4_exemption_code if hasattr(self, "ch_4_exemption_code") else None)!s}, '
                f'ch_4_tax_rate={(self.ch_4_tax_rate if hasattr(self, "ch_4_tax_rate") else None)!s}, '
                f'withholding_allowance={(self.withholding_allowance if hasattr(self, "withholding_allowance") else None)!s}, '
                f'net_income={(self.net_income if hasattr(self, "net_income") else None)!s}, '
                f'federal_tax_withheld={(self.federal_tax_withheld if hasattr(self, "federal_tax_withheld") else None)!s}, '
                f'escrow_procedures_applied={(self.escrow_procedures_applied if hasattr(self, "escrow_procedures_applied") else None)!s}, '
                f'subsequent_year={(self.subsequent_year if hasattr(self, "subsequent_year") else None)!s}, '
                f'other_agents_tax_withheld={(self.other_agents_tax_withheld if hasattr(self, "other_agents_tax_withheld") else None)!s}, '
                f'recipient_repaid_amount={(self.recipient_repaid_amount if hasattr(self, "recipient_repaid_amount") else None)!s}, '
                f'total_tax_withholding_credit={(self.total_tax_withholding_credit if hasattr(self, "total_tax_withholding_credit") else None)!s}, '
                f'withholding_agent_tax_paid={(self.withholding_agent_tax_paid if hasattr(self, "withholding_agent_tax_paid") else None)!s}, '
                f'withholding_agent={(self.withholding_agent if hasattr(self, "withholding_agent") else None)!s}, '
                f'form_1042_recipient={(self.form_1042_recipient if hasattr(self, "form_1042_recipient") else None)!s}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!s}, '
                f'primary={(self.primary if hasattr(self, "primary") else None)!s}, '
                f'prorata_basis_reporting={(self.prorata_basis_reporting if hasattr(self, "prorata_basis_reporting") else None)!s}, '
                f'intermediary={(self.intermediary if hasattr(self, "intermediary") else None)!s}, '
                f'payer={(self.payer if hasattr(self, "payer") else None)!s}, '
                f'state_and_local={(self.state_and_local if hasattr(self, "state_and_local") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
