# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.code_and_amount import CodeAndAmount
from fdxapi.models.error_1 import Error1
from fdxapi.models.hateoas_link import HateoasLink
from fdxapi.models.tax_form_attribute import TaxFormAttribute
from fdxapi.models.tax_party_1 import TaxParty1
from fdxapi.models.tax_party_8 import TaxParty8


class Form1065K1(object):

    """Implementation of the 'Form 1065 K-1' model.

    Partner's Share of Income, Deductions, Credits, etc., from Partnership
    (boxes A, D as issuer) to Partner (boxes E-F as recipient)

    Attributes:
        tax_year (int): Year for which taxes are being paid
        corrected (bool): True to indicate this is a corrected tax form
        account_id (str): Long-term persistent identity of the source account.
            Not the account number
        tax_form_id (str): Long-term persistent id for this tax form.
            Depending upon the data provider, this may be the same id as the
            enclosing tax statement id, or this may be a different id, or this
            id may be omitted.
        tax_form_date (date): Date of production or delivery of the tax form
        additional_information (str): Additional explanation text or content
            about this tax form
        tax_form_type (TypeFormType1): Enumerated name of the tax form entity
            e.g. "TaxW2"
        issuer (TaxParty8): Issuer's name, address, phone, and TIN. Issuer
            data need only be transmitted on enclosing TaxStatement, if it is
            the same on all its included tax forms.
        recipient (TaxParty1): Recipient's name, address, phone, and TIN.
            Recipient data need only be transmitted on enclosing TaxStatement,
            if it is the same on all its included tax forms.
        attributes (List[TaxFormAttribute]): Additional attributes for this
            tax form when defined fields are not available. Some specific
            additional attributes already defined by providers: Fields
            required by [IRS
            FIRE](https://www.irs.gov/e-file-providers/filing-information-retur
            ns-electronically-fire): Name Control, Type of Identification
            Number (EIN, SSN, ITIN, ATIN). (ATIN is tax ID number for pending
            adoptions.) Tax form provider field for taxpayer notification:
            Recipient Email Address.
        error (Error1): Present if an error was encountered while retrieving
            this form
        links (List[HateoasLink]): Links to retrieve this form as data or
            image, or to invoke other APIs
        fiscal_year_begin (date): Fiscal year begin date
        fiscal_year_end (date): Fiscal year end data
        final_k_1 (bool): Final K-1
        amended_k_1 (bool): Amended K-1
        irs_center (str): Box C, IRS Center where partnership filed return
        publicly_traded (bool): Box D, Check if this is a publicly traded
            partnership (PTP)
        general_partner (bool): Box G, General partner or LLC member-manager
        limited_partner (bool): Box G, Limited partner or other LLC member
        domestic (bool): Box H1, Domestic partner
        foreign (bool): Box H1, Foreign partner
        disregarded_entity (bool): Box H2, Check if the partner is a
            disregarded entity (DE), and enter the partner's TIN and Name
        disregarded_entity_tin (str): Box H2, Disregarded entity partner's TIN
        disregarded_entity_name (str): Box H2, Disregarded entity partner's
            Name
        entity_type (str): Box I1, What type of entity is this partner?
        retirement_plan (bool): Box I2, If this partner is a retirement plan
            (IRA/SEP/Keogh/etc.), check here
        profit_share_begin (float): Box J, Partner's share of profit -
            beginning
        profit_share_end (float): Box J, Partner's share of profit - ending
        loss_share_begin (float): Box J, Partner's share of loss - beginning
        loss_share_end (float): Box J, Partner's share of loss - ending
        capital_share_begin (float): Box J, Partner's share of capital -
            beginning
        capital_share_end (float): Box J, Partner's share of capital - ending
        decrease_due_to_sale_or_exchange (bool): Box J, Check if decrease is
            due to sale or exchange of partnership interest. Deprecated and no
            longer used beginning tax year 2023. Use `decreaseDueToSale` and
            `decreaseDueToExchange` instead
        decrease_due_to_sale (bool): Box J, Check if decrease is due to sale
            of partnership interest
        decrease_due_to_exchange (bool): Box J, Check if decrease is due to
            exchange of partnership interest
        nonrecourse_liability_share_begin (float): Box K1, Partner's share of
            liabilities - beginning - nonrecourse
        nonrecourse_liability_share_end (float): Box K1, Partner's share of
            liabilities - ending - nonrecourse
        qualified_liability_share_begin (float): Box K1, Partner's share of
            liabilities - beginning - qualified nonrecourse financing
        qualified_liability_share_end (float): Box K1, Partner's share of
            liabilities - ending - qualified nonrecourse financing
        recourse_liability_share_begin (float): Box K1, Partner's share of
            liabilities - beginning - recourse
        recourse_liability_share_end (float): Box K1, Partner's share of
            liabilities - ending - recourse
        includes_lower_tier_liability (bool): Box K2, Check this box if item
            K1 includes liability amounts from lower tier partnerships
        liability_subject_to_guarantees (bool): Box K3, Check if any of the
            above liability is subject to guarantees or other payment
            obligations by the partner
        capital_account_begin (float): Box L, Partner's capital account
            analysis - Beginning capital account
        capital_account_contributions (float): Box L, Partner's capital
            account analysis - Capital contributed during the year
        capital_account_increase (float): Box L, Partner's capital account
            analysis - Current year net income (loss)
        capital_account_other (float): Box L, Partner's capital account
            analysis - Other increase (decrease)
        capital_account_withdrawals (float): Box L, Partner's capital account
            analysis - Withdrawals & distributions
        capital_account_end (float): Box L, Partner's capital account analysis
            - Ending capital account
        built_in_gain (bool): Box M, Did the partner contribute property with
            a built-in gain or loss? - Yes
        unrecognized_section_704_begin (float): Box N, Partner's Share of Net
            Unrecognized Section 704(c) Gain or (Loss) - beginning
        unrecognized_section_704_end (float): Box N, Partner's Share of Net
            Unrecognized Section 704(c) Gain or (Loss) - ending
        ordinary_income (float): Box 1, Ordinary business income (loss)
        net_rental_real_estate_income (float): Box 2, Net rental real estate
            income (loss)
        other_rental_income (float): Box 3, Other net rental income (loss)
        guaranteed_payment_services (float): Box 4a, Guaranteed payments for
            services
        guaranteed_payment_capital (float): Box 4b, Guaranteed payments for
            capital
        guaranteed_payment (float): Box 4c, Total guaranteed payments
        interest_income (float): Box 5, Interest income
        ordinary_dividends (float): Box 6a, Ordinary dividends
        qualified_dividends (float): Box 6b, Qualified dividends
        dividend_equivalents (float): Box 6c, Dividend equivalents
        royalties (float): Box 7, Royalties
        net_short_term_gain (float): Box 8, Net short-term capital gain (loss)
        net_long_term_gain (float): Box 9a, Net long-term capital gain (loss)
        collectibles_gain (float): Box 9b, Collectibles (28%) gain (loss)
        unrecaptured_1250_gain (float): Box 9c, Unrecaptured section 1250 gain
        net_1231_gain (float): Box 10, Net section 1231 gain (loss)
        other_income (List[CodeAndAmount]): Box 11, Other income
        section_179_deduction (float): Box 12, Section 179 deduction
        other_deductions (List[CodeAndAmount]): Box 13, Other deductions
        self_employment (List[CodeAndAmount]): Box 14, Self-employment
            earnings (loss)
        credits (List[CodeAndAmount]): Box 15, Credits
        schedule_k_3 (bool): Box 16, Schedule K-3 is attached
        amt_items (List[CodeAndAmount]): Box 17, Alternative minimum tax (AMT)
            items
        tax_exempt_income (List[CodeAndAmount]): Box 18, Tax-exempt income and
            nondeductible expenses
        distributions (List[CodeAndAmount]): Box 19, Distributions
        other_info (List[CodeAndAmount]): Box 20, Other information
        foreign_tax_paid (float): Box 21, Foreign taxes paid or accrued
        multiple_at_risk_activities (bool): Box 22, More than one activity for
            at-risk purposes
        multiple_passive_activities (bool): Box 23, More than one activity for
            passive activity purposes
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "tax_year": 'taxYear',
        "corrected": 'corrected',
        "account_id": 'accountId',
        "tax_form_id": 'taxFormId',
        "tax_form_date": 'taxFormDate',
        "additional_information": 'additionalInformation',
        "tax_form_type": 'taxFormType',
        "issuer": 'issuer',
        "recipient": 'recipient',
        "attributes": 'attributes',
        "error": 'error',
        "links": 'links',
        "fiscal_year_begin": 'fiscalYearBegin',
        "fiscal_year_end": 'fiscalYearEnd',
        "final_k_1": 'finalK1',
        "amended_k_1": 'amendedK1',
        "irs_center": 'irsCenter',
        "publicly_traded": 'publiclyTraded',
        "general_partner": 'generalPartner',
        "limited_partner": 'limitedPartner',
        "domestic": 'domestic',
        "foreign": 'foreign',
        "disregarded_entity": 'disregardedEntity',
        "disregarded_entity_tin": 'disregardedEntityTin',
        "disregarded_entity_name": 'disregardedEntityName',
        "entity_type": 'entityType',
        "retirement_plan": 'retirementPlan',
        "profit_share_begin": 'profitShareBegin',
        "profit_share_end": 'profitShareEnd',
        "loss_share_begin": 'lossShareBegin',
        "loss_share_end": 'lossShareEnd',
        "capital_share_begin": 'capitalShareBegin',
        "capital_share_end": 'capitalShareEnd',
        "decrease_due_to_sale_or_exchange": 'decreaseDueToSaleOrExchange',
        "decrease_due_to_sale": 'decreaseDueToSale',
        "decrease_due_to_exchange": 'decreaseDueToExchange',
        "nonrecourse_liability_share_begin": 'nonrecourseLiabilityShareBegin',
        "nonrecourse_liability_share_end": 'nonrecourseLiabilityShareEnd',
        "qualified_liability_share_begin": 'qualifiedLiabilityShareBegin',
        "qualified_liability_share_end": 'qualifiedLiabilityShareEnd',
        "recourse_liability_share_begin": 'recourseLiabilityShareBegin',
        "recourse_liability_share_end": 'recourseLiabilityShareEnd',
        "includes_lower_tier_liability": 'includesLowerTierLiability',
        "liability_subject_to_guarantees": 'liabilitySubjectToGuarantees',
        "capital_account_begin": 'capitalAccountBegin',
        "capital_account_contributions": 'capitalAccountContributions',
        "capital_account_increase": 'capitalAccountIncrease',
        "capital_account_other": 'capitalAccountOther',
        "capital_account_withdrawals": 'capitalAccountWithdrawals',
        "capital_account_end": 'capitalAccountEnd',
        "built_in_gain": 'builtInGain',
        "unrecognized_section_704_begin": 'unrecognizedSection704Begin',
        "unrecognized_section_704_end": 'unrecognizedSection704End',
        "ordinary_income": 'ordinaryIncome',
        "net_rental_real_estate_income": 'netRentalRealEstateIncome',
        "other_rental_income": 'otherRentalIncome',
        "guaranteed_payment_services": 'guaranteedPaymentServices',
        "guaranteed_payment_capital": 'guaranteedPaymentCapital',
        "guaranteed_payment": 'guaranteedPayment',
        "interest_income": 'interestIncome',
        "ordinary_dividends": 'ordinaryDividends',
        "qualified_dividends": 'qualifiedDividends',
        "dividend_equivalents": 'dividendEquivalents',
        "royalties": 'royalties',
        "net_short_term_gain": 'netShortTermGain',
        "net_long_term_gain": 'netLongTermGain',
        "collectibles_gain": 'collectiblesGain',
        "unrecaptured_1250_gain": 'unrecaptured1250Gain',
        "net_1231_gain": 'net1231Gain',
        "other_income": 'otherIncome',
        "section_179_deduction": 'section179Deduction',
        "other_deductions": 'otherDeductions',
        "self_employment": 'selfEmployment',
        "credits": 'credits',
        "schedule_k_3": 'scheduleK3',
        "amt_items": 'amtItems',
        "tax_exempt_income": 'taxExemptIncome',
        "distributions": 'distributions',
        "other_info": 'otherInfo',
        "foreign_tax_paid": 'foreignTaxPaid',
        "multiple_at_risk_activities": 'multipleAtRiskActivities',
        "multiple_passive_activities": 'multiplePassiveActivities'
    }

    _optionals = [
        'tax_year',
        'corrected',
        'account_id',
        'tax_form_id',
        'tax_form_date',
        'additional_information',
        'tax_form_type',
        'issuer',
        'recipient',
        'attributes',
        'error',
        'links',
        'fiscal_year_begin',
        'fiscal_year_end',
        'final_k_1',
        'amended_k_1',
        'irs_center',
        'publicly_traded',
        'general_partner',
        'limited_partner',
        'domestic',
        'foreign',
        'disregarded_entity',
        'disregarded_entity_tin',
        'disregarded_entity_name',
        'entity_type',
        'retirement_plan',
        'profit_share_begin',
        'profit_share_end',
        'loss_share_begin',
        'loss_share_end',
        'capital_share_begin',
        'capital_share_end',
        'decrease_due_to_sale_or_exchange',
        'decrease_due_to_sale',
        'decrease_due_to_exchange',
        'nonrecourse_liability_share_begin',
        'nonrecourse_liability_share_end',
        'qualified_liability_share_begin',
        'qualified_liability_share_end',
        'recourse_liability_share_begin',
        'recourse_liability_share_end',
        'includes_lower_tier_liability',
        'liability_subject_to_guarantees',
        'capital_account_begin',
        'capital_account_contributions',
        'capital_account_increase',
        'capital_account_other',
        'capital_account_withdrawals',
        'capital_account_end',
        'built_in_gain',
        'unrecognized_section_704_begin',
        'unrecognized_section_704_end',
        'ordinary_income',
        'net_rental_real_estate_income',
        'other_rental_income',
        'guaranteed_payment_services',
        'guaranteed_payment_capital',
        'guaranteed_payment',
        'interest_income',
        'ordinary_dividends',
        'qualified_dividends',
        'dividend_equivalents',
        'royalties',
        'net_short_term_gain',
        'net_long_term_gain',
        'collectibles_gain',
        'unrecaptured_1250_gain',
        'net_1231_gain',
        'other_income',
        'section_179_deduction',
        'other_deductions',
        'self_employment',
        'credits',
        'schedule_k_3',
        'amt_items',
        'tax_exempt_income',
        'distributions',
        'other_info',
        'foreign_tax_paid',
        'multiple_at_risk_activities',
        'multiple_passive_activities',
    ]

    def __init__(self,
                 tax_year=APIHelper.SKIP,
                 corrected=APIHelper.SKIP,
                 account_id=APIHelper.SKIP,
                 tax_form_id=APIHelper.SKIP,
                 tax_form_date=APIHelper.SKIP,
                 additional_information=APIHelper.SKIP,
                 tax_form_type=APIHelper.SKIP,
                 issuer=APIHelper.SKIP,
                 recipient=APIHelper.SKIP,
                 attributes=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 fiscal_year_begin=APIHelper.SKIP,
                 fiscal_year_end=APIHelper.SKIP,
                 final_k_1=APIHelper.SKIP,
                 amended_k_1=APIHelper.SKIP,
                 irs_center=APIHelper.SKIP,
                 publicly_traded=APIHelper.SKIP,
                 general_partner=APIHelper.SKIP,
                 limited_partner=APIHelper.SKIP,
                 domestic=APIHelper.SKIP,
                 foreign=APIHelper.SKIP,
                 disregarded_entity=APIHelper.SKIP,
                 disregarded_entity_tin=APIHelper.SKIP,
                 disregarded_entity_name=APIHelper.SKIP,
                 entity_type=APIHelper.SKIP,
                 retirement_plan=APIHelper.SKIP,
                 profit_share_begin=APIHelper.SKIP,
                 profit_share_end=APIHelper.SKIP,
                 loss_share_begin=APIHelper.SKIP,
                 loss_share_end=APIHelper.SKIP,
                 capital_share_begin=APIHelper.SKIP,
                 capital_share_end=APIHelper.SKIP,
                 decrease_due_to_sale_or_exchange=APIHelper.SKIP,
                 decrease_due_to_sale=APIHelper.SKIP,
                 decrease_due_to_exchange=APIHelper.SKIP,
                 nonrecourse_liability_share_begin=APIHelper.SKIP,
                 nonrecourse_liability_share_end=APIHelper.SKIP,
                 qualified_liability_share_begin=APIHelper.SKIP,
                 qualified_liability_share_end=APIHelper.SKIP,
                 recourse_liability_share_begin=APIHelper.SKIP,
                 recourse_liability_share_end=APIHelper.SKIP,
                 includes_lower_tier_liability=APIHelper.SKIP,
                 liability_subject_to_guarantees=APIHelper.SKIP,
                 capital_account_begin=APIHelper.SKIP,
                 capital_account_contributions=APIHelper.SKIP,
                 capital_account_increase=APIHelper.SKIP,
                 capital_account_other=APIHelper.SKIP,
                 capital_account_withdrawals=APIHelper.SKIP,
                 capital_account_end=APIHelper.SKIP,
                 built_in_gain=APIHelper.SKIP,
                 unrecognized_section_704_begin=APIHelper.SKIP,
                 unrecognized_section_704_end=APIHelper.SKIP,
                 ordinary_income=APIHelper.SKIP,
                 net_rental_real_estate_income=APIHelper.SKIP,
                 other_rental_income=APIHelper.SKIP,
                 guaranteed_payment_services=APIHelper.SKIP,
                 guaranteed_payment_capital=APIHelper.SKIP,
                 guaranteed_payment=APIHelper.SKIP,
                 interest_income=APIHelper.SKIP,
                 ordinary_dividends=APIHelper.SKIP,
                 qualified_dividends=APIHelper.SKIP,
                 dividend_equivalents=APIHelper.SKIP,
                 royalties=APIHelper.SKIP,
                 net_short_term_gain=APIHelper.SKIP,
                 net_long_term_gain=APIHelper.SKIP,
                 collectibles_gain=APIHelper.SKIP,
                 unrecaptured_1250_gain=APIHelper.SKIP,
                 net_1231_gain=APIHelper.SKIP,
                 other_income=APIHelper.SKIP,
                 section_179_deduction=APIHelper.SKIP,
                 other_deductions=APIHelper.SKIP,
                 self_employment=APIHelper.SKIP,
                 credits=APIHelper.SKIP,
                 schedule_k_3=APIHelper.SKIP,
                 amt_items=APIHelper.SKIP,
                 tax_exempt_income=APIHelper.SKIP,
                 distributions=APIHelper.SKIP,
                 other_info=APIHelper.SKIP,
                 foreign_tax_paid=APIHelper.SKIP,
                 multiple_at_risk_activities=APIHelper.SKIP,
                 multiple_passive_activities=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the Form1065K1 class"""

        # Initialize members of the class
        if tax_year is not APIHelper.SKIP:
            self.tax_year = tax_year 
        if corrected is not APIHelper.SKIP:
            self.corrected = corrected 
        if account_id is not APIHelper.SKIP:
            self.account_id = account_id 
        if tax_form_id is not APIHelper.SKIP:
            self.tax_form_id = tax_form_id 
        if tax_form_date is not APIHelper.SKIP:
            self.tax_form_date = tax_form_date 
        if additional_information is not APIHelper.SKIP:
            self.additional_information = additional_information 
        if tax_form_type is not APIHelper.SKIP:
            self.tax_form_type = tax_form_type 
        if issuer is not APIHelper.SKIP:
            self.issuer = issuer 
        if recipient is not APIHelper.SKIP:
            self.recipient = recipient 
        if attributes is not APIHelper.SKIP:
            self.attributes = attributes 
        if error is not APIHelper.SKIP:
            self.error = error 
        if links is not APIHelper.SKIP:
            self.links = links 
        if fiscal_year_begin is not APIHelper.SKIP:
            self.fiscal_year_begin = fiscal_year_begin 
        if fiscal_year_end is not APIHelper.SKIP:
            self.fiscal_year_end = fiscal_year_end 
        if final_k_1 is not APIHelper.SKIP:
            self.final_k_1 = final_k_1 
        if amended_k_1 is not APIHelper.SKIP:
            self.amended_k_1 = amended_k_1 
        if irs_center is not APIHelper.SKIP:
            self.irs_center = irs_center 
        if publicly_traded is not APIHelper.SKIP:
            self.publicly_traded = publicly_traded 
        if general_partner is not APIHelper.SKIP:
            self.general_partner = general_partner 
        if limited_partner is not APIHelper.SKIP:
            self.limited_partner = limited_partner 
        if domestic is not APIHelper.SKIP:
            self.domestic = domestic 
        if foreign is not APIHelper.SKIP:
            self.foreign = foreign 
        if disregarded_entity is not APIHelper.SKIP:
            self.disregarded_entity = disregarded_entity 
        if disregarded_entity_tin is not APIHelper.SKIP:
            self.disregarded_entity_tin = disregarded_entity_tin 
        if disregarded_entity_name is not APIHelper.SKIP:
            self.disregarded_entity_name = disregarded_entity_name 
        if entity_type is not APIHelper.SKIP:
            self.entity_type = entity_type 
        if retirement_plan is not APIHelper.SKIP:
            self.retirement_plan = retirement_plan 
        if profit_share_begin is not APIHelper.SKIP:
            self.profit_share_begin = profit_share_begin 
        if profit_share_end is not APIHelper.SKIP:
            self.profit_share_end = profit_share_end 
        if loss_share_begin is not APIHelper.SKIP:
            self.loss_share_begin = loss_share_begin 
        if loss_share_end is not APIHelper.SKIP:
            self.loss_share_end = loss_share_end 
        if capital_share_begin is not APIHelper.SKIP:
            self.capital_share_begin = capital_share_begin 
        if capital_share_end is not APIHelper.SKIP:
            self.capital_share_end = capital_share_end 
        if decrease_due_to_sale_or_exchange is not APIHelper.SKIP:
            self.decrease_due_to_sale_or_exchange = decrease_due_to_sale_or_exchange 
        if decrease_due_to_sale is not APIHelper.SKIP:
            self.decrease_due_to_sale = decrease_due_to_sale 
        if decrease_due_to_exchange is not APIHelper.SKIP:
            self.decrease_due_to_exchange = decrease_due_to_exchange 
        if nonrecourse_liability_share_begin is not APIHelper.SKIP:
            self.nonrecourse_liability_share_begin = nonrecourse_liability_share_begin 
        if nonrecourse_liability_share_end is not APIHelper.SKIP:
            self.nonrecourse_liability_share_end = nonrecourse_liability_share_end 
        if qualified_liability_share_begin is not APIHelper.SKIP:
            self.qualified_liability_share_begin = qualified_liability_share_begin 
        if qualified_liability_share_end is not APIHelper.SKIP:
            self.qualified_liability_share_end = qualified_liability_share_end 
        if recourse_liability_share_begin is not APIHelper.SKIP:
            self.recourse_liability_share_begin = recourse_liability_share_begin 
        if recourse_liability_share_end is not APIHelper.SKIP:
            self.recourse_liability_share_end = recourse_liability_share_end 
        if includes_lower_tier_liability is not APIHelper.SKIP:
            self.includes_lower_tier_liability = includes_lower_tier_liability 
        if liability_subject_to_guarantees is not APIHelper.SKIP:
            self.liability_subject_to_guarantees = liability_subject_to_guarantees 
        if capital_account_begin is not APIHelper.SKIP:
            self.capital_account_begin = capital_account_begin 
        if capital_account_contributions is not APIHelper.SKIP:
            self.capital_account_contributions = capital_account_contributions 
        if capital_account_increase is not APIHelper.SKIP:
            self.capital_account_increase = capital_account_increase 
        if capital_account_other is not APIHelper.SKIP:
            self.capital_account_other = capital_account_other 
        if capital_account_withdrawals is not APIHelper.SKIP:
            self.capital_account_withdrawals = capital_account_withdrawals 
        if capital_account_end is not APIHelper.SKIP:
            self.capital_account_end = capital_account_end 
        if built_in_gain is not APIHelper.SKIP:
            self.built_in_gain = built_in_gain 
        if unrecognized_section_704_begin is not APIHelper.SKIP:
            self.unrecognized_section_704_begin = unrecognized_section_704_begin 
        if unrecognized_section_704_end is not APIHelper.SKIP:
            self.unrecognized_section_704_end = unrecognized_section_704_end 
        if ordinary_income is not APIHelper.SKIP:
            self.ordinary_income = ordinary_income 
        if net_rental_real_estate_income is not APIHelper.SKIP:
            self.net_rental_real_estate_income = net_rental_real_estate_income 
        if other_rental_income is not APIHelper.SKIP:
            self.other_rental_income = other_rental_income 
        if guaranteed_payment_services is not APIHelper.SKIP:
            self.guaranteed_payment_services = guaranteed_payment_services 
        if guaranteed_payment_capital is not APIHelper.SKIP:
            self.guaranteed_payment_capital = guaranteed_payment_capital 
        if guaranteed_payment is not APIHelper.SKIP:
            self.guaranteed_payment = guaranteed_payment 
        if interest_income is not APIHelper.SKIP:
            self.interest_income = interest_income 
        if ordinary_dividends is not APIHelper.SKIP:
            self.ordinary_dividends = ordinary_dividends 
        if qualified_dividends is not APIHelper.SKIP:
            self.qualified_dividends = qualified_dividends 
        if dividend_equivalents is not APIHelper.SKIP:
            self.dividend_equivalents = dividend_equivalents 
        if royalties is not APIHelper.SKIP:
            self.royalties = royalties 
        if net_short_term_gain is not APIHelper.SKIP:
            self.net_short_term_gain = net_short_term_gain 
        if net_long_term_gain is not APIHelper.SKIP:
            self.net_long_term_gain = net_long_term_gain 
        if collectibles_gain is not APIHelper.SKIP:
            self.collectibles_gain = collectibles_gain 
        if unrecaptured_1250_gain is not APIHelper.SKIP:
            self.unrecaptured_1250_gain = unrecaptured_1250_gain 
        if net_1231_gain is not APIHelper.SKIP:
            self.net_1231_gain = net_1231_gain 
        if other_income is not APIHelper.SKIP:
            self.other_income = other_income 
        if section_179_deduction is not APIHelper.SKIP:
            self.section_179_deduction = section_179_deduction 
        if other_deductions is not APIHelper.SKIP:
            self.other_deductions = other_deductions 
        if self_employment is not APIHelper.SKIP:
            self.self_employment = self_employment 
        if credits is not APIHelper.SKIP:
            self.credits = credits 
        if schedule_k_3 is not APIHelper.SKIP:
            self.schedule_k_3 = schedule_k_3 
        if amt_items is not APIHelper.SKIP:
            self.amt_items = amt_items 
        if tax_exempt_income is not APIHelper.SKIP:
            self.tax_exempt_income = tax_exempt_income 
        if distributions is not APIHelper.SKIP:
            self.distributions = distributions 
        if other_info is not APIHelper.SKIP:
            self.other_info = other_info 
        if foreign_tax_paid is not APIHelper.SKIP:
            self.foreign_tax_paid = foreign_tax_paid 
        if multiple_at_risk_activities is not APIHelper.SKIP:
            self.multiple_at_risk_activities = multiple_at_risk_activities 
        if multiple_passive_activities is not APIHelper.SKIP:
            self.multiple_passive_activities = multiple_passive_activities 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        tax_year = dictionary.get("taxYear") if dictionary.get("taxYear") else APIHelper.SKIP
        corrected = dictionary.get("corrected") if "corrected" in dictionary.keys() else APIHelper.SKIP
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        tax_form_id = dictionary.get("taxFormId") if dictionary.get("taxFormId") else APIHelper.SKIP
        tax_form_date = dateutil.parser.parse(dictionary.get('taxFormDate')).date() if dictionary.get('taxFormDate') else APIHelper.SKIP
        additional_information = dictionary.get("additionalInformation") if dictionary.get("additionalInformation") else APIHelper.SKIP
        tax_form_type = dictionary.get("taxFormType") if dictionary.get("taxFormType") else APIHelper.SKIP
        issuer = TaxParty8.from_dictionary(dictionary.get('issuer')) if 'issuer' in dictionary.keys() else APIHelper.SKIP
        recipient = TaxParty1.from_dictionary(dictionary.get('recipient')) if 'recipient' in dictionary.keys() else APIHelper.SKIP
        attributes = None
        if dictionary.get('attributes') is not None:
            attributes = [TaxFormAttribute.from_dictionary(x) for x in dictionary.get('attributes')]
        else:
            attributes = APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        fiscal_year_begin = dateutil.parser.parse(dictionary.get('fiscalYearBegin')).date() if dictionary.get('fiscalYearBegin') else APIHelper.SKIP
        fiscal_year_end = dateutil.parser.parse(dictionary.get('fiscalYearEnd')).date() if dictionary.get('fiscalYearEnd') else APIHelper.SKIP
        final_k_1 = dictionary.get("finalK1") if "finalK1" in dictionary.keys() else APIHelper.SKIP
        amended_k_1 = dictionary.get("amendedK1") if "amendedK1" in dictionary.keys() else APIHelper.SKIP
        irs_center = dictionary.get("irsCenter") if dictionary.get("irsCenter") else APIHelper.SKIP
        publicly_traded = dictionary.get("publiclyTraded") if "publiclyTraded" in dictionary.keys() else APIHelper.SKIP
        general_partner = dictionary.get("generalPartner") if "generalPartner" in dictionary.keys() else APIHelper.SKIP
        limited_partner = dictionary.get("limitedPartner") if "limitedPartner" in dictionary.keys() else APIHelper.SKIP
        domestic = dictionary.get("domestic") if "domestic" in dictionary.keys() else APIHelper.SKIP
        foreign = dictionary.get("foreign") if "foreign" in dictionary.keys() else APIHelper.SKIP
        disregarded_entity = dictionary.get("disregardedEntity") if "disregardedEntity" in dictionary.keys() else APIHelper.SKIP
        disregarded_entity_tin = dictionary.get("disregardedEntityTin") if dictionary.get("disregardedEntityTin") else APIHelper.SKIP
        disregarded_entity_name = dictionary.get("disregardedEntityName") if dictionary.get("disregardedEntityName") else APIHelper.SKIP
        entity_type = dictionary.get("entityType") if dictionary.get("entityType") else APIHelper.SKIP
        retirement_plan = dictionary.get("retirementPlan") if "retirementPlan" in dictionary.keys() else APIHelper.SKIP
        profit_share_begin = dictionary.get("profitShareBegin") if dictionary.get("profitShareBegin") else APIHelper.SKIP
        profit_share_end = dictionary.get("profitShareEnd") if dictionary.get("profitShareEnd") else APIHelper.SKIP
        loss_share_begin = dictionary.get("lossShareBegin") if dictionary.get("lossShareBegin") else APIHelper.SKIP
        loss_share_end = dictionary.get("lossShareEnd") if dictionary.get("lossShareEnd") else APIHelper.SKIP
        capital_share_begin = dictionary.get("capitalShareBegin") if dictionary.get("capitalShareBegin") else APIHelper.SKIP
        capital_share_end = dictionary.get("capitalShareEnd") if dictionary.get("capitalShareEnd") else APIHelper.SKIP
        decrease_due_to_sale_or_exchange = dictionary.get("decreaseDueToSaleOrExchange") if "decreaseDueToSaleOrExchange" in dictionary.keys() else APIHelper.SKIP
        decrease_due_to_sale = dictionary.get("decreaseDueToSale") if "decreaseDueToSale" in dictionary.keys() else APIHelper.SKIP
        decrease_due_to_exchange = dictionary.get("decreaseDueToExchange") if "decreaseDueToExchange" in dictionary.keys() else APIHelper.SKIP
        nonrecourse_liability_share_begin = dictionary.get("nonrecourseLiabilityShareBegin") if dictionary.get("nonrecourseLiabilityShareBegin") else APIHelper.SKIP
        nonrecourse_liability_share_end = dictionary.get("nonrecourseLiabilityShareEnd") if dictionary.get("nonrecourseLiabilityShareEnd") else APIHelper.SKIP
        qualified_liability_share_begin = dictionary.get("qualifiedLiabilityShareBegin") if dictionary.get("qualifiedLiabilityShareBegin") else APIHelper.SKIP
        qualified_liability_share_end = dictionary.get("qualifiedLiabilityShareEnd") if dictionary.get("qualifiedLiabilityShareEnd") else APIHelper.SKIP
        recourse_liability_share_begin = dictionary.get("recourseLiabilityShareBegin") if dictionary.get("recourseLiabilityShareBegin") else APIHelper.SKIP
        recourse_liability_share_end = dictionary.get("recourseLiabilityShareEnd") if dictionary.get("recourseLiabilityShareEnd") else APIHelper.SKIP
        includes_lower_tier_liability = dictionary.get("includesLowerTierLiability") if "includesLowerTierLiability" in dictionary.keys() else APIHelper.SKIP
        liability_subject_to_guarantees = dictionary.get("liabilitySubjectToGuarantees") if "liabilitySubjectToGuarantees" in dictionary.keys() else APIHelper.SKIP
        capital_account_begin = dictionary.get("capitalAccountBegin") if dictionary.get("capitalAccountBegin") else APIHelper.SKIP
        capital_account_contributions = dictionary.get("capitalAccountContributions") if dictionary.get("capitalAccountContributions") else APIHelper.SKIP
        capital_account_increase = dictionary.get("capitalAccountIncrease") if dictionary.get("capitalAccountIncrease") else APIHelper.SKIP
        capital_account_other = dictionary.get("capitalAccountOther") if dictionary.get("capitalAccountOther") else APIHelper.SKIP
        capital_account_withdrawals = dictionary.get("capitalAccountWithdrawals") if dictionary.get("capitalAccountWithdrawals") else APIHelper.SKIP
        capital_account_end = dictionary.get("capitalAccountEnd") if dictionary.get("capitalAccountEnd") else APIHelper.SKIP
        built_in_gain = dictionary.get("builtInGain") if "builtInGain" in dictionary.keys() else APIHelper.SKIP
        unrecognized_section_704_begin = dictionary.get("unrecognizedSection704Begin") if dictionary.get("unrecognizedSection704Begin") else APIHelper.SKIP
        unrecognized_section_704_end = dictionary.get("unrecognizedSection704End") if dictionary.get("unrecognizedSection704End") else APIHelper.SKIP
        ordinary_income = dictionary.get("ordinaryIncome") if dictionary.get("ordinaryIncome") else APIHelper.SKIP
        net_rental_real_estate_income = dictionary.get("netRentalRealEstateIncome") if dictionary.get("netRentalRealEstateIncome") else APIHelper.SKIP
        other_rental_income = dictionary.get("otherRentalIncome") if dictionary.get("otherRentalIncome") else APIHelper.SKIP
        guaranteed_payment_services = dictionary.get("guaranteedPaymentServices") if dictionary.get("guaranteedPaymentServices") else APIHelper.SKIP
        guaranteed_payment_capital = dictionary.get("guaranteedPaymentCapital") if dictionary.get("guaranteedPaymentCapital") else APIHelper.SKIP
        guaranteed_payment = dictionary.get("guaranteedPayment") if dictionary.get("guaranteedPayment") else APIHelper.SKIP
        interest_income = dictionary.get("interestIncome") if dictionary.get("interestIncome") else APIHelper.SKIP
        ordinary_dividends = dictionary.get("ordinaryDividends") if dictionary.get("ordinaryDividends") else APIHelper.SKIP
        qualified_dividends = dictionary.get("qualifiedDividends") if dictionary.get("qualifiedDividends") else APIHelper.SKIP
        dividend_equivalents = dictionary.get("dividendEquivalents") if dictionary.get("dividendEquivalents") else APIHelper.SKIP
        royalties = dictionary.get("royalties") if dictionary.get("royalties") else APIHelper.SKIP
        net_short_term_gain = dictionary.get("netShortTermGain") if dictionary.get("netShortTermGain") else APIHelper.SKIP
        net_long_term_gain = dictionary.get("netLongTermGain") if dictionary.get("netLongTermGain") else APIHelper.SKIP
        collectibles_gain = dictionary.get("collectiblesGain") if dictionary.get("collectiblesGain") else APIHelper.SKIP
        unrecaptured_1250_gain = dictionary.get("unrecaptured1250Gain") if dictionary.get("unrecaptured1250Gain") else APIHelper.SKIP
        net_1231_gain = dictionary.get("net1231Gain") if dictionary.get("net1231Gain") else APIHelper.SKIP
        other_income = None
        if dictionary.get('otherIncome') is not None:
            other_income = [CodeAndAmount.from_dictionary(x) for x in dictionary.get('otherIncome')]
        else:
            other_income = APIHelper.SKIP
        section_179_deduction = dictionary.get("section179Deduction") if dictionary.get("section179Deduction") else APIHelper.SKIP
        other_deductions = None
        if dictionary.get('otherDeductions') is not None:
            other_deductions = [CodeAndAmount.from_dictionary(x) for x in dictionary.get('otherDeductions')]
        else:
            other_deductions = APIHelper.SKIP
        self_employment = None
        if dictionary.get('selfEmployment') is not None:
            self_employment = [CodeAndAmount.from_dictionary(x) for x in dictionary.get('selfEmployment')]
        else:
            self_employment = APIHelper.SKIP
        credits = None
        if dictionary.get('credits') is not None:
            credits = [CodeAndAmount.from_dictionary(x) for x in dictionary.get('credits')]
        else:
            credits = APIHelper.SKIP
        schedule_k_3 = dictionary.get("scheduleK3") if "scheduleK3" in dictionary.keys() else APIHelper.SKIP
        amt_items = None
        if dictionary.get('amtItems') is not None:
            amt_items = [CodeAndAmount.from_dictionary(x) for x in dictionary.get('amtItems')]
        else:
            amt_items = APIHelper.SKIP
        tax_exempt_income = None
        if dictionary.get('taxExemptIncome') is not None:
            tax_exempt_income = [CodeAndAmount.from_dictionary(x) for x in dictionary.get('taxExemptIncome')]
        else:
            tax_exempt_income = APIHelper.SKIP
        distributions = None
        if dictionary.get('distributions') is not None:
            distributions = [CodeAndAmount.from_dictionary(x) for x in dictionary.get('distributions')]
        else:
            distributions = APIHelper.SKIP
        other_info = None
        if dictionary.get('otherInfo') is not None:
            other_info = [CodeAndAmount.from_dictionary(x) for x in dictionary.get('otherInfo')]
        else:
            other_info = APIHelper.SKIP
        foreign_tax_paid = dictionary.get("foreignTaxPaid") if dictionary.get("foreignTaxPaid") else APIHelper.SKIP
        multiple_at_risk_activities = dictionary.get("multipleAtRiskActivities") if "multipleAtRiskActivities" in dictionary.keys() else APIHelper.SKIP
        multiple_passive_activities = dictionary.get("multiplePassiveActivities") if "multiplePassiveActivities" in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(tax_year,
                   corrected,
                   account_id,
                   tax_form_id,
                   tax_form_date,
                   additional_information,
                   tax_form_type,
                   issuer,
                   recipient,
                   attributes,
                   error,
                   links,
                   fiscal_year_begin,
                   fiscal_year_end,
                   final_k_1,
                   amended_k_1,
                   irs_center,
                   publicly_traded,
                   general_partner,
                   limited_partner,
                   domestic,
                   foreign,
                   disregarded_entity,
                   disregarded_entity_tin,
                   disregarded_entity_name,
                   entity_type,
                   retirement_plan,
                   profit_share_begin,
                   profit_share_end,
                   loss_share_begin,
                   loss_share_end,
                   capital_share_begin,
                   capital_share_end,
                   decrease_due_to_sale_or_exchange,
                   decrease_due_to_sale,
                   decrease_due_to_exchange,
                   nonrecourse_liability_share_begin,
                   nonrecourse_liability_share_end,
                   qualified_liability_share_begin,
                   qualified_liability_share_end,
                   recourse_liability_share_begin,
                   recourse_liability_share_end,
                   includes_lower_tier_liability,
                   liability_subject_to_guarantees,
                   capital_account_begin,
                   capital_account_contributions,
                   capital_account_increase,
                   capital_account_other,
                   capital_account_withdrawals,
                   capital_account_end,
                   built_in_gain,
                   unrecognized_section_704_begin,
                   unrecognized_section_704_end,
                   ordinary_income,
                   net_rental_real_estate_income,
                   other_rental_income,
                   guaranteed_payment_services,
                   guaranteed_payment_capital,
                   guaranteed_payment,
                   interest_income,
                   ordinary_dividends,
                   qualified_dividends,
                   dividend_equivalents,
                   royalties,
                   net_short_term_gain,
                   net_long_term_gain,
                   collectibles_gain,
                   unrecaptured_1250_gain,
                   net_1231_gain,
                   other_income,
                   section_179_deduction,
                   other_deductions,
                   self_employment,
                   credits,
                   schedule_k_3,
                   amt_items,
                   tax_exempt_income,
                   distributions,
                   other_info,
                   foreign_tax_paid,
                   multiple_at_risk_activities,
                   multiple_passive_activities,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!r}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!r}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!r}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!r}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!r}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!r}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!r}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!r}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!r}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!r}, '
                f'error={(self.error if hasattr(self, "error") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'fiscal_year_begin={(self.fiscal_year_begin if hasattr(self, "fiscal_year_begin") else None)!r}, '
                f'fiscal_year_end={(self.fiscal_year_end if hasattr(self, "fiscal_year_end") else None)!r}, '
                f'final_k_1={(self.final_k_1 if hasattr(self, "final_k_1") else None)!r}, '
                f'amended_k_1={(self.amended_k_1 if hasattr(self, "amended_k_1") else None)!r}, '
                f'irs_center={(self.irs_center if hasattr(self, "irs_center") else None)!r}, '
                f'publicly_traded={(self.publicly_traded if hasattr(self, "publicly_traded") else None)!r}, '
                f'general_partner={(self.general_partner if hasattr(self, "general_partner") else None)!r}, '
                f'limited_partner={(self.limited_partner if hasattr(self, "limited_partner") else None)!r}, '
                f'domestic={(self.domestic if hasattr(self, "domestic") else None)!r}, '
                f'foreign={(self.foreign if hasattr(self, "foreign") else None)!r}, '
                f'disregarded_entity={(self.disregarded_entity if hasattr(self, "disregarded_entity") else None)!r}, '
                f'disregarded_entity_tin={(self.disregarded_entity_tin if hasattr(self, "disregarded_entity_tin") else None)!r}, '
                f'disregarded_entity_name={(self.disregarded_entity_name if hasattr(self, "disregarded_entity_name") else None)!r}, '
                f'entity_type={(self.entity_type if hasattr(self, "entity_type") else None)!r}, '
                f'retirement_plan={(self.retirement_plan if hasattr(self, "retirement_plan") else None)!r}, '
                f'profit_share_begin={(self.profit_share_begin if hasattr(self, "profit_share_begin") else None)!r}, '
                f'profit_share_end={(self.profit_share_end if hasattr(self, "profit_share_end") else None)!r}, '
                f'loss_share_begin={(self.loss_share_begin if hasattr(self, "loss_share_begin") else None)!r}, '
                f'loss_share_end={(self.loss_share_end if hasattr(self, "loss_share_end") else None)!r}, '
                f'capital_share_begin={(self.capital_share_begin if hasattr(self, "capital_share_begin") else None)!r}, '
                f'capital_share_end={(self.capital_share_end if hasattr(self, "capital_share_end") else None)!r}, '
                f'decrease_due_to_sale_or_exchange={(self.decrease_due_to_sale_or_exchange if hasattr(self, "decrease_due_to_sale_or_exchange") else None)!r}, '
                f'decrease_due_to_sale={(self.decrease_due_to_sale if hasattr(self, "decrease_due_to_sale") else None)!r}, '
                f'decrease_due_to_exchange={(self.decrease_due_to_exchange if hasattr(self, "decrease_due_to_exchange") else None)!r}, '
                f'nonrecourse_liability_share_begin={(self.nonrecourse_liability_share_begin if hasattr(self, "nonrecourse_liability_share_begin") else None)!r}, '
                f'nonrecourse_liability_share_end={(self.nonrecourse_liability_share_end if hasattr(self, "nonrecourse_liability_share_end") else None)!r}, '
                f'qualified_liability_share_begin={(self.qualified_liability_share_begin if hasattr(self, "qualified_liability_share_begin") else None)!r}, '
                f'qualified_liability_share_end={(self.qualified_liability_share_end if hasattr(self, "qualified_liability_share_end") else None)!r}, '
                f'recourse_liability_share_begin={(self.recourse_liability_share_begin if hasattr(self, "recourse_liability_share_begin") else None)!r}, '
                f'recourse_liability_share_end={(self.recourse_liability_share_end if hasattr(self, "recourse_liability_share_end") else None)!r}, '
                f'includes_lower_tier_liability={(self.includes_lower_tier_liability if hasattr(self, "includes_lower_tier_liability") else None)!r}, '
                f'liability_subject_to_guarantees={(self.liability_subject_to_guarantees if hasattr(self, "liability_subject_to_guarantees") else None)!r}, '
                f'capital_account_begin={(self.capital_account_begin if hasattr(self, "capital_account_begin") else None)!r}, '
                f'capital_account_contributions={(self.capital_account_contributions if hasattr(self, "capital_account_contributions") else None)!r}, '
                f'capital_account_increase={(self.capital_account_increase if hasattr(self, "capital_account_increase") else None)!r}, '
                f'capital_account_other={(self.capital_account_other if hasattr(self, "capital_account_other") else None)!r}, '
                f'capital_account_withdrawals={(self.capital_account_withdrawals if hasattr(self, "capital_account_withdrawals") else None)!r}, '
                f'capital_account_end={(self.capital_account_end if hasattr(self, "capital_account_end") else None)!r}, '
                f'built_in_gain={(self.built_in_gain if hasattr(self, "built_in_gain") else None)!r}, '
                f'unrecognized_section_704_begin={(self.unrecognized_section_704_begin if hasattr(self, "unrecognized_section_704_begin") else None)!r}, '
                f'unrecognized_section_704_end={(self.unrecognized_section_704_end if hasattr(self, "unrecognized_section_704_end") else None)!r}, '
                f'ordinary_income={(self.ordinary_income if hasattr(self, "ordinary_income") else None)!r}, '
                f'net_rental_real_estate_income={(self.net_rental_real_estate_income if hasattr(self, "net_rental_real_estate_income") else None)!r}, '
                f'other_rental_income={(self.other_rental_income if hasattr(self, "other_rental_income") else None)!r}, '
                f'guaranteed_payment_services={(self.guaranteed_payment_services if hasattr(self, "guaranteed_payment_services") else None)!r}, '
                f'guaranteed_payment_capital={(self.guaranteed_payment_capital if hasattr(self, "guaranteed_payment_capital") else None)!r}, '
                f'guaranteed_payment={(self.guaranteed_payment if hasattr(self, "guaranteed_payment") else None)!r}, '
                f'interest_income={(self.interest_income if hasattr(self, "interest_income") else None)!r}, '
                f'ordinary_dividends={(self.ordinary_dividends if hasattr(self, "ordinary_dividends") else None)!r}, '
                f'qualified_dividends={(self.qualified_dividends if hasattr(self, "qualified_dividends") else None)!r}, '
                f'dividend_equivalents={(self.dividend_equivalents if hasattr(self, "dividend_equivalents") else None)!r}, '
                f'royalties={(self.royalties if hasattr(self, "royalties") else None)!r}, '
                f'net_short_term_gain={(self.net_short_term_gain if hasattr(self, "net_short_term_gain") else None)!r}, '
                f'net_long_term_gain={(self.net_long_term_gain if hasattr(self, "net_long_term_gain") else None)!r}, '
                f'collectibles_gain={(self.collectibles_gain if hasattr(self, "collectibles_gain") else None)!r}, '
                f'unrecaptured_1250_gain={(self.unrecaptured_1250_gain if hasattr(self, "unrecaptured_1250_gain") else None)!r}, '
                f'net_1231_gain={(self.net_1231_gain if hasattr(self, "net_1231_gain") else None)!r}, '
                f'other_income={(self.other_income if hasattr(self, "other_income") else None)!r}, '
                f'section_179_deduction={(self.section_179_deduction if hasattr(self, "section_179_deduction") else None)!r}, '
                f'other_deductions={(self.other_deductions if hasattr(self, "other_deductions") else None)!r}, '
                f'self_employment={(self.self_employment if hasattr(self, "self_employment") else None)!r}, '
                f'credits={(self.credits if hasattr(self, "credits") else None)!r}, '
                f'schedule_k_3={(self.schedule_k_3 if hasattr(self, "schedule_k_3") else None)!r}, '
                f'amt_items={(self.amt_items if hasattr(self, "amt_items") else None)!r}, '
                f'tax_exempt_income={(self.tax_exempt_income if hasattr(self, "tax_exempt_income") else None)!r}, '
                f'distributions={(self.distributions if hasattr(self, "distributions") else None)!r}, '
                f'other_info={(self.other_info if hasattr(self, "other_info") else None)!r}, '
                f'foreign_tax_paid={(self.foreign_tax_paid if hasattr(self, "foreign_tax_paid") else None)!r}, '
                f'multiple_at_risk_activities={(self.multiple_at_risk_activities if hasattr(self, "multiple_at_risk_activities") else None)!r}, '
                f'multiple_passive_activities={(self.multiple_passive_activities if hasattr(self, "multiple_passive_activities") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!s}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!s}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!s}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!s}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!s}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!s}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!s}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!s}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!s}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!s}, '
                f'error={(self.error if hasattr(self, "error") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'fiscal_year_begin={(self.fiscal_year_begin if hasattr(self, "fiscal_year_begin") else None)!s}, '
                f'fiscal_year_end={(self.fiscal_year_end if hasattr(self, "fiscal_year_end") else None)!s}, '
                f'final_k_1={(self.final_k_1 if hasattr(self, "final_k_1") else None)!s}, '
                f'amended_k_1={(self.amended_k_1 if hasattr(self, "amended_k_1") else None)!s}, '
                f'irs_center={(self.irs_center if hasattr(self, "irs_center") else None)!s}, '
                f'publicly_traded={(self.publicly_traded if hasattr(self, "publicly_traded") else None)!s}, '
                f'general_partner={(self.general_partner if hasattr(self, "general_partner") else None)!s}, '
                f'limited_partner={(self.limited_partner if hasattr(self, "limited_partner") else None)!s}, '
                f'domestic={(self.domestic if hasattr(self, "domestic") else None)!s}, '
                f'foreign={(self.foreign if hasattr(self, "foreign") else None)!s}, '
                f'disregarded_entity={(self.disregarded_entity if hasattr(self, "disregarded_entity") else None)!s}, '
                f'disregarded_entity_tin={(self.disregarded_entity_tin if hasattr(self, "disregarded_entity_tin") else None)!s}, '
                f'disregarded_entity_name={(self.disregarded_entity_name if hasattr(self, "disregarded_entity_name") else None)!s}, '
                f'entity_type={(self.entity_type if hasattr(self, "entity_type") else None)!s}, '
                f'retirement_plan={(self.retirement_plan if hasattr(self, "retirement_plan") else None)!s}, '
                f'profit_share_begin={(self.profit_share_begin if hasattr(self, "profit_share_begin") else None)!s}, '
                f'profit_share_end={(self.profit_share_end if hasattr(self, "profit_share_end") else None)!s}, '
                f'loss_share_begin={(self.loss_share_begin if hasattr(self, "loss_share_begin") else None)!s}, '
                f'loss_share_end={(self.loss_share_end if hasattr(self, "loss_share_end") else None)!s}, '
                f'capital_share_begin={(self.capital_share_begin if hasattr(self, "capital_share_begin") else None)!s}, '
                f'capital_share_end={(self.capital_share_end if hasattr(self, "capital_share_end") else None)!s}, '
                f'decrease_due_to_sale_or_exchange={(self.decrease_due_to_sale_or_exchange if hasattr(self, "decrease_due_to_sale_or_exchange") else None)!s}, '
                f'decrease_due_to_sale={(self.decrease_due_to_sale if hasattr(self, "decrease_due_to_sale") else None)!s}, '
                f'decrease_due_to_exchange={(self.decrease_due_to_exchange if hasattr(self, "decrease_due_to_exchange") else None)!s}, '
                f'nonrecourse_liability_share_begin={(self.nonrecourse_liability_share_begin if hasattr(self, "nonrecourse_liability_share_begin") else None)!s}, '
                f'nonrecourse_liability_share_end={(self.nonrecourse_liability_share_end if hasattr(self, "nonrecourse_liability_share_end") else None)!s}, '
                f'qualified_liability_share_begin={(self.qualified_liability_share_begin if hasattr(self, "qualified_liability_share_begin") else None)!s}, '
                f'qualified_liability_share_end={(self.qualified_liability_share_end if hasattr(self, "qualified_liability_share_end") else None)!s}, '
                f'recourse_liability_share_begin={(self.recourse_liability_share_begin if hasattr(self, "recourse_liability_share_begin") else None)!s}, '
                f'recourse_liability_share_end={(self.recourse_liability_share_end if hasattr(self, "recourse_liability_share_end") else None)!s}, '
                f'includes_lower_tier_liability={(self.includes_lower_tier_liability if hasattr(self, "includes_lower_tier_liability") else None)!s}, '
                f'liability_subject_to_guarantees={(self.liability_subject_to_guarantees if hasattr(self, "liability_subject_to_guarantees") else None)!s}, '
                f'capital_account_begin={(self.capital_account_begin if hasattr(self, "capital_account_begin") else None)!s}, '
                f'capital_account_contributions={(self.capital_account_contributions if hasattr(self, "capital_account_contributions") else None)!s}, '
                f'capital_account_increase={(self.capital_account_increase if hasattr(self, "capital_account_increase") else None)!s}, '
                f'capital_account_other={(self.capital_account_other if hasattr(self, "capital_account_other") else None)!s}, '
                f'capital_account_withdrawals={(self.capital_account_withdrawals if hasattr(self, "capital_account_withdrawals") else None)!s}, '
                f'capital_account_end={(self.capital_account_end if hasattr(self, "capital_account_end") else None)!s}, '
                f'built_in_gain={(self.built_in_gain if hasattr(self, "built_in_gain") else None)!s}, '
                f'unrecognized_section_704_begin={(self.unrecognized_section_704_begin if hasattr(self, "unrecognized_section_704_begin") else None)!s}, '
                f'unrecognized_section_704_end={(self.unrecognized_section_704_end if hasattr(self, "unrecognized_section_704_end") else None)!s}, '
                f'ordinary_income={(self.ordinary_income if hasattr(self, "ordinary_income") else None)!s}, '
                f'net_rental_real_estate_income={(self.net_rental_real_estate_income if hasattr(self, "net_rental_real_estate_income") else None)!s}, '
                f'other_rental_income={(self.other_rental_income if hasattr(self, "other_rental_income") else None)!s}, '
                f'guaranteed_payment_services={(self.guaranteed_payment_services if hasattr(self, "guaranteed_payment_services") else None)!s}, '
                f'guaranteed_payment_capital={(self.guaranteed_payment_capital if hasattr(self, "guaranteed_payment_capital") else None)!s}, '
                f'guaranteed_payment={(self.guaranteed_payment if hasattr(self, "guaranteed_payment") else None)!s}, '
                f'interest_income={(self.interest_income if hasattr(self, "interest_income") else None)!s}, '
                f'ordinary_dividends={(self.ordinary_dividends if hasattr(self, "ordinary_dividends") else None)!s}, '
                f'qualified_dividends={(self.qualified_dividends if hasattr(self, "qualified_dividends") else None)!s}, '
                f'dividend_equivalents={(self.dividend_equivalents if hasattr(self, "dividend_equivalents") else None)!s}, '
                f'royalties={(self.royalties if hasattr(self, "royalties") else None)!s}, '
                f'net_short_term_gain={(self.net_short_term_gain if hasattr(self, "net_short_term_gain") else None)!s}, '
                f'net_long_term_gain={(self.net_long_term_gain if hasattr(self, "net_long_term_gain") else None)!s}, '
                f'collectibles_gain={(self.collectibles_gain if hasattr(self, "collectibles_gain") else None)!s}, '
                f'unrecaptured_1250_gain={(self.unrecaptured_1250_gain if hasattr(self, "unrecaptured_1250_gain") else None)!s}, '
                f'net_1231_gain={(self.net_1231_gain if hasattr(self, "net_1231_gain") else None)!s}, '
                f'other_income={(self.other_income if hasattr(self, "other_income") else None)!s}, '
                f'section_179_deduction={(self.section_179_deduction if hasattr(self, "section_179_deduction") else None)!s}, '
                f'other_deductions={(self.other_deductions if hasattr(self, "other_deductions") else None)!s}, '
                f'self_employment={(self.self_employment if hasattr(self, "self_employment") else None)!s}, '
                f'credits={(self.credits if hasattr(self, "credits") else None)!s}, '
                f'schedule_k_3={(self.schedule_k_3 if hasattr(self, "schedule_k_3") else None)!s}, '
                f'amt_items={(self.amt_items if hasattr(self, "amt_items") else None)!s}, '
                f'tax_exempt_income={(self.tax_exempt_income if hasattr(self, "tax_exempt_income") else None)!s}, '
                f'distributions={(self.distributions if hasattr(self, "distributions") else None)!s}, '
                f'other_info={(self.other_info if hasattr(self, "other_info") else None)!s}, '
                f'foreign_tax_paid={(self.foreign_tax_paid if hasattr(self, "foreign_tax_paid") else None)!s}, '
                f'multiple_at_risk_activities={(self.multiple_at_risk_activities if hasattr(self, "multiple_at_risk_activities") else None)!s}, '
                f'multiple_passive_activities={(self.multiple_passive_activities if hasattr(self, "multiple_passive_activities") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
