# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.error_1 import Error1
from fdxapi.models.hateoas_link import HateoasLink
from fdxapi.models.tax_form_attribute import TaxFormAttribute
from fdxapi.models.tax_party_1 import TaxParty1
from fdxapi.models.tax_party_8 import TaxParty8


class Form1098C1(object):

    """Implementation of the 'Form 1098-C1' model.

    Contributions of Motor Vehicles, Boats, and Airplanes

    Attributes:
        tax_year (int): Year for which taxes are being paid
        corrected (bool): True to indicate this is a corrected tax form
        account_id (str): Long-term persistent identity of the source account.
            Not the account number
        tax_form_id (str): Long-term persistent id for this tax form.
            Depending upon the data provider, this may be the same id as the
            enclosing tax statement id, or this may be a different id, or this
            id may be omitted.
        tax_form_date (date): Date of production or delivery of the tax form
        additional_information (str): Additional explanation text or content
            about this tax form
        tax_form_type (TypeFormType1): Enumerated name of the tax form entity
            e.g. "TaxW2"
        issuer (TaxParty8): Issuer's name, address, phone, and TIN. Issuer
            data need only be transmitted on enclosing TaxStatement, if it is
            the same on all its included tax forms.
        recipient (TaxParty1): Recipient's name, address, phone, and TIN.
            Recipient data need only be transmitted on enclosing TaxStatement,
            if it is the same on all its included tax forms.
        attributes (List[TaxFormAttribute]): Additional attributes for this
            tax form when defined fields are not available. Some specific
            additional attributes already defined by providers: Fields
            required by [IRS
            FIRE](https://www.irs.gov/e-file-providers/filing-information-retur
            ns-electronically-fire): Name Control, Type of Identification
            Number (EIN, SSN, ITIN, ATIN). (ATIN is tax ID number for pending
            adoptions.) Tax form provider field for taxpayer notification:
            Recipient Email Address.
        error (Error1): Present if an error was encountered while retrieving
            this form
        links (List[HateoasLink]): Links to retrieve this form as data or
            image, or to invoke other APIs
        date_of_contribution (date): Box 1, Date of contribution
        odometer_mileage (int): Box 2a, Odometer mileage
        car_year (int): Box 2b, Year
        make (str): Box 2c, Make
        model (str): Box 2d, Model
        vin (str): Box 3, Vehicle or other identification number
        arms_length_transaction (bool): Box 4a, Donee certifies that vehicle
            was sold in arm's length transaction to unrelated party
        date_of_sale (date): Box 4b, Date of sale
        gross_proceeds (float): Box 4c, Gross proceeds from sale (see
            instructions)
        not_transferred_before (bool): Box 5a, Donee certifies that vehicle
            will not be transferred for money, other property, or services
            before completion of material improvements or significant
            intervening use
        needy_individual (bool): Box 5b, Donee certifies that vehicle is to be
            transferred to a needy individual for significantly below fair
            market value in furtherance of donee's charitable purpose
        description_of_improvements (str): Box 5c, Donee certifies the
            following detailed description of material improvements or
            significant intervening use and duration of use
        goods_in_exchange (bool): Box 6a, Did you provide goods or services in
            exchange for the vehicle? Yes
        value_of_exchange (float): Box 6b, Value of goods and services
            provided in exchange for the vehicle
        intangible_religious (bool): Box 6c, If this box is checked, donee
            certifies that the goods and services consisted solely of
            intangible religious benefits
        description_of_goods (str): Box 6c, Describe the goods and services,
            if any, that were provided
        max_deduction_applies (bool): Box 7, Under the law, the donor may not
            claim a deduction of more than $500 for this vehicle if this box
            is checked
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "tax_year": 'taxYear',
        "corrected": 'corrected',
        "account_id": 'accountId',
        "tax_form_id": 'taxFormId',
        "tax_form_date": 'taxFormDate',
        "additional_information": 'additionalInformation',
        "tax_form_type": 'taxFormType',
        "issuer": 'issuer',
        "recipient": 'recipient',
        "attributes": 'attributes',
        "error": 'error',
        "links": 'links',
        "date_of_contribution": 'dateOfContribution',
        "odometer_mileage": 'odometerMileage',
        "car_year": 'carYear',
        "make": 'make',
        "model": 'model',
        "vin": 'vin',
        "arms_length_transaction": 'armsLengthTransaction',
        "date_of_sale": 'dateOfSale',
        "gross_proceeds": 'grossProceeds',
        "not_transferred_before": 'notTransferredBefore',
        "needy_individual": 'needyIndividual',
        "description_of_improvements": 'descriptionOfImprovements',
        "goods_in_exchange": 'goodsInExchange',
        "value_of_exchange": 'valueOfExchange',
        "intangible_religious": 'intangibleReligious',
        "description_of_goods": 'descriptionOfGoods',
        "max_deduction_applies": 'maxDeductionApplies'
    }

    _optionals = [
        'tax_year',
        'corrected',
        'account_id',
        'tax_form_id',
        'tax_form_date',
        'additional_information',
        'tax_form_type',
        'issuer',
        'recipient',
        'attributes',
        'error',
        'links',
        'date_of_contribution',
        'odometer_mileage',
        'car_year',
        'make',
        'model',
        'vin',
        'arms_length_transaction',
        'date_of_sale',
        'gross_proceeds',
        'not_transferred_before',
        'needy_individual',
        'description_of_improvements',
        'goods_in_exchange',
        'value_of_exchange',
        'intangible_religious',
        'description_of_goods',
        'max_deduction_applies',
    ]

    def __init__(self,
                 tax_year=APIHelper.SKIP,
                 corrected=APIHelper.SKIP,
                 account_id=APIHelper.SKIP,
                 tax_form_id=APIHelper.SKIP,
                 tax_form_date=APIHelper.SKIP,
                 additional_information=APIHelper.SKIP,
                 tax_form_type=APIHelper.SKIP,
                 issuer=APIHelper.SKIP,
                 recipient=APIHelper.SKIP,
                 attributes=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 date_of_contribution=APIHelper.SKIP,
                 odometer_mileage=APIHelper.SKIP,
                 car_year=APIHelper.SKIP,
                 make=APIHelper.SKIP,
                 model=APIHelper.SKIP,
                 vin=APIHelper.SKIP,
                 arms_length_transaction=APIHelper.SKIP,
                 date_of_sale=APIHelper.SKIP,
                 gross_proceeds=APIHelper.SKIP,
                 not_transferred_before=APIHelper.SKIP,
                 needy_individual=APIHelper.SKIP,
                 description_of_improvements=APIHelper.SKIP,
                 goods_in_exchange=APIHelper.SKIP,
                 value_of_exchange=APIHelper.SKIP,
                 intangible_religious=APIHelper.SKIP,
                 description_of_goods=APIHelper.SKIP,
                 max_deduction_applies=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the Form1098C1 class"""

        # Initialize members of the class
        if tax_year is not APIHelper.SKIP:
            self.tax_year = tax_year 
        if corrected is not APIHelper.SKIP:
            self.corrected = corrected 
        if account_id is not APIHelper.SKIP:
            self.account_id = account_id 
        if tax_form_id is not APIHelper.SKIP:
            self.tax_form_id = tax_form_id 
        if tax_form_date is not APIHelper.SKIP:
            self.tax_form_date = tax_form_date 
        if additional_information is not APIHelper.SKIP:
            self.additional_information = additional_information 
        if tax_form_type is not APIHelper.SKIP:
            self.tax_form_type = tax_form_type 
        if issuer is not APIHelper.SKIP:
            self.issuer = issuer 
        if recipient is not APIHelper.SKIP:
            self.recipient = recipient 
        if attributes is not APIHelper.SKIP:
            self.attributes = attributes 
        if error is not APIHelper.SKIP:
            self.error = error 
        if links is not APIHelper.SKIP:
            self.links = links 
        if date_of_contribution is not APIHelper.SKIP:
            self.date_of_contribution = date_of_contribution 
        if odometer_mileage is not APIHelper.SKIP:
            self.odometer_mileage = odometer_mileage 
        if car_year is not APIHelper.SKIP:
            self.car_year = car_year 
        if make is not APIHelper.SKIP:
            self.make = make 
        if model is not APIHelper.SKIP:
            self.model = model 
        if vin is not APIHelper.SKIP:
            self.vin = vin 
        if arms_length_transaction is not APIHelper.SKIP:
            self.arms_length_transaction = arms_length_transaction 
        if date_of_sale is not APIHelper.SKIP:
            self.date_of_sale = date_of_sale 
        if gross_proceeds is not APIHelper.SKIP:
            self.gross_proceeds = gross_proceeds 
        if not_transferred_before is not APIHelper.SKIP:
            self.not_transferred_before = not_transferred_before 
        if needy_individual is not APIHelper.SKIP:
            self.needy_individual = needy_individual 
        if description_of_improvements is not APIHelper.SKIP:
            self.description_of_improvements = description_of_improvements 
        if goods_in_exchange is not APIHelper.SKIP:
            self.goods_in_exchange = goods_in_exchange 
        if value_of_exchange is not APIHelper.SKIP:
            self.value_of_exchange = value_of_exchange 
        if intangible_religious is not APIHelper.SKIP:
            self.intangible_religious = intangible_religious 
        if description_of_goods is not APIHelper.SKIP:
            self.description_of_goods = description_of_goods 
        if max_deduction_applies is not APIHelper.SKIP:
            self.max_deduction_applies = max_deduction_applies 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        tax_year = dictionary.get("taxYear") if dictionary.get("taxYear") else APIHelper.SKIP
        corrected = dictionary.get("corrected") if "corrected" in dictionary.keys() else APIHelper.SKIP
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        tax_form_id = dictionary.get("taxFormId") if dictionary.get("taxFormId") else APIHelper.SKIP
        tax_form_date = dateutil.parser.parse(dictionary.get('taxFormDate')).date() if dictionary.get('taxFormDate') else APIHelper.SKIP
        additional_information = dictionary.get("additionalInformation") if dictionary.get("additionalInformation") else APIHelper.SKIP
        tax_form_type = dictionary.get("taxFormType") if dictionary.get("taxFormType") else APIHelper.SKIP
        issuer = TaxParty8.from_dictionary(dictionary.get('issuer')) if 'issuer' in dictionary.keys() else APIHelper.SKIP
        recipient = TaxParty1.from_dictionary(dictionary.get('recipient')) if 'recipient' in dictionary.keys() else APIHelper.SKIP
        attributes = None
        if dictionary.get('attributes') is not None:
            attributes = [TaxFormAttribute.from_dictionary(x) for x in dictionary.get('attributes')]
        else:
            attributes = APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        date_of_contribution = dateutil.parser.parse(dictionary.get('dateOfContribution')).date() if dictionary.get('dateOfContribution') else APIHelper.SKIP
        odometer_mileage = dictionary.get("odometerMileage") if dictionary.get("odometerMileage") else APIHelper.SKIP
        car_year = dictionary.get("carYear") if dictionary.get("carYear") else APIHelper.SKIP
        make = dictionary.get("make") if dictionary.get("make") else APIHelper.SKIP
        model = dictionary.get("model") if dictionary.get("model") else APIHelper.SKIP
        vin = dictionary.get("vin") if dictionary.get("vin") else APIHelper.SKIP
        arms_length_transaction = dictionary.get("armsLengthTransaction") if "armsLengthTransaction" in dictionary.keys() else APIHelper.SKIP
        date_of_sale = dateutil.parser.parse(dictionary.get('dateOfSale')).date() if dictionary.get('dateOfSale') else APIHelper.SKIP
        gross_proceeds = dictionary.get("grossProceeds") if dictionary.get("grossProceeds") else APIHelper.SKIP
        not_transferred_before = dictionary.get("notTransferredBefore") if "notTransferredBefore" in dictionary.keys() else APIHelper.SKIP
        needy_individual = dictionary.get("needyIndividual") if "needyIndividual" in dictionary.keys() else APIHelper.SKIP
        description_of_improvements = dictionary.get("descriptionOfImprovements") if dictionary.get("descriptionOfImprovements") else APIHelper.SKIP
        goods_in_exchange = dictionary.get("goodsInExchange") if "goodsInExchange" in dictionary.keys() else APIHelper.SKIP
        value_of_exchange = dictionary.get("valueOfExchange") if dictionary.get("valueOfExchange") else APIHelper.SKIP
        intangible_religious = dictionary.get("intangibleReligious") if "intangibleReligious" in dictionary.keys() else APIHelper.SKIP
        description_of_goods = dictionary.get("descriptionOfGoods") if dictionary.get("descriptionOfGoods") else APIHelper.SKIP
        max_deduction_applies = dictionary.get("maxDeductionApplies") if "maxDeductionApplies" in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(tax_year,
                   corrected,
                   account_id,
                   tax_form_id,
                   tax_form_date,
                   additional_information,
                   tax_form_type,
                   issuer,
                   recipient,
                   attributes,
                   error,
                   links,
                   date_of_contribution,
                   odometer_mileage,
                   car_year,
                   make,
                   model,
                   vin,
                   arms_length_transaction,
                   date_of_sale,
                   gross_proceeds,
                   not_transferred_before,
                   needy_individual,
                   description_of_improvements,
                   goods_in_exchange,
                   value_of_exchange,
                   intangible_religious,
                   description_of_goods,
                   max_deduction_applies,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!r}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!r}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!r}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!r}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!r}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!r}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!r}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!r}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!r}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!r}, '
                f'error={(self.error if hasattr(self, "error") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'date_of_contribution={(self.date_of_contribution if hasattr(self, "date_of_contribution") else None)!r}, '
                f'odometer_mileage={(self.odometer_mileage if hasattr(self, "odometer_mileage") else None)!r}, '
                f'car_year={(self.car_year if hasattr(self, "car_year") else None)!r}, '
                f'make={(self.make if hasattr(self, "make") else None)!r}, '
                f'model={(self.model if hasattr(self, "model") else None)!r}, '
                f'vin={(self.vin if hasattr(self, "vin") else None)!r}, '
                f'arms_length_transaction={(self.arms_length_transaction if hasattr(self, "arms_length_transaction") else None)!r}, '
                f'date_of_sale={(self.date_of_sale if hasattr(self, "date_of_sale") else None)!r}, '
                f'gross_proceeds={(self.gross_proceeds if hasattr(self, "gross_proceeds") else None)!r}, '
                f'not_transferred_before={(self.not_transferred_before if hasattr(self, "not_transferred_before") else None)!r}, '
                f'needy_individual={(self.needy_individual if hasattr(self, "needy_individual") else None)!r}, '
                f'description_of_improvements={(self.description_of_improvements if hasattr(self, "description_of_improvements") else None)!r}, '
                f'goods_in_exchange={(self.goods_in_exchange if hasattr(self, "goods_in_exchange") else None)!r}, '
                f'value_of_exchange={(self.value_of_exchange if hasattr(self, "value_of_exchange") else None)!r}, '
                f'intangible_religious={(self.intangible_religious if hasattr(self, "intangible_religious") else None)!r}, '
                f'description_of_goods={(self.description_of_goods if hasattr(self, "description_of_goods") else None)!r}, '
                f'max_deduction_applies={(self.max_deduction_applies if hasattr(self, "max_deduction_applies") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!s}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!s}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!s}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!s}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!s}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!s}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!s}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!s}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!s}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!s}, '
                f'error={(self.error if hasattr(self, "error") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'date_of_contribution={(self.date_of_contribution if hasattr(self, "date_of_contribution") else None)!s}, '
                f'odometer_mileage={(self.odometer_mileage if hasattr(self, "odometer_mileage") else None)!s}, '
                f'car_year={(self.car_year if hasattr(self, "car_year") else None)!s}, '
                f'make={(self.make if hasattr(self, "make") else None)!s}, '
                f'model={(self.model if hasattr(self, "model") else None)!s}, '
                f'vin={(self.vin if hasattr(self, "vin") else None)!s}, '
                f'arms_length_transaction={(self.arms_length_transaction if hasattr(self, "arms_length_transaction") else None)!s}, '
                f'date_of_sale={(self.date_of_sale if hasattr(self, "date_of_sale") else None)!s}, '
                f'gross_proceeds={(self.gross_proceeds if hasattr(self, "gross_proceeds") else None)!s}, '
                f'not_transferred_before={(self.not_transferred_before if hasattr(self, "not_transferred_before") else None)!s}, '
                f'needy_individual={(self.needy_individual if hasattr(self, "needy_individual") else None)!s}, '
                f'description_of_improvements={(self.description_of_improvements if hasattr(self, "description_of_improvements") else None)!s}, '
                f'goods_in_exchange={(self.goods_in_exchange if hasattr(self, "goods_in_exchange") else None)!s}, '
                f'value_of_exchange={(self.value_of_exchange if hasattr(self, "value_of_exchange") else None)!s}, '
                f'intangible_religious={(self.intangible_religious if hasattr(self, "intangible_religious") else None)!s}, '
                f'description_of_goods={(self.description_of_goods if hasattr(self, "description_of_goods") else None)!s}, '
                f'max_deduction_applies={(self.max_deduction_applies if hasattr(self, "max_deduction_applies") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
