# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.date_and_amount import DateAndAmount
from fdxapi.models.error_1 import Error1
from fdxapi.models.hateoas_link import HateoasLink
from fdxapi.models.tax_form_attribute import TaxFormAttribute
from fdxapi.models.tax_party_1 import TaxParty1
from fdxapi.models.tax_party_8 import TaxParty8


class Form1098Q1(object):

    """Implementation of the 'Form 1098-Q1' model.

    Qualifying Longevity Annuity Contract Information

    Attributes:
        tax_year (int): Year for which taxes are being paid
        corrected (bool): True to indicate this is a corrected tax form
        account_id (str): Long-term persistent identity of the source account.
            Not the account number
        tax_form_id (str): Long-term persistent id for this tax form.
            Depending upon the data provider, this may be the same id as the
            enclosing tax statement id, or this may be a different id, or this
            id may be omitted.
        tax_form_date (date): Date of production or delivery of the tax form
        additional_information (str): Additional explanation text or content
            about this tax form
        tax_form_type (TypeFormType1): Enumerated name of the tax form entity
            e.g. "TaxW2"
        issuer (TaxParty8): Issuer's name, address, phone, and TIN. Issuer
            data need only be transmitted on enclosing TaxStatement, if it is
            the same on all its included tax forms.
        recipient (TaxParty1): Recipient's name, address, phone, and TIN.
            Recipient data need only be transmitted on enclosing TaxStatement,
            if it is the same on all its included tax forms.
        attributes (List[TaxFormAttribute]): Additional attributes for this
            tax form when defined fields are not available. Some specific
            additional attributes already defined by providers: Fields
            required by [IRS
            FIRE](https://www.irs.gov/e-file-providers/filing-information-retur
            ns-electronically-fire): Name Control, Type of Identification
            Number (EIN, SSN, ITIN, ATIN). (ATIN is tax ID number for pending
            adoptions.) Tax form provider field for taxpayer notification:
            Recipient Email Address.
        error (Error1): Present if an error was encountered while retrieving
            this form
        links (List[HateoasLink]): Links to retrieve this form as data or
            image, or to invoke other APIs
        account_number (str): Account number
        plan_number (str): Plan number
        plan_name (str): Plan name
        plan_sponsor_id (str): Plan sponsor's EIN
        annuity_amount (float): Box 1a, Annuity amount on start date
        start_date (date): Box 1b, Annuity start date
        can_be_accelerated (bool): Box 2, Start date may be accelerated
        total_premiums (float): Box 3, Total premiums
        fair_market_value (float): Box 4, Fair market value of qualifying
            longevity annuity contract (FMV of QLAC)
        premiums (List[DateAndAmount]): Box 5, Total monthly premiums paid for
            the contract and date of the last payment in the month
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "tax_year": 'taxYear',
        "corrected": 'corrected',
        "account_id": 'accountId',
        "tax_form_id": 'taxFormId',
        "tax_form_date": 'taxFormDate',
        "additional_information": 'additionalInformation',
        "tax_form_type": 'taxFormType',
        "issuer": 'issuer',
        "recipient": 'recipient',
        "attributes": 'attributes',
        "error": 'error',
        "links": 'links',
        "account_number": 'accountNumber',
        "plan_number": 'planNumber',
        "plan_name": 'planName',
        "plan_sponsor_id": 'planSponsorId',
        "annuity_amount": 'annuityAmount',
        "start_date": 'startDate',
        "can_be_accelerated": 'canBeAccelerated',
        "total_premiums": 'totalPremiums',
        "fair_market_value": 'fairMarketValue',
        "premiums": 'premiums'
    }

    _optionals = [
        'tax_year',
        'corrected',
        'account_id',
        'tax_form_id',
        'tax_form_date',
        'additional_information',
        'tax_form_type',
        'issuer',
        'recipient',
        'attributes',
        'error',
        'links',
        'account_number',
        'plan_number',
        'plan_name',
        'plan_sponsor_id',
        'annuity_amount',
        'start_date',
        'can_be_accelerated',
        'total_premiums',
        'fair_market_value',
        'premiums',
    ]

    def __init__(self,
                 tax_year=APIHelper.SKIP,
                 corrected=APIHelper.SKIP,
                 account_id=APIHelper.SKIP,
                 tax_form_id=APIHelper.SKIP,
                 tax_form_date=APIHelper.SKIP,
                 additional_information=APIHelper.SKIP,
                 tax_form_type=APIHelper.SKIP,
                 issuer=APIHelper.SKIP,
                 recipient=APIHelper.SKIP,
                 attributes=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 account_number=APIHelper.SKIP,
                 plan_number=APIHelper.SKIP,
                 plan_name=APIHelper.SKIP,
                 plan_sponsor_id=APIHelper.SKIP,
                 annuity_amount=APIHelper.SKIP,
                 start_date=APIHelper.SKIP,
                 can_be_accelerated=APIHelper.SKIP,
                 total_premiums=APIHelper.SKIP,
                 fair_market_value=APIHelper.SKIP,
                 premiums=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the Form1098Q1 class"""

        # Initialize members of the class
        if tax_year is not APIHelper.SKIP:
            self.tax_year = tax_year 
        if corrected is not APIHelper.SKIP:
            self.corrected = corrected 
        if account_id is not APIHelper.SKIP:
            self.account_id = account_id 
        if tax_form_id is not APIHelper.SKIP:
            self.tax_form_id = tax_form_id 
        if tax_form_date is not APIHelper.SKIP:
            self.tax_form_date = tax_form_date 
        if additional_information is not APIHelper.SKIP:
            self.additional_information = additional_information 
        if tax_form_type is not APIHelper.SKIP:
            self.tax_form_type = tax_form_type 
        if issuer is not APIHelper.SKIP:
            self.issuer = issuer 
        if recipient is not APIHelper.SKIP:
            self.recipient = recipient 
        if attributes is not APIHelper.SKIP:
            self.attributes = attributes 
        if error is not APIHelper.SKIP:
            self.error = error 
        if links is not APIHelper.SKIP:
            self.links = links 
        if account_number is not APIHelper.SKIP:
            self.account_number = account_number 
        if plan_number is not APIHelper.SKIP:
            self.plan_number = plan_number 
        if plan_name is not APIHelper.SKIP:
            self.plan_name = plan_name 
        if plan_sponsor_id is not APIHelper.SKIP:
            self.plan_sponsor_id = plan_sponsor_id 
        if annuity_amount is not APIHelper.SKIP:
            self.annuity_amount = annuity_amount 
        if start_date is not APIHelper.SKIP:
            self.start_date = start_date 
        if can_be_accelerated is not APIHelper.SKIP:
            self.can_be_accelerated = can_be_accelerated 
        if total_premiums is not APIHelper.SKIP:
            self.total_premiums = total_premiums 
        if fair_market_value is not APIHelper.SKIP:
            self.fair_market_value = fair_market_value 
        if premiums is not APIHelper.SKIP:
            self.premiums = premiums 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        tax_year = dictionary.get("taxYear") if dictionary.get("taxYear") else APIHelper.SKIP
        corrected = dictionary.get("corrected") if "corrected" in dictionary.keys() else APIHelper.SKIP
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        tax_form_id = dictionary.get("taxFormId") if dictionary.get("taxFormId") else APIHelper.SKIP
        tax_form_date = dateutil.parser.parse(dictionary.get('taxFormDate')).date() if dictionary.get('taxFormDate') else APIHelper.SKIP
        additional_information = dictionary.get("additionalInformation") if dictionary.get("additionalInformation") else APIHelper.SKIP
        tax_form_type = dictionary.get("taxFormType") if dictionary.get("taxFormType") else APIHelper.SKIP
        issuer = TaxParty8.from_dictionary(dictionary.get('issuer')) if 'issuer' in dictionary.keys() else APIHelper.SKIP
        recipient = TaxParty1.from_dictionary(dictionary.get('recipient')) if 'recipient' in dictionary.keys() else APIHelper.SKIP
        attributes = None
        if dictionary.get('attributes') is not None:
            attributes = [TaxFormAttribute.from_dictionary(x) for x in dictionary.get('attributes')]
        else:
            attributes = APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        account_number = dictionary.get("accountNumber") if dictionary.get("accountNumber") else APIHelper.SKIP
        plan_number = dictionary.get("planNumber") if dictionary.get("planNumber") else APIHelper.SKIP
        plan_name = dictionary.get("planName") if dictionary.get("planName") else APIHelper.SKIP
        plan_sponsor_id = dictionary.get("planSponsorId") if dictionary.get("planSponsorId") else APIHelper.SKIP
        annuity_amount = dictionary.get("annuityAmount") if dictionary.get("annuityAmount") else APIHelper.SKIP
        start_date = dateutil.parser.parse(dictionary.get('startDate')).date() if dictionary.get('startDate') else APIHelper.SKIP
        can_be_accelerated = dictionary.get("canBeAccelerated") if "canBeAccelerated" in dictionary.keys() else APIHelper.SKIP
        total_premiums = dictionary.get("totalPremiums") if dictionary.get("totalPremiums") else APIHelper.SKIP
        fair_market_value = dictionary.get("fairMarketValue") if dictionary.get("fairMarketValue") else APIHelper.SKIP
        premiums = None
        if dictionary.get('premiums') is not None:
            premiums = [DateAndAmount.from_dictionary(x) for x in dictionary.get('premiums')]
        else:
            premiums = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(tax_year,
                   corrected,
                   account_id,
                   tax_form_id,
                   tax_form_date,
                   additional_information,
                   tax_form_type,
                   issuer,
                   recipient,
                   attributes,
                   error,
                   links,
                   account_number,
                   plan_number,
                   plan_name,
                   plan_sponsor_id,
                   annuity_amount,
                   start_date,
                   can_be_accelerated,
                   total_premiums,
                   fair_market_value,
                   premiums,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!r}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!r}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!r}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!r}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!r}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!r}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!r}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!r}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!r}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!r}, '
                f'error={(self.error if hasattr(self, "error") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!r}, '
                f'plan_number={(self.plan_number if hasattr(self, "plan_number") else None)!r}, '
                f'plan_name={(self.plan_name if hasattr(self, "plan_name") else None)!r}, '
                f'plan_sponsor_id={(self.plan_sponsor_id if hasattr(self, "plan_sponsor_id") else None)!r}, '
                f'annuity_amount={(self.annuity_amount if hasattr(self, "annuity_amount") else None)!r}, '
                f'start_date={(self.start_date if hasattr(self, "start_date") else None)!r}, '
                f'can_be_accelerated={(self.can_be_accelerated if hasattr(self, "can_be_accelerated") else None)!r}, '
                f'total_premiums={(self.total_premiums if hasattr(self, "total_premiums") else None)!r}, '
                f'fair_market_value={(self.fair_market_value if hasattr(self, "fair_market_value") else None)!r}, '
                f'premiums={(self.premiums if hasattr(self, "premiums") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!s}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!s}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!s}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!s}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!s}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!s}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!s}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!s}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!s}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!s}, '
                f'error={(self.error if hasattr(self, "error") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!s}, '
                f'plan_number={(self.plan_number if hasattr(self, "plan_number") else None)!s}, '
                f'plan_name={(self.plan_name if hasattr(self, "plan_name") else None)!s}, '
                f'plan_sponsor_id={(self.plan_sponsor_id if hasattr(self, "plan_sponsor_id") else None)!s}, '
                f'annuity_amount={(self.annuity_amount if hasattr(self, "annuity_amount") else None)!s}, '
                f'start_date={(self.start_date if hasattr(self, "start_date") else None)!s}, '
                f'can_be_accelerated={(self.can_be_accelerated if hasattr(self, "can_be_accelerated") else None)!s}, '
                f'total_premiums={(self.total_premiums if hasattr(self, "total_premiums") else None)!s}, '
                f'fair_market_value={(self.fair_market_value if hasattr(self, "fair_market_value") else None)!s}, '
                f'premiums={(self.premiums if hasattr(self, "premiums") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
