# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.error_1 import Error1
from fdxapi.models.hateoas_link import HateoasLink
from fdxapi.models.tax_form_attribute import TaxFormAttribute
from fdxapi.models.tax_party_1 import TaxParty1
from fdxapi.models.tax_party_8 import TaxParty8


class Form1098T(object):

    """Implementation of the 'Form 1098-T' model.

    Tuition Statement, from FILER (1st-2nd boxes as issuer) to STUDENT
    (3rd-6th boxes as recipient)

    Attributes:
        tax_year (int): Year for which taxes are being paid
        corrected (bool): True to indicate this is a corrected tax form
        account_id (str): Long-term persistent identity of the source account.
            Not the account number
        tax_form_id (str): Long-term persistent id for this tax form.
            Depending upon the data provider, this may be the same id as the
            enclosing tax statement id, or this may be a different id, or this
            id may be omitted.
        tax_form_date (date): Date of production or delivery of the tax form
        additional_information (str): Additional explanation text or content
            about this tax form
        tax_form_type (TypeFormType1): Enumerated name of the tax form entity
            e.g. "TaxW2"
        issuer (TaxParty8): Issuer's name, address, phone, and TIN. Issuer
            data need only be transmitted on enclosing TaxStatement, if it is
            the same on all its included tax forms.
        recipient (TaxParty1): Recipient's name, address, phone, and TIN.
            Recipient data need only be transmitted on enclosing TaxStatement,
            if it is the same on all its included tax forms.
        attributes (List[TaxFormAttribute]): Additional attributes for this
            tax form when defined fields are not available. Some specific
            additional attributes already defined by providers: Fields
            required by [IRS
            FIRE](https://www.irs.gov/e-file-providers/filing-information-retur
            ns-electronically-fire): Name Control, Type of Identification
            Number (EIN, SSN, ITIN, ATIN). (ATIN is tax ID number for pending
            adoptions.) Tax form provider field for taxpayer notification:
            Recipient Email Address.
        error (Error1): Present if an error was encountered while retrieving
            this form
        links (List[HateoasLink]): Links to retrieve this form as data or
            image, or to invoke other APIs
        student_tin_certification (bool): By checking the box in STUDENT'S
            TIN, filer is making a true and accurate certification under
            penalty of perjury that they have complied with standards
            promulgated by the Secretary for obtaining such individual's TIN
        account_number (str): Account number
        half_time (bool): Box 8, Check if at least half-time student
        qualified_tuition_fees (float): Box 1, Payments received for qualified
            tuition and related expenses
        adjustment_prior_year (float): Box 4, Adjustments made for a prior year
        scholarship (float): Box 5, Scholarships or grants
        adjust_scholarship (float): Box 6, Adjustments to scholarships or
            grants for a prior year
        include_jan_mar (bool): Box 7, Check if the amount in box 1 or box 2
            includes amounts for an academic period beginning January - March
            of next year
        graduate (bool): Box 9, Check if graduate student
        insurance_refund (float): Box 10, Insurance contract reimbursement /
            refund
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "tax_year": 'taxYear',
        "corrected": 'corrected',
        "account_id": 'accountId',
        "tax_form_id": 'taxFormId',
        "tax_form_date": 'taxFormDate',
        "additional_information": 'additionalInformation',
        "tax_form_type": 'taxFormType',
        "issuer": 'issuer',
        "recipient": 'recipient',
        "attributes": 'attributes',
        "error": 'error',
        "links": 'links',
        "student_tin_certification": 'studentTinCertification',
        "account_number": 'accountNumber',
        "half_time": 'halfTime',
        "qualified_tuition_fees": 'qualifiedTuitionFees',
        "adjustment_prior_year": 'adjustmentPriorYear',
        "scholarship": 'scholarship',
        "adjust_scholarship": 'adjustScholarship',
        "include_jan_mar": 'includeJanMar',
        "graduate": 'graduate',
        "insurance_refund": 'insuranceRefund'
    }

    _optionals = [
        'tax_year',
        'corrected',
        'account_id',
        'tax_form_id',
        'tax_form_date',
        'additional_information',
        'tax_form_type',
        'issuer',
        'recipient',
        'attributes',
        'error',
        'links',
        'student_tin_certification',
        'account_number',
        'half_time',
        'qualified_tuition_fees',
        'adjustment_prior_year',
        'scholarship',
        'adjust_scholarship',
        'include_jan_mar',
        'graduate',
        'insurance_refund',
    ]

    def __init__(self,
                 tax_year=APIHelper.SKIP,
                 corrected=APIHelper.SKIP,
                 account_id=APIHelper.SKIP,
                 tax_form_id=APIHelper.SKIP,
                 tax_form_date=APIHelper.SKIP,
                 additional_information=APIHelper.SKIP,
                 tax_form_type=APIHelper.SKIP,
                 issuer=APIHelper.SKIP,
                 recipient=APIHelper.SKIP,
                 attributes=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 student_tin_certification=APIHelper.SKIP,
                 account_number=APIHelper.SKIP,
                 half_time=APIHelper.SKIP,
                 qualified_tuition_fees=APIHelper.SKIP,
                 adjustment_prior_year=APIHelper.SKIP,
                 scholarship=APIHelper.SKIP,
                 adjust_scholarship=APIHelper.SKIP,
                 include_jan_mar=APIHelper.SKIP,
                 graduate=APIHelper.SKIP,
                 insurance_refund=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the Form1098T class"""

        # Initialize members of the class
        if tax_year is not APIHelper.SKIP:
            self.tax_year = tax_year 
        if corrected is not APIHelper.SKIP:
            self.corrected = corrected 
        if account_id is not APIHelper.SKIP:
            self.account_id = account_id 
        if tax_form_id is not APIHelper.SKIP:
            self.tax_form_id = tax_form_id 
        if tax_form_date is not APIHelper.SKIP:
            self.tax_form_date = tax_form_date 
        if additional_information is not APIHelper.SKIP:
            self.additional_information = additional_information 
        if tax_form_type is not APIHelper.SKIP:
            self.tax_form_type = tax_form_type 
        if issuer is not APIHelper.SKIP:
            self.issuer = issuer 
        if recipient is not APIHelper.SKIP:
            self.recipient = recipient 
        if attributes is not APIHelper.SKIP:
            self.attributes = attributes 
        if error is not APIHelper.SKIP:
            self.error = error 
        if links is not APIHelper.SKIP:
            self.links = links 
        if student_tin_certification is not APIHelper.SKIP:
            self.student_tin_certification = student_tin_certification 
        if account_number is not APIHelper.SKIP:
            self.account_number = account_number 
        if half_time is not APIHelper.SKIP:
            self.half_time = half_time 
        if qualified_tuition_fees is not APIHelper.SKIP:
            self.qualified_tuition_fees = qualified_tuition_fees 
        if adjustment_prior_year is not APIHelper.SKIP:
            self.adjustment_prior_year = adjustment_prior_year 
        if scholarship is not APIHelper.SKIP:
            self.scholarship = scholarship 
        if adjust_scholarship is not APIHelper.SKIP:
            self.adjust_scholarship = adjust_scholarship 
        if include_jan_mar is not APIHelper.SKIP:
            self.include_jan_mar = include_jan_mar 
        if graduate is not APIHelper.SKIP:
            self.graduate = graduate 
        if insurance_refund is not APIHelper.SKIP:
            self.insurance_refund = insurance_refund 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        tax_year = dictionary.get("taxYear") if dictionary.get("taxYear") else APIHelper.SKIP
        corrected = dictionary.get("corrected") if "corrected" in dictionary.keys() else APIHelper.SKIP
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        tax_form_id = dictionary.get("taxFormId") if dictionary.get("taxFormId") else APIHelper.SKIP
        tax_form_date = dateutil.parser.parse(dictionary.get('taxFormDate')).date() if dictionary.get('taxFormDate') else APIHelper.SKIP
        additional_information = dictionary.get("additionalInformation") if dictionary.get("additionalInformation") else APIHelper.SKIP
        tax_form_type = dictionary.get("taxFormType") if dictionary.get("taxFormType") else APIHelper.SKIP
        issuer = TaxParty8.from_dictionary(dictionary.get('issuer')) if 'issuer' in dictionary.keys() else APIHelper.SKIP
        recipient = TaxParty1.from_dictionary(dictionary.get('recipient')) if 'recipient' in dictionary.keys() else APIHelper.SKIP
        attributes = None
        if dictionary.get('attributes') is not None:
            attributes = [TaxFormAttribute.from_dictionary(x) for x in dictionary.get('attributes')]
        else:
            attributes = APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        student_tin_certification = dictionary.get("studentTinCertification") if "studentTinCertification" in dictionary.keys() else APIHelper.SKIP
        account_number = dictionary.get("accountNumber") if dictionary.get("accountNumber") else APIHelper.SKIP
        half_time = dictionary.get("halfTime") if "halfTime" in dictionary.keys() else APIHelper.SKIP
        qualified_tuition_fees = dictionary.get("qualifiedTuitionFees") if dictionary.get("qualifiedTuitionFees") else APIHelper.SKIP
        adjustment_prior_year = dictionary.get("adjustmentPriorYear") if dictionary.get("adjustmentPriorYear") else APIHelper.SKIP
        scholarship = dictionary.get("scholarship") if dictionary.get("scholarship") else APIHelper.SKIP
        adjust_scholarship = dictionary.get("adjustScholarship") if dictionary.get("adjustScholarship") else APIHelper.SKIP
        include_jan_mar = dictionary.get("includeJanMar") if "includeJanMar" in dictionary.keys() else APIHelper.SKIP
        graduate = dictionary.get("graduate") if "graduate" in dictionary.keys() else APIHelper.SKIP
        insurance_refund = dictionary.get("insuranceRefund") if dictionary.get("insuranceRefund") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(tax_year,
                   corrected,
                   account_id,
                   tax_form_id,
                   tax_form_date,
                   additional_information,
                   tax_form_type,
                   issuer,
                   recipient,
                   attributes,
                   error,
                   links,
                   student_tin_certification,
                   account_number,
                   half_time,
                   qualified_tuition_fees,
                   adjustment_prior_year,
                   scholarship,
                   adjust_scholarship,
                   include_jan_mar,
                   graduate,
                   insurance_refund,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!r}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!r}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!r}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!r}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!r}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!r}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!r}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!r}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!r}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!r}, '
                f'error={(self.error if hasattr(self, "error") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'student_tin_certification={(self.student_tin_certification if hasattr(self, "student_tin_certification") else None)!r}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!r}, '
                f'half_time={(self.half_time if hasattr(self, "half_time") else None)!r}, '
                f'qualified_tuition_fees={(self.qualified_tuition_fees if hasattr(self, "qualified_tuition_fees") else None)!r}, '
                f'adjustment_prior_year={(self.adjustment_prior_year if hasattr(self, "adjustment_prior_year") else None)!r}, '
                f'scholarship={(self.scholarship if hasattr(self, "scholarship") else None)!r}, '
                f'adjust_scholarship={(self.adjust_scholarship if hasattr(self, "adjust_scholarship") else None)!r}, '
                f'include_jan_mar={(self.include_jan_mar if hasattr(self, "include_jan_mar") else None)!r}, '
                f'graduate={(self.graduate if hasattr(self, "graduate") else None)!r}, '
                f'insurance_refund={(self.insurance_refund if hasattr(self, "insurance_refund") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!s}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!s}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!s}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!s}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!s}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!s}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!s}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!s}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!s}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!s}, '
                f'error={(self.error if hasattr(self, "error") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'student_tin_certification={(self.student_tin_certification if hasattr(self, "student_tin_certification") else None)!s}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!s}, '
                f'half_time={(self.half_time if hasattr(self, "half_time") else None)!s}, '
                f'qualified_tuition_fees={(self.qualified_tuition_fees if hasattr(self, "qualified_tuition_fees") else None)!s}, '
                f'adjustment_prior_year={(self.adjustment_prior_year if hasattr(self, "adjustment_prior_year") else None)!s}, '
                f'scholarship={(self.scholarship if hasattr(self, "scholarship") else None)!s}, '
                f'adjust_scholarship={(self.adjust_scholarship if hasattr(self, "adjust_scholarship") else None)!s}, '
                f'include_jan_mar={(self.include_jan_mar if hasattr(self, "include_jan_mar") else None)!s}, '
                f'graduate={(self.graduate if hasattr(self, "graduate") else None)!s}, '
                f'insurance_refund={(self.insurance_refund if hasattr(self, "insurance_refund") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
