# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.error_1 import Error1
from fdxapi.models.hateoas_link import HateoasLink
from fdxapi.models.tax_form_attribute import TaxFormAttribute
from fdxapi.models.tax_party_1 import TaxParty1
from fdxapi.models.tax_party_8 import TaxParty8


class Form1099C1(object):

    """Implementation of the 'Form 1099-C1' model.

    Cancellation of Debt

    Attributes:
        tax_year (int): Year for which taxes are being paid
        corrected (bool): True to indicate this is a corrected tax form
        account_id (str): Long-term persistent identity of the source account.
            Not the account number
        tax_form_id (str): Long-term persistent id for this tax form.
            Depending upon the data provider, this may be the same id as the
            enclosing tax statement id, or this may be a different id, or this
            id may be omitted.
        tax_form_date (date): Date of production or delivery of the tax form
        additional_information (str): Additional explanation text or content
            about this tax form
        tax_form_type (TypeFormType1): Enumerated name of the tax form entity
            e.g. "TaxW2"
        issuer (TaxParty8): Issuer's name, address, phone, and TIN. Issuer
            data need only be transmitted on enclosing TaxStatement, if it is
            the same on all its included tax forms.
        recipient (TaxParty1): Recipient's name, address, phone, and TIN.
            Recipient data need only be transmitted on enclosing TaxStatement,
            if it is the same on all its included tax forms.
        attributes (List[TaxFormAttribute]): Additional attributes for this
            tax form when defined fields are not available. Some specific
            additional attributes already defined by providers: Fields
            required by [IRS
            FIRE](https://www.irs.gov/e-file-providers/filing-information-retur
            ns-electronically-fire): Name Control, Type of Identification
            Number (EIN, SSN, ITIN, ATIN). (ATIN is tax ID number for pending
            adoptions.) Tax form provider field for taxpayer notification:
            Recipient Email Address.
        error (Error1): Present if an error was encountered while retrieving
            this form
        links (List[HateoasLink]): Links to retrieve this form as data or
            image, or to invoke other APIs
        account_number (str): Account number
        date_of_event (date): Box 1, Date of identifiable event
        amount_discharged (float): Box 2, Amount of debt discharged
        interest_included (float): Box 3, Interest if included in box 2
        debt_description (str): Box 4, Debt description
        personally_liable (bool): Box 5, If checked, the debtor was personally
            liable for repayment of the debt
        debt_code (str): Box 6, Identifiable debt code
        fair_market_value (float): Box 7, Fair market value of property
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "tax_year": 'taxYear',
        "corrected": 'corrected',
        "account_id": 'accountId',
        "tax_form_id": 'taxFormId',
        "tax_form_date": 'taxFormDate',
        "additional_information": 'additionalInformation',
        "tax_form_type": 'taxFormType',
        "issuer": 'issuer',
        "recipient": 'recipient',
        "attributes": 'attributes',
        "error": 'error',
        "links": 'links',
        "account_number": 'accountNumber',
        "date_of_event": 'dateOfEvent',
        "amount_discharged": 'amountDischarged',
        "interest_included": 'interestIncluded',
        "debt_description": 'debtDescription',
        "personally_liable": 'personallyLiable',
        "debt_code": 'debtCode',
        "fair_market_value": 'fairMarketValue'
    }

    _optionals = [
        'tax_year',
        'corrected',
        'account_id',
        'tax_form_id',
        'tax_form_date',
        'additional_information',
        'tax_form_type',
        'issuer',
        'recipient',
        'attributes',
        'error',
        'links',
        'account_number',
        'date_of_event',
        'amount_discharged',
        'interest_included',
        'debt_description',
        'personally_liable',
        'debt_code',
        'fair_market_value',
    ]

    def __init__(self,
                 tax_year=APIHelper.SKIP,
                 corrected=APIHelper.SKIP,
                 account_id=APIHelper.SKIP,
                 tax_form_id=APIHelper.SKIP,
                 tax_form_date=APIHelper.SKIP,
                 additional_information=APIHelper.SKIP,
                 tax_form_type=APIHelper.SKIP,
                 issuer=APIHelper.SKIP,
                 recipient=APIHelper.SKIP,
                 attributes=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 account_number=APIHelper.SKIP,
                 date_of_event=APIHelper.SKIP,
                 amount_discharged=APIHelper.SKIP,
                 interest_included=APIHelper.SKIP,
                 debt_description=APIHelper.SKIP,
                 personally_liable=APIHelper.SKIP,
                 debt_code=APIHelper.SKIP,
                 fair_market_value=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the Form1099C1 class"""

        # Initialize members of the class
        if tax_year is not APIHelper.SKIP:
            self.tax_year = tax_year 
        if corrected is not APIHelper.SKIP:
            self.corrected = corrected 
        if account_id is not APIHelper.SKIP:
            self.account_id = account_id 
        if tax_form_id is not APIHelper.SKIP:
            self.tax_form_id = tax_form_id 
        if tax_form_date is not APIHelper.SKIP:
            self.tax_form_date = tax_form_date 
        if additional_information is not APIHelper.SKIP:
            self.additional_information = additional_information 
        if tax_form_type is not APIHelper.SKIP:
            self.tax_form_type = tax_form_type 
        if issuer is not APIHelper.SKIP:
            self.issuer = issuer 
        if recipient is not APIHelper.SKIP:
            self.recipient = recipient 
        if attributes is not APIHelper.SKIP:
            self.attributes = attributes 
        if error is not APIHelper.SKIP:
            self.error = error 
        if links is not APIHelper.SKIP:
            self.links = links 
        if account_number is not APIHelper.SKIP:
            self.account_number = account_number 
        if date_of_event is not APIHelper.SKIP:
            self.date_of_event = date_of_event 
        if amount_discharged is not APIHelper.SKIP:
            self.amount_discharged = amount_discharged 
        if interest_included is not APIHelper.SKIP:
            self.interest_included = interest_included 
        if debt_description is not APIHelper.SKIP:
            self.debt_description = debt_description 
        if personally_liable is not APIHelper.SKIP:
            self.personally_liable = personally_liable 
        if debt_code is not APIHelper.SKIP:
            self.debt_code = debt_code 
        if fair_market_value is not APIHelper.SKIP:
            self.fair_market_value = fair_market_value 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        tax_year = dictionary.get("taxYear") if dictionary.get("taxYear") else APIHelper.SKIP
        corrected = dictionary.get("corrected") if "corrected" in dictionary.keys() else APIHelper.SKIP
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        tax_form_id = dictionary.get("taxFormId") if dictionary.get("taxFormId") else APIHelper.SKIP
        tax_form_date = dateutil.parser.parse(dictionary.get('taxFormDate')).date() if dictionary.get('taxFormDate') else APIHelper.SKIP
        additional_information = dictionary.get("additionalInformation") if dictionary.get("additionalInformation") else APIHelper.SKIP
        tax_form_type = dictionary.get("taxFormType") if dictionary.get("taxFormType") else APIHelper.SKIP
        issuer = TaxParty8.from_dictionary(dictionary.get('issuer')) if 'issuer' in dictionary.keys() else APIHelper.SKIP
        recipient = TaxParty1.from_dictionary(dictionary.get('recipient')) if 'recipient' in dictionary.keys() else APIHelper.SKIP
        attributes = None
        if dictionary.get('attributes') is not None:
            attributes = [TaxFormAttribute.from_dictionary(x) for x in dictionary.get('attributes')]
        else:
            attributes = APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        account_number = dictionary.get("accountNumber") if dictionary.get("accountNumber") else APIHelper.SKIP
        date_of_event = dateutil.parser.parse(dictionary.get('dateOfEvent')).date() if dictionary.get('dateOfEvent') else APIHelper.SKIP
        amount_discharged = dictionary.get("amountDischarged") if dictionary.get("amountDischarged") else APIHelper.SKIP
        interest_included = dictionary.get("interestIncluded") if dictionary.get("interestIncluded") else APIHelper.SKIP
        debt_description = dictionary.get("debtDescription") if dictionary.get("debtDescription") else APIHelper.SKIP
        personally_liable = dictionary.get("personallyLiable") if "personallyLiable" in dictionary.keys() else APIHelper.SKIP
        debt_code = dictionary.get("debtCode") if dictionary.get("debtCode") else APIHelper.SKIP
        fair_market_value = dictionary.get("fairMarketValue") if dictionary.get("fairMarketValue") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(tax_year,
                   corrected,
                   account_id,
                   tax_form_id,
                   tax_form_date,
                   additional_information,
                   tax_form_type,
                   issuer,
                   recipient,
                   attributes,
                   error,
                   links,
                   account_number,
                   date_of_event,
                   amount_discharged,
                   interest_included,
                   debt_description,
                   personally_liable,
                   debt_code,
                   fair_market_value,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!r}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!r}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!r}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!r}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!r}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!r}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!r}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!r}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!r}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!r}, '
                f'error={(self.error if hasattr(self, "error") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!r}, '
                f'date_of_event={(self.date_of_event if hasattr(self, "date_of_event") else None)!r}, '
                f'amount_discharged={(self.amount_discharged if hasattr(self, "amount_discharged") else None)!r}, '
                f'interest_included={(self.interest_included if hasattr(self, "interest_included") else None)!r}, '
                f'debt_description={(self.debt_description if hasattr(self, "debt_description") else None)!r}, '
                f'personally_liable={(self.personally_liable if hasattr(self, "personally_liable") else None)!r}, '
                f'debt_code={(self.debt_code if hasattr(self, "debt_code") else None)!r}, '
                f'fair_market_value={(self.fair_market_value if hasattr(self, "fair_market_value") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!s}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!s}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!s}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!s}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!s}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!s}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!s}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!s}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!s}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!s}, '
                f'error={(self.error if hasattr(self, "error") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!s}, '
                f'date_of_event={(self.date_of_event if hasattr(self, "date_of_event") else None)!s}, '
                f'amount_discharged={(self.amount_discharged if hasattr(self, "amount_discharged") else None)!s}, '
                f'interest_included={(self.interest_included if hasattr(self, "interest_included") else None)!s}, '
                f'debt_description={(self.debt_description if hasattr(self, "debt_description") else None)!s}, '
                f'personally_liable={(self.personally_liable if hasattr(self, "personally_liable") else None)!s}, '
                f'debt_code={(self.debt_code if hasattr(self, "debt_code") else None)!s}, '
                f'fair_market_value={(self.fair_market_value if hasattr(self, "fair_market_value") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
