# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.error_1 import Error1
from fdxapi.models.hateoas_link import HateoasLink
from fdxapi.models.tax_form_attribute import TaxFormAttribute
from fdxapi.models.tax_party_1 import TaxParty1
from fdxapi.models.tax_party_8 import TaxParty8


class Form1099ConsolidatedStatement1(object):

    """Implementation of the 'Form 1099 Consolidated Statement1' model.

    Consolidated Statement for combined IRS Form 1099s

    Attributes:
        tax_year (int): Year for which taxes are being paid
        corrected (bool): True to indicate this is a corrected tax form
        account_id (str): Long-term persistent identity of the source account.
            Not the account number
        tax_form_id (str): Long-term persistent id for this tax form.
            Depending upon the data provider, this may be the same id as the
            enclosing tax statement id, or this may be a different id, or this
            id may be omitted.
        tax_form_date (date): Date of production or delivery of the tax form
        additional_information (str): Additional explanation text or content
            about this tax form
        tax_form_type (TypeFormType1): Enumerated name of the tax form entity
            e.g. "TaxW2"
        issuer (TaxParty8): Issuer's name, address, phone, and TIN. Issuer
            data need only be transmitted on enclosing TaxStatement, if it is
            the same on all its included tax forms.
        recipient (TaxParty1): Recipient's name, address, phone, and TIN.
            Recipient data need only be transmitted on enclosing TaxStatement,
            if it is the same on all its included tax forms.
        attributes (List[TaxFormAttribute]): Additional attributes for this
            tax form when defined fields are not available. Some specific
            additional attributes already defined by providers: Fields
            required by [IRS
            FIRE](https://www.irs.gov/e-file-providers/filing-information-retur
            ns-electronically-fire): Name Control, Type of Identification
            Number (EIN, SSN, ITIN, ATIN). (ATIN is tax ID number for pending
            adoptions.) Tax form provider field for taxpayer notification:
            Recipient Email Address.
        error (Error1): Present if an error was encountered while retrieving
            this form
        links (List[HateoasLink]): Links to retrieve this form as data or
            image, or to invoke other APIs
        margin_interest_paid (float): Interest paid on margin account
        payment_in_lieu_paid (float): Payment in lieu of dividends paid
        advisor_fees_paid (float): Advisor fees paid
        other_fees_paid (float): Other fees paid
        corporate_bond_interest_paid (float): Accrued Interest Paid offset to
            form 1099-INT box 1, Corporate bond interest income
        us_bond_interest_paid (float): Accrued Interest Paid offset to form
            1099-INT box 3, accrued U.S. Treasury Notes and Bonds interest
            income
        tax_exempt_interest_paid (float): Accrued Interest Paid offset to form
            1099-INT box 8, tax exempt interest income from municipal bonds
        specified_pab_interest_paid (float): Accrued Interest Paid offset to
            form 1099-INT box 9, tax exempt interest income from Private
            Activity Bonds
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "tax_year": 'taxYear',
        "corrected": 'corrected',
        "account_id": 'accountId',
        "tax_form_id": 'taxFormId',
        "tax_form_date": 'taxFormDate',
        "additional_information": 'additionalInformation',
        "tax_form_type": 'taxFormType',
        "issuer": 'issuer',
        "recipient": 'recipient',
        "attributes": 'attributes',
        "error": 'error',
        "links": 'links',
        "margin_interest_paid": 'marginInterestPaid',
        "payment_in_lieu_paid": 'paymentInLieuPaid',
        "advisor_fees_paid": 'advisorFeesPaid',
        "other_fees_paid": 'otherFeesPaid',
        "corporate_bond_interest_paid": 'corporateBondInterestPaid',
        "us_bond_interest_paid": 'usBondInterestPaid',
        "tax_exempt_interest_paid": 'taxExemptInterestPaid',
        "specified_pab_interest_paid": 'specifiedPabInterestPaid'
    }

    _optionals = [
        'tax_year',
        'corrected',
        'account_id',
        'tax_form_id',
        'tax_form_date',
        'additional_information',
        'tax_form_type',
        'issuer',
        'recipient',
        'attributes',
        'error',
        'links',
        'margin_interest_paid',
        'payment_in_lieu_paid',
        'advisor_fees_paid',
        'other_fees_paid',
        'corporate_bond_interest_paid',
        'us_bond_interest_paid',
        'tax_exempt_interest_paid',
        'specified_pab_interest_paid',
    ]

    def __init__(self,
                 tax_year=APIHelper.SKIP,
                 corrected=APIHelper.SKIP,
                 account_id=APIHelper.SKIP,
                 tax_form_id=APIHelper.SKIP,
                 tax_form_date=APIHelper.SKIP,
                 additional_information=APIHelper.SKIP,
                 tax_form_type=APIHelper.SKIP,
                 issuer=APIHelper.SKIP,
                 recipient=APIHelper.SKIP,
                 attributes=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 margin_interest_paid=APIHelper.SKIP,
                 payment_in_lieu_paid=APIHelper.SKIP,
                 advisor_fees_paid=APIHelper.SKIP,
                 other_fees_paid=APIHelper.SKIP,
                 corporate_bond_interest_paid=APIHelper.SKIP,
                 us_bond_interest_paid=APIHelper.SKIP,
                 tax_exempt_interest_paid=APIHelper.SKIP,
                 specified_pab_interest_paid=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the Form1099ConsolidatedStatement1 class"""

        # Initialize members of the class
        if tax_year is not APIHelper.SKIP:
            self.tax_year = tax_year 
        if corrected is not APIHelper.SKIP:
            self.corrected = corrected 
        if account_id is not APIHelper.SKIP:
            self.account_id = account_id 
        if tax_form_id is not APIHelper.SKIP:
            self.tax_form_id = tax_form_id 
        if tax_form_date is not APIHelper.SKIP:
            self.tax_form_date = tax_form_date 
        if additional_information is not APIHelper.SKIP:
            self.additional_information = additional_information 
        if tax_form_type is not APIHelper.SKIP:
            self.tax_form_type = tax_form_type 
        if issuer is not APIHelper.SKIP:
            self.issuer = issuer 
        if recipient is not APIHelper.SKIP:
            self.recipient = recipient 
        if attributes is not APIHelper.SKIP:
            self.attributes = attributes 
        if error is not APIHelper.SKIP:
            self.error = error 
        if links is not APIHelper.SKIP:
            self.links = links 
        if margin_interest_paid is not APIHelper.SKIP:
            self.margin_interest_paid = margin_interest_paid 
        if payment_in_lieu_paid is not APIHelper.SKIP:
            self.payment_in_lieu_paid = payment_in_lieu_paid 
        if advisor_fees_paid is not APIHelper.SKIP:
            self.advisor_fees_paid = advisor_fees_paid 
        if other_fees_paid is not APIHelper.SKIP:
            self.other_fees_paid = other_fees_paid 
        if corporate_bond_interest_paid is not APIHelper.SKIP:
            self.corporate_bond_interest_paid = corporate_bond_interest_paid 
        if us_bond_interest_paid is not APIHelper.SKIP:
            self.us_bond_interest_paid = us_bond_interest_paid 
        if tax_exempt_interest_paid is not APIHelper.SKIP:
            self.tax_exempt_interest_paid = tax_exempt_interest_paid 
        if specified_pab_interest_paid is not APIHelper.SKIP:
            self.specified_pab_interest_paid = specified_pab_interest_paid 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        tax_year = dictionary.get("taxYear") if dictionary.get("taxYear") else APIHelper.SKIP
        corrected = dictionary.get("corrected") if "corrected" in dictionary.keys() else APIHelper.SKIP
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        tax_form_id = dictionary.get("taxFormId") if dictionary.get("taxFormId") else APIHelper.SKIP
        tax_form_date = dateutil.parser.parse(dictionary.get('taxFormDate')).date() if dictionary.get('taxFormDate') else APIHelper.SKIP
        additional_information = dictionary.get("additionalInformation") if dictionary.get("additionalInformation") else APIHelper.SKIP
        tax_form_type = dictionary.get("taxFormType") if dictionary.get("taxFormType") else APIHelper.SKIP
        issuer = TaxParty8.from_dictionary(dictionary.get('issuer')) if 'issuer' in dictionary.keys() else APIHelper.SKIP
        recipient = TaxParty1.from_dictionary(dictionary.get('recipient')) if 'recipient' in dictionary.keys() else APIHelper.SKIP
        attributes = None
        if dictionary.get('attributes') is not None:
            attributes = [TaxFormAttribute.from_dictionary(x) for x in dictionary.get('attributes')]
        else:
            attributes = APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        margin_interest_paid = dictionary.get("marginInterestPaid") if dictionary.get("marginInterestPaid") else APIHelper.SKIP
        payment_in_lieu_paid = dictionary.get("paymentInLieuPaid") if dictionary.get("paymentInLieuPaid") else APIHelper.SKIP
        advisor_fees_paid = dictionary.get("advisorFeesPaid") if dictionary.get("advisorFeesPaid") else APIHelper.SKIP
        other_fees_paid = dictionary.get("otherFeesPaid") if dictionary.get("otherFeesPaid") else APIHelper.SKIP
        corporate_bond_interest_paid = dictionary.get("corporateBondInterestPaid") if dictionary.get("corporateBondInterestPaid") else APIHelper.SKIP
        us_bond_interest_paid = dictionary.get("usBondInterestPaid") if dictionary.get("usBondInterestPaid") else APIHelper.SKIP
        tax_exempt_interest_paid = dictionary.get("taxExemptInterestPaid") if dictionary.get("taxExemptInterestPaid") else APIHelper.SKIP
        specified_pab_interest_paid = dictionary.get("specifiedPabInterestPaid") if dictionary.get("specifiedPabInterestPaid") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(tax_year,
                   corrected,
                   account_id,
                   tax_form_id,
                   tax_form_date,
                   additional_information,
                   tax_form_type,
                   issuer,
                   recipient,
                   attributes,
                   error,
                   links,
                   margin_interest_paid,
                   payment_in_lieu_paid,
                   advisor_fees_paid,
                   other_fees_paid,
                   corporate_bond_interest_paid,
                   us_bond_interest_paid,
                   tax_exempt_interest_paid,
                   specified_pab_interest_paid,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!r}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!r}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!r}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!r}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!r}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!r}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!r}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!r}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!r}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!r}, '
                f'error={(self.error if hasattr(self, "error") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'margin_interest_paid={(self.margin_interest_paid if hasattr(self, "margin_interest_paid") else None)!r}, '
                f'payment_in_lieu_paid={(self.payment_in_lieu_paid if hasattr(self, "payment_in_lieu_paid") else None)!r}, '
                f'advisor_fees_paid={(self.advisor_fees_paid if hasattr(self, "advisor_fees_paid") else None)!r}, '
                f'other_fees_paid={(self.other_fees_paid if hasattr(self, "other_fees_paid") else None)!r}, '
                f'corporate_bond_interest_paid={(self.corporate_bond_interest_paid if hasattr(self, "corporate_bond_interest_paid") else None)!r}, '
                f'us_bond_interest_paid={(self.us_bond_interest_paid if hasattr(self, "us_bond_interest_paid") else None)!r}, '
                f'tax_exempt_interest_paid={(self.tax_exempt_interest_paid if hasattr(self, "tax_exempt_interest_paid") else None)!r}, '
                f'specified_pab_interest_paid={(self.specified_pab_interest_paid if hasattr(self, "specified_pab_interest_paid") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!s}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!s}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!s}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!s}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!s}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!s}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!s}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!s}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!s}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!s}, '
                f'error={(self.error if hasattr(self, "error") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'margin_interest_paid={(self.margin_interest_paid if hasattr(self, "margin_interest_paid") else None)!s}, '
                f'payment_in_lieu_paid={(self.payment_in_lieu_paid if hasattr(self, "payment_in_lieu_paid") else None)!s}, '
                f'advisor_fees_paid={(self.advisor_fees_paid if hasattr(self, "advisor_fees_paid") else None)!s}, '
                f'other_fees_paid={(self.other_fees_paid if hasattr(self, "other_fees_paid") else None)!s}, '
                f'corporate_bond_interest_paid={(self.corporate_bond_interest_paid if hasattr(self, "corporate_bond_interest_paid") else None)!s}, '
                f'us_bond_interest_paid={(self.us_bond_interest_paid if hasattr(self, "us_bond_interest_paid") else None)!s}, '
                f'tax_exempt_interest_paid={(self.tax_exempt_interest_paid if hasattr(self, "tax_exempt_interest_paid") else None)!s}, '
                f'specified_pab_interest_paid={(self.specified_pab_interest_paid if hasattr(self, "specified_pab_interest_paid") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
