# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.description_and_amount import DescriptionAndAmount
from fdxapi.models.error_1 import Error1
from fdxapi.models.hateoas_link import HateoasLink
from fdxapi.models.state_and_local_tax_withholding import StateAndLocalTaxWithholding
from fdxapi.models.tax_form_attribute import TaxFormAttribute
from fdxapi.models.tax_party_1 import TaxParty1
from fdxapi.models.tax_party_8 import TaxParty8


class Form1099Div(object):

    """Implementation of the 'Form 1099-DIV' model.

    Dividends and Distributions, from PAYER (1st-2nd boxes as issuer) to
    RECIPIENT (3rd-6th boxes)

    Attributes:
        tax_year (int): Year for which taxes are being paid
        corrected (bool): True to indicate this is a corrected tax form
        account_id (str): Long-term persistent identity of the source account.
            Not the account number
        tax_form_id (str): Long-term persistent id for this tax form.
            Depending upon the data provider, this may be the same id as the
            enclosing tax statement id, or this may be a different id, or this
            id may be omitted.
        tax_form_date (date): Date of production or delivery of the tax form
        additional_information (str): Additional explanation text or content
            about this tax form
        tax_form_type (TypeFormType1): Enumerated name of the tax form entity
            e.g. "TaxW2"
        issuer (TaxParty8): Issuer's name, address, phone, and TIN. Issuer
            data need only be transmitted on enclosing TaxStatement, if it is
            the same on all its included tax forms.
        recipient (TaxParty1): Recipient's name, address, phone, and TIN.
            Recipient data need only be transmitted on enclosing TaxStatement,
            if it is the same on all its included tax forms.
        attributes (List[TaxFormAttribute]): Additional attributes for this
            tax form when defined fields are not available. Some specific
            additional attributes already defined by providers: Fields
            required by [IRS
            FIRE](https://www.irs.gov/e-file-providers/filing-information-retur
            ns-electronically-fire): Name Control, Type of Identification
            Number (EIN, SSN, ITIN, ATIN). (ATIN is tax ID number for pending
            adoptions.) Tax form provider field for taxpayer notification:
            Recipient Email Address.
        error (Error1): Present if an error was encountered while retrieving
            this form
        links (List[HateoasLink]): Links to retrieve this form as data or
            image, or to invoke other APIs
        account_number (str): Account number
        ordinary_dividends (float): Box 1a, Total ordinary dividends
        qualified_dividends (float): Box 1b, Qualified dividends
        total_capital_gain (float): Box 2a, Total capital gain distributions
        unrecaptured_1250_gain (float): Box 2b, Unrecaptured Section 1250 gain
        section_1202_gain (float): Box 2c, Section 1202 gain
        collectibles_gain (float): Box 2d, Collectibles (28%) gain
        section_897_dividends (float): Box 2e, Section 897 ordinary dividends
        section_897_capital_gain (float): Box 2f, Section 897 capital gain
        non_taxable_distribution (float): Box 3, Nondividend distributions
        federal_tax_withheld (float): Box 4, Federal income tax withheld
        section_199_a_dividends (float): Box 5, Section 199A dividends
        investment_expenses (float): Box 6, Investment expenses
        foreign_tax_paid (float): Box 7, Foreign tax paid
        foreign_country (str): Box 8, Foreign country or U.S. possession
        cash_liquidation (float): Box 9, Cash liquidation distributions
        non_cash_liquidation (float): Box 10, Noncash liquidation distributions
        foreign_account_tax_compliance (bool): Box 11, FATCA filing requirement
        tax_exempt_interest_dividend (float): Box 12, Exempt-interest dividends
        specified_pab_interest_dividend (float): Box 13, Specified private
            activity bond interest dividends
        state_and_local (List[StateAndLocalTaxWithholding]): Boxes 14-16,
            State and Local tax withholding
        foreign_incomes (List[DescriptionAndAmount]): Foreign income
            information
        state_tax_exempt_incomes (List[DescriptionAndAmount]): Tax exempt
            income state information
        second_tin_notice (bool): Second TIN Notice
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "tax_year": 'taxYear',
        "corrected": 'corrected',
        "account_id": 'accountId',
        "tax_form_id": 'taxFormId',
        "tax_form_date": 'taxFormDate',
        "additional_information": 'additionalInformation',
        "tax_form_type": 'taxFormType',
        "issuer": 'issuer',
        "recipient": 'recipient',
        "attributes": 'attributes',
        "error": 'error',
        "links": 'links',
        "account_number": 'accountNumber',
        "ordinary_dividends": 'ordinaryDividends',
        "qualified_dividends": 'qualifiedDividends',
        "total_capital_gain": 'totalCapitalGain',
        "unrecaptured_1250_gain": 'unrecaptured1250Gain',
        "section_1202_gain": 'section1202Gain',
        "collectibles_gain": 'collectiblesGain',
        "section_897_dividends": 'section897Dividends',
        "section_897_capital_gain": 'section897CapitalGain',
        "non_taxable_distribution": 'nonTaxableDistribution',
        "federal_tax_withheld": 'federalTaxWithheld',
        "section_199_a_dividends": 'section199ADividends',
        "investment_expenses": 'investmentExpenses',
        "foreign_tax_paid": 'foreignTaxPaid',
        "foreign_country": 'foreignCountry',
        "cash_liquidation": 'cashLiquidation',
        "non_cash_liquidation": 'nonCashLiquidation',
        "foreign_account_tax_compliance": 'foreignAccountTaxCompliance',
        "tax_exempt_interest_dividend": 'taxExemptInterestDividend',
        "specified_pab_interest_dividend": 'specifiedPabInterestDividend',
        "state_and_local": 'stateAndLocal',
        "foreign_incomes": 'foreignIncomes',
        "state_tax_exempt_incomes": 'stateTaxExemptIncomes',
        "second_tin_notice": 'secondTinNotice'
    }

    _optionals = [
        'tax_year',
        'corrected',
        'account_id',
        'tax_form_id',
        'tax_form_date',
        'additional_information',
        'tax_form_type',
        'issuer',
        'recipient',
        'attributes',
        'error',
        'links',
        'account_number',
        'ordinary_dividends',
        'qualified_dividends',
        'total_capital_gain',
        'unrecaptured_1250_gain',
        'section_1202_gain',
        'collectibles_gain',
        'section_897_dividends',
        'section_897_capital_gain',
        'non_taxable_distribution',
        'federal_tax_withheld',
        'section_199_a_dividends',
        'investment_expenses',
        'foreign_tax_paid',
        'foreign_country',
        'cash_liquidation',
        'non_cash_liquidation',
        'foreign_account_tax_compliance',
        'tax_exempt_interest_dividend',
        'specified_pab_interest_dividend',
        'state_and_local',
        'foreign_incomes',
        'state_tax_exempt_incomes',
        'second_tin_notice',
    ]

    def __init__(self,
                 tax_year=APIHelper.SKIP,
                 corrected=APIHelper.SKIP,
                 account_id=APIHelper.SKIP,
                 tax_form_id=APIHelper.SKIP,
                 tax_form_date=APIHelper.SKIP,
                 additional_information=APIHelper.SKIP,
                 tax_form_type=APIHelper.SKIP,
                 issuer=APIHelper.SKIP,
                 recipient=APIHelper.SKIP,
                 attributes=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 account_number=APIHelper.SKIP,
                 ordinary_dividends=APIHelper.SKIP,
                 qualified_dividends=APIHelper.SKIP,
                 total_capital_gain=APIHelper.SKIP,
                 unrecaptured_1250_gain=APIHelper.SKIP,
                 section_1202_gain=APIHelper.SKIP,
                 collectibles_gain=APIHelper.SKIP,
                 section_897_dividends=APIHelper.SKIP,
                 section_897_capital_gain=APIHelper.SKIP,
                 non_taxable_distribution=APIHelper.SKIP,
                 federal_tax_withheld=APIHelper.SKIP,
                 section_199_a_dividends=APIHelper.SKIP,
                 investment_expenses=APIHelper.SKIP,
                 foreign_tax_paid=APIHelper.SKIP,
                 foreign_country=APIHelper.SKIP,
                 cash_liquidation=APIHelper.SKIP,
                 non_cash_liquidation=APIHelper.SKIP,
                 foreign_account_tax_compliance=APIHelper.SKIP,
                 tax_exempt_interest_dividend=APIHelper.SKIP,
                 specified_pab_interest_dividend=APIHelper.SKIP,
                 state_and_local=APIHelper.SKIP,
                 foreign_incomes=APIHelper.SKIP,
                 state_tax_exempt_incomes=APIHelper.SKIP,
                 second_tin_notice=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the Form1099Div class"""

        # Initialize members of the class
        if tax_year is not APIHelper.SKIP:
            self.tax_year = tax_year 
        if corrected is not APIHelper.SKIP:
            self.corrected = corrected 
        if account_id is not APIHelper.SKIP:
            self.account_id = account_id 
        if tax_form_id is not APIHelper.SKIP:
            self.tax_form_id = tax_form_id 
        if tax_form_date is not APIHelper.SKIP:
            self.tax_form_date = tax_form_date 
        if additional_information is not APIHelper.SKIP:
            self.additional_information = additional_information 
        if tax_form_type is not APIHelper.SKIP:
            self.tax_form_type = tax_form_type 
        if issuer is not APIHelper.SKIP:
            self.issuer = issuer 
        if recipient is not APIHelper.SKIP:
            self.recipient = recipient 
        if attributes is not APIHelper.SKIP:
            self.attributes = attributes 
        if error is not APIHelper.SKIP:
            self.error = error 
        if links is not APIHelper.SKIP:
            self.links = links 
        if account_number is not APIHelper.SKIP:
            self.account_number = account_number 
        if ordinary_dividends is not APIHelper.SKIP:
            self.ordinary_dividends = ordinary_dividends 
        if qualified_dividends is not APIHelper.SKIP:
            self.qualified_dividends = qualified_dividends 
        if total_capital_gain is not APIHelper.SKIP:
            self.total_capital_gain = total_capital_gain 
        if unrecaptured_1250_gain is not APIHelper.SKIP:
            self.unrecaptured_1250_gain = unrecaptured_1250_gain 
        if section_1202_gain is not APIHelper.SKIP:
            self.section_1202_gain = section_1202_gain 
        if collectibles_gain is not APIHelper.SKIP:
            self.collectibles_gain = collectibles_gain 
        if section_897_dividends is not APIHelper.SKIP:
            self.section_897_dividends = section_897_dividends 
        if section_897_capital_gain is not APIHelper.SKIP:
            self.section_897_capital_gain = section_897_capital_gain 
        if non_taxable_distribution is not APIHelper.SKIP:
            self.non_taxable_distribution = non_taxable_distribution 
        if federal_tax_withheld is not APIHelper.SKIP:
            self.federal_tax_withheld = federal_tax_withheld 
        if section_199_a_dividends is not APIHelper.SKIP:
            self.section_199_a_dividends = section_199_a_dividends 
        if investment_expenses is not APIHelper.SKIP:
            self.investment_expenses = investment_expenses 
        if foreign_tax_paid is not APIHelper.SKIP:
            self.foreign_tax_paid = foreign_tax_paid 
        if foreign_country is not APIHelper.SKIP:
            self.foreign_country = foreign_country 
        if cash_liquidation is not APIHelper.SKIP:
            self.cash_liquidation = cash_liquidation 
        if non_cash_liquidation is not APIHelper.SKIP:
            self.non_cash_liquidation = non_cash_liquidation 
        if foreign_account_tax_compliance is not APIHelper.SKIP:
            self.foreign_account_tax_compliance = foreign_account_tax_compliance 
        if tax_exempt_interest_dividend is not APIHelper.SKIP:
            self.tax_exempt_interest_dividend = tax_exempt_interest_dividend 
        if specified_pab_interest_dividend is not APIHelper.SKIP:
            self.specified_pab_interest_dividend = specified_pab_interest_dividend 
        if state_and_local is not APIHelper.SKIP:
            self.state_and_local = state_and_local 
        if foreign_incomes is not APIHelper.SKIP:
            self.foreign_incomes = foreign_incomes 
        if state_tax_exempt_incomes is not APIHelper.SKIP:
            self.state_tax_exempt_incomes = state_tax_exempt_incomes 
        if second_tin_notice is not APIHelper.SKIP:
            self.second_tin_notice = second_tin_notice 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        tax_year = dictionary.get("taxYear") if dictionary.get("taxYear") else APIHelper.SKIP
        corrected = dictionary.get("corrected") if "corrected" in dictionary.keys() else APIHelper.SKIP
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        tax_form_id = dictionary.get("taxFormId") if dictionary.get("taxFormId") else APIHelper.SKIP
        tax_form_date = dateutil.parser.parse(dictionary.get('taxFormDate')).date() if dictionary.get('taxFormDate') else APIHelper.SKIP
        additional_information = dictionary.get("additionalInformation") if dictionary.get("additionalInformation") else APIHelper.SKIP
        tax_form_type = dictionary.get("taxFormType") if dictionary.get("taxFormType") else APIHelper.SKIP
        issuer = TaxParty8.from_dictionary(dictionary.get('issuer')) if 'issuer' in dictionary.keys() else APIHelper.SKIP
        recipient = TaxParty1.from_dictionary(dictionary.get('recipient')) if 'recipient' in dictionary.keys() else APIHelper.SKIP
        attributes = None
        if dictionary.get('attributes') is not None:
            attributes = [TaxFormAttribute.from_dictionary(x) for x in dictionary.get('attributes')]
        else:
            attributes = APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        account_number = dictionary.get("accountNumber") if dictionary.get("accountNumber") else APIHelper.SKIP
        ordinary_dividends = dictionary.get("ordinaryDividends") if dictionary.get("ordinaryDividends") else APIHelper.SKIP
        qualified_dividends = dictionary.get("qualifiedDividends") if dictionary.get("qualifiedDividends") else APIHelper.SKIP
        total_capital_gain = dictionary.get("totalCapitalGain") if dictionary.get("totalCapitalGain") else APIHelper.SKIP
        unrecaptured_1250_gain = dictionary.get("unrecaptured1250Gain") if dictionary.get("unrecaptured1250Gain") else APIHelper.SKIP
        section_1202_gain = dictionary.get("section1202Gain") if dictionary.get("section1202Gain") else APIHelper.SKIP
        collectibles_gain = dictionary.get("collectiblesGain") if dictionary.get("collectiblesGain") else APIHelper.SKIP
        section_897_dividends = dictionary.get("section897Dividends") if dictionary.get("section897Dividends") else APIHelper.SKIP
        section_897_capital_gain = dictionary.get("section897CapitalGain") if dictionary.get("section897CapitalGain") else APIHelper.SKIP
        non_taxable_distribution = dictionary.get("nonTaxableDistribution") if dictionary.get("nonTaxableDistribution") else APIHelper.SKIP
        federal_tax_withheld = dictionary.get("federalTaxWithheld") if dictionary.get("federalTaxWithheld") else APIHelper.SKIP
        section_199_a_dividends = dictionary.get("section199ADividends") if dictionary.get("section199ADividends") else APIHelper.SKIP
        investment_expenses = dictionary.get("investmentExpenses") if dictionary.get("investmentExpenses") else APIHelper.SKIP
        foreign_tax_paid = dictionary.get("foreignTaxPaid") if dictionary.get("foreignTaxPaid") else APIHelper.SKIP
        foreign_country = dictionary.get("foreignCountry") if dictionary.get("foreignCountry") else APIHelper.SKIP
        cash_liquidation = dictionary.get("cashLiquidation") if dictionary.get("cashLiquidation") else APIHelper.SKIP
        non_cash_liquidation = dictionary.get("nonCashLiquidation") if dictionary.get("nonCashLiquidation") else APIHelper.SKIP
        foreign_account_tax_compliance = dictionary.get("foreignAccountTaxCompliance") if "foreignAccountTaxCompliance" in dictionary.keys() else APIHelper.SKIP
        tax_exempt_interest_dividend = dictionary.get("taxExemptInterestDividend") if dictionary.get("taxExemptInterestDividend") else APIHelper.SKIP
        specified_pab_interest_dividend = dictionary.get("specifiedPabInterestDividend") if dictionary.get("specifiedPabInterestDividend") else APIHelper.SKIP
        state_and_local = None
        if dictionary.get('stateAndLocal') is not None:
            state_and_local = [StateAndLocalTaxWithholding.from_dictionary(x) for x in dictionary.get('stateAndLocal')]
        else:
            state_and_local = APIHelper.SKIP
        foreign_incomes = None
        if dictionary.get('foreignIncomes') is not None:
            foreign_incomes = [DescriptionAndAmount.from_dictionary(x) for x in dictionary.get('foreignIncomes')]
        else:
            foreign_incomes = APIHelper.SKIP
        state_tax_exempt_incomes = None
        if dictionary.get('stateTaxExemptIncomes') is not None:
            state_tax_exempt_incomes = [DescriptionAndAmount.from_dictionary(x) for x in dictionary.get('stateTaxExemptIncomes')]
        else:
            state_tax_exempt_incomes = APIHelper.SKIP
        second_tin_notice = dictionary.get("secondTinNotice") if "secondTinNotice" in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(tax_year,
                   corrected,
                   account_id,
                   tax_form_id,
                   tax_form_date,
                   additional_information,
                   tax_form_type,
                   issuer,
                   recipient,
                   attributes,
                   error,
                   links,
                   account_number,
                   ordinary_dividends,
                   qualified_dividends,
                   total_capital_gain,
                   unrecaptured_1250_gain,
                   section_1202_gain,
                   collectibles_gain,
                   section_897_dividends,
                   section_897_capital_gain,
                   non_taxable_distribution,
                   federal_tax_withheld,
                   section_199_a_dividends,
                   investment_expenses,
                   foreign_tax_paid,
                   foreign_country,
                   cash_liquidation,
                   non_cash_liquidation,
                   foreign_account_tax_compliance,
                   tax_exempt_interest_dividend,
                   specified_pab_interest_dividend,
                   state_and_local,
                   foreign_incomes,
                   state_tax_exempt_incomes,
                   second_tin_notice,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!r}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!r}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!r}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!r}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!r}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!r}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!r}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!r}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!r}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!r}, '
                f'error={(self.error if hasattr(self, "error") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!r}, '
                f'ordinary_dividends={(self.ordinary_dividends if hasattr(self, "ordinary_dividends") else None)!r}, '
                f'qualified_dividends={(self.qualified_dividends if hasattr(self, "qualified_dividends") else None)!r}, '
                f'total_capital_gain={(self.total_capital_gain if hasattr(self, "total_capital_gain") else None)!r}, '
                f'unrecaptured_1250_gain={(self.unrecaptured_1250_gain if hasattr(self, "unrecaptured_1250_gain") else None)!r}, '
                f'section_1202_gain={(self.section_1202_gain if hasattr(self, "section_1202_gain") else None)!r}, '
                f'collectibles_gain={(self.collectibles_gain if hasattr(self, "collectibles_gain") else None)!r}, '
                f'section_897_dividends={(self.section_897_dividends if hasattr(self, "section_897_dividends") else None)!r}, '
                f'section_897_capital_gain={(self.section_897_capital_gain if hasattr(self, "section_897_capital_gain") else None)!r}, '
                f'non_taxable_distribution={(self.non_taxable_distribution if hasattr(self, "non_taxable_distribution") else None)!r}, '
                f'federal_tax_withheld={(self.federal_tax_withheld if hasattr(self, "federal_tax_withheld") else None)!r}, '
                f'section_199_a_dividends={(self.section_199_a_dividends if hasattr(self, "section_199_a_dividends") else None)!r}, '
                f'investment_expenses={(self.investment_expenses if hasattr(self, "investment_expenses") else None)!r}, '
                f'foreign_tax_paid={(self.foreign_tax_paid if hasattr(self, "foreign_tax_paid") else None)!r}, '
                f'foreign_country={(self.foreign_country if hasattr(self, "foreign_country") else None)!r}, '
                f'cash_liquidation={(self.cash_liquidation if hasattr(self, "cash_liquidation") else None)!r}, '
                f'non_cash_liquidation={(self.non_cash_liquidation if hasattr(self, "non_cash_liquidation") else None)!r}, '
                f'foreign_account_tax_compliance={(self.foreign_account_tax_compliance if hasattr(self, "foreign_account_tax_compliance") else None)!r}, '
                f'tax_exempt_interest_dividend={(self.tax_exempt_interest_dividend if hasattr(self, "tax_exempt_interest_dividend") else None)!r}, '
                f'specified_pab_interest_dividend={(self.specified_pab_interest_dividend if hasattr(self, "specified_pab_interest_dividend") else None)!r}, '
                f'state_and_local={(self.state_and_local if hasattr(self, "state_and_local") else None)!r}, '
                f'foreign_incomes={(self.foreign_incomes if hasattr(self, "foreign_incomes") else None)!r}, '
                f'state_tax_exempt_incomes={(self.state_tax_exempt_incomes if hasattr(self, "state_tax_exempt_incomes") else None)!r}, '
                f'second_tin_notice={(self.second_tin_notice if hasattr(self, "second_tin_notice") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!s}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!s}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!s}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!s}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!s}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!s}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!s}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!s}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!s}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!s}, '
                f'error={(self.error if hasattr(self, "error") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!s}, '
                f'ordinary_dividends={(self.ordinary_dividends if hasattr(self, "ordinary_dividends") else None)!s}, '
                f'qualified_dividends={(self.qualified_dividends if hasattr(self, "qualified_dividends") else None)!s}, '
                f'total_capital_gain={(self.total_capital_gain if hasattr(self, "total_capital_gain") else None)!s}, '
                f'unrecaptured_1250_gain={(self.unrecaptured_1250_gain if hasattr(self, "unrecaptured_1250_gain") else None)!s}, '
                f'section_1202_gain={(self.section_1202_gain if hasattr(self, "section_1202_gain") else None)!s}, '
                f'collectibles_gain={(self.collectibles_gain if hasattr(self, "collectibles_gain") else None)!s}, '
                f'section_897_dividends={(self.section_897_dividends if hasattr(self, "section_897_dividends") else None)!s}, '
                f'section_897_capital_gain={(self.section_897_capital_gain if hasattr(self, "section_897_capital_gain") else None)!s}, '
                f'non_taxable_distribution={(self.non_taxable_distribution if hasattr(self, "non_taxable_distribution") else None)!s}, '
                f'federal_tax_withheld={(self.federal_tax_withheld if hasattr(self, "federal_tax_withheld") else None)!s}, '
                f'section_199_a_dividends={(self.section_199_a_dividends if hasattr(self, "section_199_a_dividends") else None)!s}, '
                f'investment_expenses={(self.investment_expenses if hasattr(self, "investment_expenses") else None)!s}, '
                f'foreign_tax_paid={(self.foreign_tax_paid if hasattr(self, "foreign_tax_paid") else None)!s}, '
                f'foreign_country={(self.foreign_country if hasattr(self, "foreign_country") else None)!s}, '
                f'cash_liquidation={(self.cash_liquidation if hasattr(self, "cash_liquidation") else None)!s}, '
                f'non_cash_liquidation={(self.non_cash_liquidation if hasattr(self, "non_cash_liquidation") else None)!s}, '
                f'foreign_account_tax_compliance={(self.foreign_account_tax_compliance if hasattr(self, "foreign_account_tax_compliance") else None)!s}, '
                f'tax_exempt_interest_dividend={(self.tax_exempt_interest_dividend if hasattr(self, "tax_exempt_interest_dividend") else None)!s}, '
                f'specified_pab_interest_dividend={(self.specified_pab_interest_dividend if hasattr(self, "specified_pab_interest_dividend") else None)!s}, '
                f'state_and_local={(self.state_and_local if hasattr(self, "state_and_local") else None)!s}, '
                f'foreign_incomes={(self.foreign_incomes if hasattr(self, "foreign_incomes") else None)!s}, '
                f'state_tax_exempt_incomes={(self.state_tax_exempt_incomes if hasattr(self, "state_tax_exempt_incomes") else None)!s}, '
                f'second_tin_notice={(self.second_tin_notice if hasattr(self, "second_tin_notice") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
