# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.description_and_amount import DescriptionAndAmount
from fdxapi.models.error_1 import Error1
from fdxapi.models.hateoas_link import HateoasLink
from fdxapi.models.state_and_local_tax_withholding import StateAndLocalTaxWithholding
from fdxapi.models.tax_form_attribute import TaxFormAttribute
from fdxapi.models.tax_party_1 import TaxParty1
from fdxapi.models.tax_party_8 import TaxParty8


class Form1099Int1(object):

    """Implementation of the 'Form 1099-INT1' model.

    Interest Income

    Attributes:
        tax_year (int): Year for which taxes are being paid
        corrected (bool): True to indicate this is a corrected tax form
        account_id (str): Long-term persistent identity of the source account.
            Not the account number
        tax_form_id (str): Long-term persistent id for this tax form.
            Depending upon the data provider, this may be the same id as the
            enclosing tax statement id, or this may be a different id, or this
            id may be omitted.
        tax_form_date (date): Date of production or delivery of the tax form
        additional_information (str): Additional explanation text or content
            about this tax form
        tax_form_type (TypeFormType1): Enumerated name of the tax form entity
            e.g. "TaxW2"
        issuer (TaxParty8): Issuer's name, address, phone, and TIN. Issuer
            data need only be transmitted on enclosing TaxStatement, if it is
            the same on all its included tax forms.
        recipient (TaxParty1): Recipient's name, address, phone, and TIN.
            Recipient data need only be transmitted on enclosing TaxStatement,
            if it is the same on all its included tax forms.
        attributes (List[TaxFormAttribute]): Additional attributes for this
            tax form when defined fields are not available. Some specific
            additional attributes already defined by providers: Fields
            required by [IRS
            FIRE](https://www.irs.gov/e-file-providers/filing-information-retur
            ns-electronically-fire): Name Control, Type of Identification
            Number (EIN, SSN, ITIN, ATIN). (ATIN is tax ID number for pending
            adoptions.) Tax form provider field for taxpayer notification:
            Recipient Email Address.
        error (Error1): Present if an error was encountered while retrieving
            this form
        links (List[HateoasLink]): Links to retrieve this form as data or
            image, or to invoke other APIs
        foreign_account_tax_compliance (bool): FATCA filing requirement
        account_number (str): Account number
        payer_rtn (str): Payer's RTN
        interest_income (float): Box 1, Interest income
        early_withdrawal_penalty (float): Box 2, Early withdrawal penalty
        us_bond_interest (float): Box 3, Interest on U.S. Savings Bonds and
            Treasury obligations
        federal_tax_withheld (float): Box 4, Federal income tax withheld
        investment_expenses (float): Box 5, Investment expenses
        foreign_tax_paid (float): Box 6, Foreign tax paid
        foreign_country (str): Box 7, Foreign country or U.S. possession
        tax_exempt_interest (float): Box 8, Tax-exempt interest
        specified_pab_interest (float): Box 9, Specified private activity bond
            interest
        market_discount (float): Box 10, Market discount
        bond_premium (float): Box 11, Bond premium
        us_bond_premium (float): Box 12, Bond premium on Treasury obligations
        tax_exempt_bond_premium (float): Box 13, Bond premium on tax-exempt
            bond
        cusip_number (str): Box 14, Tax-exempt bond CUSIP no.
        state_and_local (List[StateAndLocalTaxWithholding]): Boxes 15-17,
            State and Local tax withholding
        foreign_incomes (List[DescriptionAndAmount]): Supplemental foreign
            income amount information (description is country)
        state_tax_exempt_income (List[DescriptionAndAmount]): Supplemental
            tax-exempt income by state (description is state)
        second_tin_notice (bool): Second TIN Notice
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "tax_year": 'taxYear',
        "corrected": 'corrected',
        "account_id": 'accountId',
        "tax_form_id": 'taxFormId',
        "tax_form_date": 'taxFormDate',
        "additional_information": 'additionalInformation',
        "tax_form_type": 'taxFormType',
        "issuer": 'issuer',
        "recipient": 'recipient',
        "attributes": 'attributes',
        "error": 'error',
        "links": 'links',
        "foreign_account_tax_compliance": 'foreignAccountTaxCompliance',
        "account_number": 'accountNumber',
        "payer_rtn": 'payerRtn',
        "interest_income": 'interestIncome',
        "early_withdrawal_penalty": 'earlyWithdrawalPenalty',
        "us_bond_interest": 'usBondInterest',
        "federal_tax_withheld": 'federalTaxWithheld',
        "investment_expenses": 'investmentExpenses',
        "foreign_tax_paid": 'foreignTaxPaid',
        "foreign_country": 'foreignCountry',
        "tax_exempt_interest": 'taxExemptInterest',
        "specified_pab_interest": 'specifiedPabInterest',
        "market_discount": 'marketDiscount',
        "bond_premium": 'bondPremium',
        "us_bond_premium": 'usBondPremium',
        "tax_exempt_bond_premium": 'taxExemptBondPremium',
        "cusip_number": 'cusipNumber',
        "state_and_local": 'stateAndLocal',
        "foreign_incomes": 'foreignIncomes',
        "state_tax_exempt_income": 'stateTaxExemptIncome',
        "second_tin_notice": 'secondTinNotice'
    }

    _optionals = [
        'tax_year',
        'corrected',
        'account_id',
        'tax_form_id',
        'tax_form_date',
        'additional_information',
        'tax_form_type',
        'issuer',
        'recipient',
        'attributes',
        'error',
        'links',
        'foreign_account_tax_compliance',
        'account_number',
        'payer_rtn',
        'interest_income',
        'early_withdrawal_penalty',
        'us_bond_interest',
        'federal_tax_withheld',
        'investment_expenses',
        'foreign_tax_paid',
        'foreign_country',
        'tax_exempt_interest',
        'specified_pab_interest',
        'market_discount',
        'bond_premium',
        'us_bond_premium',
        'tax_exempt_bond_premium',
        'cusip_number',
        'state_and_local',
        'foreign_incomes',
        'state_tax_exempt_income',
        'second_tin_notice',
    ]

    def __init__(self,
                 tax_year=APIHelper.SKIP,
                 corrected=APIHelper.SKIP,
                 account_id=APIHelper.SKIP,
                 tax_form_id=APIHelper.SKIP,
                 tax_form_date=APIHelper.SKIP,
                 additional_information=APIHelper.SKIP,
                 tax_form_type=APIHelper.SKIP,
                 issuer=APIHelper.SKIP,
                 recipient=APIHelper.SKIP,
                 attributes=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 foreign_account_tax_compliance=APIHelper.SKIP,
                 account_number=APIHelper.SKIP,
                 payer_rtn=APIHelper.SKIP,
                 interest_income=APIHelper.SKIP,
                 early_withdrawal_penalty=APIHelper.SKIP,
                 us_bond_interest=APIHelper.SKIP,
                 federal_tax_withheld=APIHelper.SKIP,
                 investment_expenses=APIHelper.SKIP,
                 foreign_tax_paid=APIHelper.SKIP,
                 foreign_country=APIHelper.SKIP,
                 tax_exempt_interest=APIHelper.SKIP,
                 specified_pab_interest=APIHelper.SKIP,
                 market_discount=APIHelper.SKIP,
                 bond_premium=APIHelper.SKIP,
                 us_bond_premium=APIHelper.SKIP,
                 tax_exempt_bond_premium=APIHelper.SKIP,
                 cusip_number=APIHelper.SKIP,
                 state_and_local=APIHelper.SKIP,
                 foreign_incomes=APIHelper.SKIP,
                 state_tax_exempt_income=APIHelper.SKIP,
                 second_tin_notice=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the Form1099Int1 class"""

        # Initialize members of the class
        if tax_year is not APIHelper.SKIP:
            self.tax_year = tax_year 
        if corrected is not APIHelper.SKIP:
            self.corrected = corrected 
        if account_id is not APIHelper.SKIP:
            self.account_id = account_id 
        if tax_form_id is not APIHelper.SKIP:
            self.tax_form_id = tax_form_id 
        if tax_form_date is not APIHelper.SKIP:
            self.tax_form_date = tax_form_date 
        if additional_information is not APIHelper.SKIP:
            self.additional_information = additional_information 
        if tax_form_type is not APIHelper.SKIP:
            self.tax_form_type = tax_form_type 
        if issuer is not APIHelper.SKIP:
            self.issuer = issuer 
        if recipient is not APIHelper.SKIP:
            self.recipient = recipient 
        if attributes is not APIHelper.SKIP:
            self.attributes = attributes 
        if error is not APIHelper.SKIP:
            self.error = error 
        if links is not APIHelper.SKIP:
            self.links = links 
        if foreign_account_tax_compliance is not APIHelper.SKIP:
            self.foreign_account_tax_compliance = foreign_account_tax_compliance 
        if account_number is not APIHelper.SKIP:
            self.account_number = account_number 
        if payer_rtn is not APIHelper.SKIP:
            self.payer_rtn = payer_rtn 
        if interest_income is not APIHelper.SKIP:
            self.interest_income = interest_income 
        if early_withdrawal_penalty is not APIHelper.SKIP:
            self.early_withdrawal_penalty = early_withdrawal_penalty 
        if us_bond_interest is not APIHelper.SKIP:
            self.us_bond_interest = us_bond_interest 
        if federal_tax_withheld is not APIHelper.SKIP:
            self.federal_tax_withheld = federal_tax_withheld 
        if investment_expenses is not APIHelper.SKIP:
            self.investment_expenses = investment_expenses 
        if foreign_tax_paid is not APIHelper.SKIP:
            self.foreign_tax_paid = foreign_tax_paid 
        if foreign_country is not APIHelper.SKIP:
            self.foreign_country = foreign_country 
        if tax_exempt_interest is not APIHelper.SKIP:
            self.tax_exempt_interest = tax_exempt_interest 
        if specified_pab_interest is not APIHelper.SKIP:
            self.specified_pab_interest = specified_pab_interest 
        if market_discount is not APIHelper.SKIP:
            self.market_discount = market_discount 
        if bond_premium is not APIHelper.SKIP:
            self.bond_premium = bond_premium 
        if us_bond_premium is not APIHelper.SKIP:
            self.us_bond_premium = us_bond_premium 
        if tax_exempt_bond_premium is not APIHelper.SKIP:
            self.tax_exempt_bond_premium = tax_exempt_bond_premium 
        if cusip_number is not APIHelper.SKIP:
            self.cusip_number = cusip_number 
        if state_and_local is not APIHelper.SKIP:
            self.state_and_local = state_and_local 
        if foreign_incomes is not APIHelper.SKIP:
            self.foreign_incomes = foreign_incomes 
        if state_tax_exempt_income is not APIHelper.SKIP:
            self.state_tax_exempt_income = state_tax_exempt_income 
        if second_tin_notice is not APIHelper.SKIP:
            self.second_tin_notice = second_tin_notice 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        tax_year = dictionary.get("taxYear") if dictionary.get("taxYear") else APIHelper.SKIP
        corrected = dictionary.get("corrected") if "corrected" in dictionary.keys() else APIHelper.SKIP
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        tax_form_id = dictionary.get("taxFormId") if dictionary.get("taxFormId") else APIHelper.SKIP
        tax_form_date = dateutil.parser.parse(dictionary.get('taxFormDate')).date() if dictionary.get('taxFormDate') else APIHelper.SKIP
        additional_information = dictionary.get("additionalInformation") if dictionary.get("additionalInformation") else APIHelper.SKIP
        tax_form_type = dictionary.get("taxFormType") if dictionary.get("taxFormType") else APIHelper.SKIP
        issuer = TaxParty8.from_dictionary(dictionary.get('issuer')) if 'issuer' in dictionary.keys() else APIHelper.SKIP
        recipient = TaxParty1.from_dictionary(dictionary.get('recipient')) if 'recipient' in dictionary.keys() else APIHelper.SKIP
        attributes = None
        if dictionary.get('attributes') is not None:
            attributes = [TaxFormAttribute.from_dictionary(x) for x in dictionary.get('attributes')]
        else:
            attributes = APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        foreign_account_tax_compliance = dictionary.get("foreignAccountTaxCompliance") if "foreignAccountTaxCompliance" in dictionary.keys() else APIHelper.SKIP
        account_number = dictionary.get("accountNumber") if dictionary.get("accountNumber") else APIHelper.SKIP
        payer_rtn = dictionary.get("payerRtn") if dictionary.get("payerRtn") else APIHelper.SKIP
        interest_income = dictionary.get("interestIncome") if dictionary.get("interestIncome") else APIHelper.SKIP
        early_withdrawal_penalty = dictionary.get("earlyWithdrawalPenalty") if dictionary.get("earlyWithdrawalPenalty") else APIHelper.SKIP
        us_bond_interest = dictionary.get("usBondInterest") if dictionary.get("usBondInterest") else APIHelper.SKIP
        federal_tax_withheld = dictionary.get("federalTaxWithheld") if dictionary.get("federalTaxWithheld") else APIHelper.SKIP
        investment_expenses = dictionary.get("investmentExpenses") if dictionary.get("investmentExpenses") else APIHelper.SKIP
        foreign_tax_paid = dictionary.get("foreignTaxPaid") if dictionary.get("foreignTaxPaid") else APIHelper.SKIP
        foreign_country = dictionary.get("foreignCountry") if dictionary.get("foreignCountry") else APIHelper.SKIP
        tax_exempt_interest = dictionary.get("taxExemptInterest") if dictionary.get("taxExemptInterest") else APIHelper.SKIP
        specified_pab_interest = dictionary.get("specifiedPabInterest") if dictionary.get("specifiedPabInterest") else APIHelper.SKIP
        market_discount = dictionary.get("marketDiscount") if dictionary.get("marketDiscount") else APIHelper.SKIP
        bond_premium = dictionary.get("bondPremium") if dictionary.get("bondPremium") else APIHelper.SKIP
        us_bond_premium = dictionary.get("usBondPremium") if dictionary.get("usBondPremium") else APIHelper.SKIP
        tax_exempt_bond_premium = dictionary.get("taxExemptBondPremium") if dictionary.get("taxExemptBondPremium") else APIHelper.SKIP
        cusip_number = dictionary.get("cusipNumber") if dictionary.get("cusipNumber") else APIHelper.SKIP
        state_and_local = None
        if dictionary.get('stateAndLocal') is not None:
            state_and_local = [StateAndLocalTaxWithholding.from_dictionary(x) for x in dictionary.get('stateAndLocal')]
        else:
            state_and_local = APIHelper.SKIP
        foreign_incomes = None
        if dictionary.get('foreignIncomes') is not None:
            foreign_incomes = [DescriptionAndAmount.from_dictionary(x) for x in dictionary.get('foreignIncomes')]
        else:
            foreign_incomes = APIHelper.SKIP
        state_tax_exempt_income = None
        if dictionary.get('stateTaxExemptIncome') is not None:
            state_tax_exempt_income = [DescriptionAndAmount.from_dictionary(x) for x in dictionary.get('stateTaxExemptIncome')]
        else:
            state_tax_exempt_income = APIHelper.SKIP
        second_tin_notice = dictionary.get("secondTinNotice") if "secondTinNotice" in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(tax_year,
                   corrected,
                   account_id,
                   tax_form_id,
                   tax_form_date,
                   additional_information,
                   tax_form_type,
                   issuer,
                   recipient,
                   attributes,
                   error,
                   links,
                   foreign_account_tax_compliance,
                   account_number,
                   payer_rtn,
                   interest_income,
                   early_withdrawal_penalty,
                   us_bond_interest,
                   federal_tax_withheld,
                   investment_expenses,
                   foreign_tax_paid,
                   foreign_country,
                   tax_exempt_interest,
                   specified_pab_interest,
                   market_discount,
                   bond_premium,
                   us_bond_premium,
                   tax_exempt_bond_premium,
                   cusip_number,
                   state_and_local,
                   foreign_incomes,
                   state_tax_exempt_income,
                   second_tin_notice,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!r}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!r}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!r}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!r}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!r}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!r}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!r}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!r}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!r}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!r}, '
                f'error={(self.error if hasattr(self, "error") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'foreign_account_tax_compliance={(self.foreign_account_tax_compliance if hasattr(self, "foreign_account_tax_compliance") else None)!r}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!r}, '
                f'payer_rtn={(self.payer_rtn if hasattr(self, "payer_rtn") else None)!r}, '
                f'interest_income={(self.interest_income if hasattr(self, "interest_income") else None)!r}, '
                f'early_withdrawal_penalty={(self.early_withdrawal_penalty if hasattr(self, "early_withdrawal_penalty") else None)!r}, '
                f'us_bond_interest={(self.us_bond_interest if hasattr(self, "us_bond_interest") else None)!r}, '
                f'federal_tax_withheld={(self.federal_tax_withheld if hasattr(self, "federal_tax_withheld") else None)!r}, '
                f'investment_expenses={(self.investment_expenses if hasattr(self, "investment_expenses") else None)!r}, '
                f'foreign_tax_paid={(self.foreign_tax_paid if hasattr(self, "foreign_tax_paid") else None)!r}, '
                f'foreign_country={(self.foreign_country if hasattr(self, "foreign_country") else None)!r}, '
                f'tax_exempt_interest={(self.tax_exempt_interest if hasattr(self, "tax_exempt_interest") else None)!r}, '
                f'specified_pab_interest={(self.specified_pab_interest if hasattr(self, "specified_pab_interest") else None)!r}, '
                f'market_discount={(self.market_discount if hasattr(self, "market_discount") else None)!r}, '
                f'bond_premium={(self.bond_premium if hasattr(self, "bond_premium") else None)!r}, '
                f'us_bond_premium={(self.us_bond_premium if hasattr(self, "us_bond_premium") else None)!r}, '
                f'tax_exempt_bond_premium={(self.tax_exempt_bond_premium if hasattr(self, "tax_exempt_bond_premium") else None)!r}, '
                f'cusip_number={(self.cusip_number if hasattr(self, "cusip_number") else None)!r}, '
                f'state_and_local={(self.state_and_local if hasattr(self, "state_and_local") else None)!r}, '
                f'foreign_incomes={(self.foreign_incomes if hasattr(self, "foreign_incomes") else None)!r}, '
                f'state_tax_exempt_income={(self.state_tax_exempt_income if hasattr(self, "state_tax_exempt_income") else None)!r}, '
                f'second_tin_notice={(self.second_tin_notice if hasattr(self, "second_tin_notice") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!s}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!s}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!s}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!s}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!s}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!s}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!s}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!s}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!s}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!s}, '
                f'error={(self.error if hasattr(self, "error") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'foreign_account_tax_compliance={(self.foreign_account_tax_compliance if hasattr(self, "foreign_account_tax_compliance") else None)!s}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!s}, '
                f'payer_rtn={(self.payer_rtn if hasattr(self, "payer_rtn") else None)!s}, '
                f'interest_income={(self.interest_income if hasattr(self, "interest_income") else None)!s}, '
                f'early_withdrawal_penalty={(self.early_withdrawal_penalty if hasattr(self, "early_withdrawal_penalty") else None)!s}, '
                f'us_bond_interest={(self.us_bond_interest if hasattr(self, "us_bond_interest") else None)!s}, '
                f'federal_tax_withheld={(self.federal_tax_withheld if hasattr(self, "federal_tax_withheld") else None)!s}, '
                f'investment_expenses={(self.investment_expenses if hasattr(self, "investment_expenses") else None)!s}, '
                f'foreign_tax_paid={(self.foreign_tax_paid if hasattr(self, "foreign_tax_paid") else None)!s}, '
                f'foreign_country={(self.foreign_country if hasattr(self, "foreign_country") else None)!s}, '
                f'tax_exempt_interest={(self.tax_exempt_interest if hasattr(self, "tax_exempt_interest") else None)!s}, '
                f'specified_pab_interest={(self.specified_pab_interest if hasattr(self, "specified_pab_interest") else None)!s}, '
                f'market_discount={(self.market_discount if hasattr(self, "market_discount") else None)!s}, '
                f'bond_premium={(self.bond_premium if hasattr(self, "bond_premium") else None)!s}, '
                f'us_bond_premium={(self.us_bond_premium if hasattr(self, "us_bond_premium") else None)!s}, '
                f'tax_exempt_bond_premium={(self.tax_exempt_bond_premium if hasattr(self, "tax_exempt_bond_premium") else None)!s}, '
                f'cusip_number={(self.cusip_number if hasattr(self, "cusip_number") else None)!s}, '
                f'state_and_local={(self.state_and_local if hasattr(self, "state_and_local") else None)!s}, '
                f'foreign_incomes={(self.foreign_incomes if hasattr(self, "foreign_incomes") else None)!s}, '
                f'state_tax_exempt_income={(self.state_tax_exempt_income if hasattr(self, "state_tax_exempt_income") else None)!s}, '
                f'second_tin_notice={(self.second_tin_notice if hasattr(self, "second_tin_notice") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
