# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.description_and_amount import DescriptionAndAmount
from fdxapi.models.error_1 import Error1
from fdxapi.models.hateoas_link import HateoasLink
from fdxapi.models.state_and_local_tax_withholding import StateAndLocalTaxWithholding
from fdxapi.models.tax_form_attribute import TaxFormAttribute
from fdxapi.models.tax_party_1 import TaxParty1
from fdxapi.models.tax_party_8 import TaxParty8


class Form1099Oid1(object):

    """Implementation of the 'Form 1099-OID1' model.

    Original Issue Discount

    Attributes:
        tax_year (int): Year for which taxes are being paid
        corrected (bool): True to indicate this is a corrected tax form
        account_id (str): Long-term persistent identity of the source account.
            Not the account number
        tax_form_id (str): Long-term persistent id for this tax form.
            Depending upon the data provider, this may be the same id as the
            enclosing tax statement id, or this may be a different id, or this
            id may be omitted.
        tax_form_date (date): Date of production or delivery of the tax form
        additional_information (str): Additional explanation text or content
            about this tax form
        tax_form_type (TypeFormType1): Enumerated name of the tax form entity
            e.g. "TaxW2"
        issuer (TaxParty8): Issuer's name, address, phone, and TIN. Issuer
            data need only be transmitted on enclosing TaxStatement, if it is
            the same on all its included tax forms.
        recipient (TaxParty1): Recipient's name, address, phone, and TIN.
            Recipient data need only be transmitted on enclosing TaxStatement,
            if it is the same on all its included tax forms.
        attributes (List[TaxFormAttribute]): Additional attributes for this
            tax form when defined fields are not available. Some specific
            additional attributes already defined by providers: Fields
            required by [IRS
            FIRE](https://www.irs.gov/e-file-providers/filing-information-retur
            ns-electronically-fire): Name Control, Type of Identification
            Number (EIN, SSN, ITIN, ATIN). (ATIN is tax ID number for pending
            adoptions.) Tax form provider field for taxpayer notification:
            Recipient Email Address.
        error (Error1): Present if an error was encountered while retrieving
            this form
        links (List[HateoasLink]): Links to retrieve this form as data or
            image, or to invoke other APIs
        foreign_account_tax_compliance (bool): FATCA filing requirement
        account_number (str): Account number
        original_issue_discount (float): Box 1, Original issue discount
        other_periodic_interest (float): Box 2, Other periodic interest
        early_withdrawal_penalty (float): Box 3, Early withdrawal penalty
        federal_tax_withheld (float): Box 4, Federal income tax withheld
        market_discount (float): Box 5, Market discount
        acquisition_premium (float): Box 6, Acquisition premium
        oid_description (str): Box 7, Description
        discount_on_treasury_obligations (float): Box 8, Original issue
            discount on U.S. Treasury obligations
        investment_expenses (float): Box 9, Investment expenses
        bond_premium (float): Box 10, Bond premium
        tax_exempt_oid (float): Box 11, Tax-exempt OID
        state_and_local (List[StateAndLocalTaxWithholding]): Boxes 12-14,
            State and Local tax withheld
        state_exempt_oid (List[DescriptionAndAmount]): Supplemental: State
            name and tax-exempt OID by state
        second_tin_notice (bool): Second TIN Notice
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "tax_year": 'taxYear',
        "corrected": 'corrected',
        "account_id": 'accountId',
        "tax_form_id": 'taxFormId',
        "tax_form_date": 'taxFormDate',
        "additional_information": 'additionalInformation',
        "tax_form_type": 'taxFormType',
        "issuer": 'issuer',
        "recipient": 'recipient',
        "attributes": 'attributes',
        "error": 'error',
        "links": 'links',
        "foreign_account_tax_compliance": 'foreignAccountTaxCompliance',
        "account_number": 'accountNumber',
        "original_issue_discount": 'originalIssueDiscount',
        "other_periodic_interest": 'otherPeriodicInterest',
        "early_withdrawal_penalty": 'earlyWithdrawalPenalty',
        "federal_tax_withheld": 'federalTaxWithheld',
        "market_discount": 'marketDiscount',
        "acquisition_premium": 'acquisitionPremium',
        "oid_description": 'oidDescription',
        "discount_on_treasury_obligations": 'discountOnTreasuryObligations',
        "investment_expenses": 'investmentExpenses',
        "bond_premium": 'bondPremium',
        "tax_exempt_oid": 'taxExemptOid',
        "state_and_local": 'stateAndLocal',
        "state_exempt_oid": 'stateExemptOid',
        "second_tin_notice": 'secondTinNotice'
    }

    _optionals = [
        'tax_year',
        'corrected',
        'account_id',
        'tax_form_id',
        'tax_form_date',
        'additional_information',
        'tax_form_type',
        'issuer',
        'recipient',
        'attributes',
        'error',
        'links',
        'foreign_account_tax_compliance',
        'account_number',
        'original_issue_discount',
        'other_periodic_interest',
        'early_withdrawal_penalty',
        'federal_tax_withheld',
        'market_discount',
        'acquisition_premium',
        'oid_description',
        'discount_on_treasury_obligations',
        'investment_expenses',
        'bond_premium',
        'tax_exempt_oid',
        'state_and_local',
        'state_exempt_oid',
        'second_tin_notice',
    ]

    def __init__(self,
                 tax_year=APIHelper.SKIP,
                 corrected=APIHelper.SKIP,
                 account_id=APIHelper.SKIP,
                 tax_form_id=APIHelper.SKIP,
                 tax_form_date=APIHelper.SKIP,
                 additional_information=APIHelper.SKIP,
                 tax_form_type=APIHelper.SKIP,
                 issuer=APIHelper.SKIP,
                 recipient=APIHelper.SKIP,
                 attributes=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 foreign_account_tax_compliance=APIHelper.SKIP,
                 account_number=APIHelper.SKIP,
                 original_issue_discount=APIHelper.SKIP,
                 other_periodic_interest=APIHelper.SKIP,
                 early_withdrawal_penalty=APIHelper.SKIP,
                 federal_tax_withheld=APIHelper.SKIP,
                 market_discount=APIHelper.SKIP,
                 acquisition_premium=APIHelper.SKIP,
                 oid_description=APIHelper.SKIP,
                 discount_on_treasury_obligations=APIHelper.SKIP,
                 investment_expenses=APIHelper.SKIP,
                 bond_premium=APIHelper.SKIP,
                 tax_exempt_oid=APIHelper.SKIP,
                 state_and_local=APIHelper.SKIP,
                 state_exempt_oid=APIHelper.SKIP,
                 second_tin_notice=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the Form1099Oid1 class"""

        # Initialize members of the class
        if tax_year is not APIHelper.SKIP:
            self.tax_year = tax_year 
        if corrected is not APIHelper.SKIP:
            self.corrected = corrected 
        if account_id is not APIHelper.SKIP:
            self.account_id = account_id 
        if tax_form_id is not APIHelper.SKIP:
            self.tax_form_id = tax_form_id 
        if tax_form_date is not APIHelper.SKIP:
            self.tax_form_date = tax_form_date 
        if additional_information is not APIHelper.SKIP:
            self.additional_information = additional_information 
        if tax_form_type is not APIHelper.SKIP:
            self.tax_form_type = tax_form_type 
        if issuer is not APIHelper.SKIP:
            self.issuer = issuer 
        if recipient is not APIHelper.SKIP:
            self.recipient = recipient 
        if attributes is not APIHelper.SKIP:
            self.attributes = attributes 
        if error is not APIHelper.SKIP:
            self.error = error 
        if links is not APIHelper.SKIP:
            self.links = links 
        if foreign_account_tax_compliance is not APIHelper.SKIP:
            self.foreign_account_tax_compliance = foreign_account_tax_compliance 
        if account_number is not APIHelper.SKIP:
            self.account_number = account_number 
        if original_issue_discount is not APIHelper.SKIP:
            self.original_issue_discount = original_issue_discount 
        if other_periodic_interest is not APIHelper.SKIP:
            self.other_periodic_interest = other_periodic_interest 
        if early_withdrawal_penalty is not APIHelper.SKIP:
            self.early_withdrawal_penalty = early_withdrawal_penalty 
        if federal_tax_withheld is not APIHelper.SKIP:
            self.federal_tax_withheld = federal_tax_withheld 
        if market_discount is not APIHelper.SKIP:
            self.market_discount = market_discount 
        if acquisition_premium is not APIHelper.SKIP:
            self.acquisition_premium = acquisition_premium 
        if oid_description is not APIHelper.SKIP:
            self.oid_description = oid_description 
        if discount_on_treasury_obligations is not APIHelper.SKIP:
            self.discount_on_treasury_obligations = discount_on_treasury_obligations 
        if investment_expenses is not APIHelper.SKIP:
            self.investment_expenses = investment_expenses 
        if bond_premium is not APIHelper.SKIP:
            self.bond_premium = bond_premium 
        if tax_exempt_oid is not APIHelper.SKIP:
            self.tax_exempt_oid = tax_exempt_oid 
        if state_and_local is not APIHelper.SKIP:
            self.state_and_local = state_and_local 
        if state_exempt_oid is not APIHelper.SKIP:
            self.state_exempt_oid = state_exempt_oid 
        if second_tin_notice is not APIHelper.SKIP:
            self.second_tin_notice = second_tin_notice 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        tax_year = dictionary.get("taxYear") if dictionary.get("taxYear") else APIHelper.SKIP
        corrected = dictionary.get("corrected") if "corrected" in dictionary.keys() else APIHelper.SKIP
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        tax_form_id = dictionary.get("taxFormId") if dictionary.get("taxFormId") else APIHelper.SKIP
        tax_form_date = dateutil.parser.parse(dictionary.get('taxFormDate')).date() if dictionary.get('taxFormDate') else APIHelper.SKIP
        additional_information = dictionary.get("additionalInformation") if dictionary.get("additionalInformation") else APIHelper.SKIP
        tax_form_type = dictionary.get("taxFormType") if dictionary.get("taxFormType") else APIHelper.SKIP
        issuer = TaxParty8.from_dictionary(dictionary.get('issuer')) if 'issuer' in dictionary.keys() else APIHelper.SKIP
        recipient = TaxParty1.from_dictionary(dictionary.get('recipient')) if 'recipient' in dictionary.keys() else APIHelper.SKIP
        attributes = None
        if dictionary.get('attributes') is not None:
            attributes = [TaxFormAttribute.from_dictionary(x) for x in dictionary.get('attributes')]
        else:
            attributes = APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        foreign_account_tax_compliance = dictionary.get("foreignAccountTaxCompliance") if "foreignAccountTaxCompliance" in dictionary.keys() else APIHelper.SKIP
        account_number = dictionary.get("accountNumber") if dictionary.get("accountNumber") else APIHelper.SKIP
        original_issue_discount = dictionary.get("originalIssueDiscount") if dictionary.get("originalIssueDiscount") else APIHelper.SKIP
        other_periodic_interest = dictionary.get("otherPeriodicInterest") if dictionary.get("otherPeriodicInterest") else APIHelper.SKIP
        early_withdrawal_penalty = dictionary.get("earlyWithdrawalPenalty") if dictionary.get("earlyWithdrawalPenalty") else APIHelper.SKIP
        federal_tax_withheld = dictionary.get("federalTaxWithheld") if dictionary.get("federalTaxWithheld") else APIHelper.SKIP
        market_discount = dictionary.get("marketDiscount") if dictionary.get("marketDiscount") else APIHelper.SKIP
        acquisition_premium = dictionary.get("acquisitionPremium") if dictionary.get("acquisitionPremium") else APIHelper.SKIP
        oid_description = dictionary.get("oidDescription") if dictionary.get("oidDescription") else APIHelper.SKIP
        discount_on_treasury_obligations = dictionary.get("discountOnTreasuryObligations") if dictionary.get("discountOnTreasuryObligations") else APIHelper.SKIP
        investment_expenses = dictionary.get("investmentExpenses") if dictionary.get("investmentExpenses") else APIHelper.SKIP
        bond_premium = dictionary.get("bondPremium") if dictionary.get("bondPremium") else APIHelper.SKIP
        tax_exempt_oid = dictionary.get("taxExemptOid") if dictionary.get("taxExemptOid") else APIHelper.SKIP
        state_and_local = None
        if dictionary.get('stateAndLocal') is not None:
            state_and_local = [StateAndLocalTaxWithholding.from_dictionary(x) for x in dictionary.get('stateAndLocal')]
        else:
            state_and_local = APIHelper.SKIP
        state_exempt_oid = None
        if dictionary.get('stateExemptOid') is not None:
            state_exempt_oid = [DescriptionAndAmount.from_dictionary(x) for x in dictionary.get('stateExemptOid')]
        else:
            state_exempt_oid = APIHelper.SKIP
        second_tin_notice = dictionary.get("secondTinNotice") if "secondTinNotice" in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(tax_year,
                   corrected,
                   account_id,
                   tax_form_id,
                   tax_form_date,
                   additional_information,
                   tax_form_type,
                   issuer,
                   recipient,
                   attributes,
                   error,
                   links,
                   foreign_account_tax_compliance,
                   account_number,
                   original_issue_discount,
                   other_periodic_interest,
                   early_withdrawal_penalty,
                   federal_tax_withheld,
                   market_discount,
                   acquisition_premium,
                   oid_description,
                   discount_on_treasury_obligations,
                   investment_expenses,
                   bond_premium,
                   tax_exempt_oid,
                   state_and_local,
                   state_exempt_oid,
                   second_tin_notice,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!r}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!r}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!r}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!r}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!r}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!r}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!r}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!r}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!r}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!r}, '
                f'error={(self.error if hasattr(self, "error") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'foreign_account_tax_compliance={(self.foreign_account_tax_compliance if hasattr(self, "foreign_account_tax_compliance") else None)!r}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!r}, '
                f'original_issue_discount={(self.original_issue_discount if hasattr(self, "original_issue_discount") else None)!r}, '
                f'other_periodic_interest={(self.other_periodic_interest if hasattr(self, "other_periodic_interest") else None)!r}, '
                f'early_withdrawal_penalty={(self.early_withdrawal_penalty if hasattr(self, "early_withdrawal_penalty") else None)!r}, '
                f'federal_tax_withheld={(self.federal_tax_withheld if hasattr(self, "federal_tax_withheld") else None)!r}, '
                f'market_discount={(self.market_discount if hasattr(self, "market_discount") else None)!r}, '
                f'acquisition_premium={(self.acquisition_premium if hasattr(self, "acquisition_premium") else None)!r}, '
                f'oid_description={(self.oid_description if hasattr(self, "oid_description") else None)!r}, '
                f'discount_on_treasury_obligations={(self.discount_on_treasury_obligations if hasattr(self, "discount_on_treasury_obligations") else None)!r}, '
                f'investment_expenses={(self.investment_expenses if hasattr(self, "investment_expenses") else None)!r}, '
                f'bond_premium={(self.bond_premium if hasattr(self, "bond_premium") else None)!r}, '
                f'tax_exempt_oid={(self.tax_exempt_oid if hasattr(self, "tax_exempt_oid") else None)!r}, '
                f'state_and_local={(self.state_and_local if hasattr(self, "state_and_local") else None)!r}, '
                f'state_exempt_oid={(self.state_exempt_oid if hasattr(self, "state_exempt_oid") else None)!r}, '
                f'second_tin_notice={(self.second_tin_notice if hasattr(self, "second_tin_notice") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!s}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!s}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!s}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!s}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!s}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!s}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!s}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!s}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!s}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!s}, '
                f'error={(self.error if hasattr(self, "error") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'foreign_account_tax_compliance={(self.foreign_account_tax_compliance if hasattr(self, "foreign_account_tax_compliance") else None)!s}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!s}, '
                f'original_issue_discount={(self.original_issue_discount if hasattr(self, "original_issue_discount") else None)!s}, '
                f'other_periodic_interest={(self.other_periodic_interest if hasattr(self, "other_periodic_interest") else None)!s}, '
                f'early_withdrawal_penalty={(self.early_withdrawal_penalty if hasattr(self, "early_withdrawal_penalty") else None)!s}, '
                f'federal_tax_withheld={(self.federal_tax_withheld if hasattr(self, "federal_tax_withheld") else None)!s}, '
                f'market_discount={(self.market_discount if hasattr(self, "market_discount") else None)!s}, '
                f'acquisition_premium={(self.acquisition_premium if hasattr(self, "acquisition_premium") else None)!s}, '
                f'oid_description={(self.oid_description if hasattr(self, "oid_description") else None)!s}, '
                f'discount_on_treasury_obligations={(self.discount_on_treasury_obligations if hasattr(self, "discount_on_treasury_obligations") else None)!s}, '
                f'investment_expenses={(self.investment_expenses if hasattr(self, "investment_expenses") else None)!s}, '
                f'bond_premium={(self.bond_premium if hasattr(self, "bond_premium") else None)!s}, '
                f'tax_exempt_oid={(self.tax_exempt_oid if hasattr(self, "tax_exempt_oid") else None)!s}, '
                f'state_and_local={(self.state_and_local if hasattr(self, "state_and_local") else None)!s}, '
                f'state_exempt_oid={(self.state_exempt_oid if hasattr(self, "state_exempt_oid") else None)!s}, '
                f'second_tin_notice={(self.second_tin_notice if hasattr(self, "second_tin_notice") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
