# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.code_and_amount import CodeAndAmount
from fdxapi.models.description_and_amount import DescriptionAndAmount
from fdxapi.models.error_1 import Error1
from fdxapi.models.hateoas_link import HateoasLink
from fdxapi.models.state_and_local_tax_withholding import StateAndLocalTaxWithholding
from fdxapi.models.tax_form_attribute import TaxFormAttribute
from fdxapi.models.tax_party_1 import TaxParty1
from fdxapi.models.tax_party_8 import TaxParty8


class FormW21(object):

    """Implementation of the 'Form W-21' model.

    Boxes 1-20 of Previously reported Wage and Tax Statement

    Attributes:
        tax_year (int): Year for which taxes are being paid
        corrected (bool): True to indicate this is a corrected tax form
        account_id (str): Long-term persistent identity of the source account.
            Not the account number
        tax_form_id (str): Long-term persistent id for this tax form.
            Depending upon the data provider, this may be the same id as the
            enclosing tax statement id, or this may be a different id, or this
            id may be omitted.
        tax_form_date (date): Date of production or delivery of the tax form
        additional_information (str): Additional explanation text or content
            about this tax form
        tax_form_type (TypeFormType1): Enumerated name of the tax form entity
            e.g. "TaxW2"
        issuer (TaxParty8): Issuer's name, address, phone, and TIN. Issuer
            data need only be transmitted on enclosing TaxStatement, if it is
            the same on all its included tax forms.
        recipient (TaxParty1): Recipient's name, address, phone, and TIN.
            Recipient data need only be transmitted on enclosing TaxStatement,
            if it is the same on all its included tax forms.
        attributes (List[TaxFormAttribute]): Additional attributes for this
            tax form when defined fields are not available. Some specific
            additional attributes already defined by providers: Fields
            required by [IRS
            FIRE](https://www.irs.gov/e-file-providers/filing-information-retur
            ns-electronically-fire): Name Control, Type of Identification
            Number (EIN, SSN, ITIN, ATIN). (ATIN is tax ID number for pending
            adoptions.) Tax form provider field for taxpayer notification:
            Recipient Email Address.
        error (Error1): Present if an error was encountered while retrieving
            this form
        links (List[HateoasLink]): Links to retrieve this form as data or
            image, or to invoke other APIs
        control_number (str): Control number
        wages (float): Box 1, Wages, tips, other compensation
        federal_tax_withheld (float): Box 2, Federal income tax withheld
        social_security_wages (float): Box 3, Social security wages
        social_security_tax_withheld (float): Box 4, Social security tax
            withheld
        medicare_wages (float): Box 5, Medicare wages and tips
        medicare_tax_withheld (float): Box 6, Medicare tax withheld
        social_security_tips (float): Box 7, Social security tips
        allocated_tips (float): Box 8, Allocated tips
        dependent_care_benefit (float): Box 10, Dependent care benefits
        non_qualified_plan (float): Box 11, Nonqualified plans
        codes (List[CodeAndAmount]): Box 12, Codes and amounts
        statutory (bool): Box 13, Statutory employee
        retirement_plan (bool): Box 13, Retirement plan
        third_party_sick_pay (bool): Box 13, Third-party sick pay
        espp_qualified (float): Employee Stock Purchase Plan Qualified
            Disposition amount
        espp_non_qualified (float): Employee Stock Purchase Plan Nonqualified
            Disposition amount
        other (List[DescriptionAndAmount]): Box 14, Other descriptions and
            amounts
        state_and_local (List[StateAndLocalTaxWithholding]): Boxes 15-20,
            State and Local tax withholding
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "tax_year": 'taxYear',
        "corrected": 'corrected',
        "account_id": 'accountId',
        "tax_form_id": 'taxFormId',
        "tax_form_date": 'taxFormDate',
        "additional_information": 'additionalInformation',
        "tax_form_type": 'taxFormType',
        "issuer": 'issuer',
        "recipient": 'recipient',
        "attributes": 'attributes',
        "error": 'error',
        "links": 'links',
        "control_number": 'controlNumber',
        "wages": 'wages',
        "federal_tax_withheld": 'federalTaxWithheld',
        "social_security_wages": 'socialSecurityWages',
        "social_security_tax_withheld": 'socialSecurityTaxWithheld',
        "medicare_wages": 'medicareWages',
        "medicare_tax_withheld": 'medicareTaxWithheld',
        "social_security_tips": 'socialSecurityTips',
        "allocated_tips": 'allocatedTips',
        "dependent_care_benefit": 'dependentCareBenefit',
        "non_qualified_plan": 'nonQualifiedPlan',
        "codes": 'codes',
        "statutory": 'statutory',
        "retirement_plan": 'retirementPlan',
        "third_party_sick_pay": 'thirdPartySickPay',
        "espp_qualified": 'esppQualified',
        "espp_non_qualified": 'esppNonQualified',
        "other": 'other',
        "state_and_local": 'stateAndLocal'
    }

    _optionals = [
        'tax_year',
        'corrected',
        'account_id',
        'tax_form_id',
        'tax_form_date',
        'additional_information',
        'tax_form_type',
        'issuer',
        'recipient',
        'attributes',
        'error',
        'links',
        'control_number',
        'wages',
        'federal_tax_withheld',
        'social_security_wages',
        'social_security_tax_withheld',
        'medicare_wages',
        'medicare_tax_withheld',
        'social_security_tips',
        'allocated_tips',
        'dependent_care_benefit',
        'non_qualified_plan',
        'codes',
        'statutory',
        'retirement_plan',
        'third_party_sick_pay',
        'espp_qualified',
        'espp_non_qualified',
        'other',
        'state_and_local',
    ]

    def __init__(self,
                 tax_year=APIHelper.SKIP,
                 corrected=APIHelper.SKIP,
                 account_id=APIHelper.SKIP,
                 tax_form_id=APIHelper.SKIP,
                 tax_form_date=APIHelper.SKIP,
                 additional_information=APIHelper.SKIP,
                 tax_form_type=APIHelper.SKIP,
                 issuer=APIHelper.SKIP,
                 recipient=APIHelper.SKIP,
                 attributes=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 control_number=APIHelper.SKIP,
                 wages=APIHelper.SKIP,
                 federal_tax_withheld=APIHelper.SKIP,
                 social_security_wages=APIHelper.SKIP,
                 social_security_tax_withheld=APIHelper.SKIP,
                 medicare_wages=APIHelper.SKIP,
                 medicare_tax_withheld=APIHelper.SKIP,
                 social_security_tips=APIHelper.SKIP,
                 allocated_tips=APIHelper.SKIP,
                 dependent_care_benefit=APIHelper.SKIP,
                 non_qualified_plan=APIHelper.SKIP,
                 codes=APIHelper.SKIP,
                 statutory=APIHelper.SKIP,
                 retirement_plan=APIHelper.SKIP,
                 third_party_sick_pay=APIHelper.SKIP,
                 espp_qualified=APIHelper.SKIP,
                 espp_non_qualified=APIHelper.SKIP,
                 other=APIHelper.SKIP,
                 state_and_local=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the FormW21 class"""

        # Initialize members of the class
        if tax_year is not APIHelper.SKIP:
            self.tax_year = tax_year 
        if corrected is not APIHelper.SKIP:
            self.corrected = corrected 
        if account_id is not APIHelper.SKIP:
            self.account_id = account_id 
        if tax_form_id is not APIHelper.SKIP:
            self.tax_form_id = tax_form_id 
        if tax_form_date is not APIHelper.SKIP:
            self.tax_form_date = tax_form_date 
        if additional_information is not APIHelper.SKIP:
            self.additional_information = additional_information 
        if tax_form_type is not APIHelper.SKIP:
            self.tax_form_type = tax_form_type 
        if issuer is not APIHelper.SKIP:
            self.issuer = issuer 
        if recipient is not APIHelper.SKIP:
            self.recipient = recipient 
        if attributes is not APIHelper.SKIP:
            self.attributes = attributes 
        if error is not APIHelper.SKIP:
            self.error = error 
        if links is not APIHelper.SKIP:
            self.links = links 
        if control_number is not APIHelper.SKIP:
            self.control_number = control_number 
        if wages is not APIHelper.SKIP:
            self.wages = wages 
        if federal_tax_withheld is not APIHelper.SKIP:
            self.federal_tax_withheld = federal_tax_withheld 
        if social_security_wages is not APIHelper.SKIP:
            self.social_security_wages = social_security_wages 
        if social_security_tax_withheld is not APIHelper.SKIP:
            self.social_security_tax_withheld = social_security_tax_withheld 
        if medicare_wages is not APIHelper.SKIP:
            self.medicare_wages = medicare_wages 
        if medicare_tax_withheld is not APIHelper.SKIP:
            self.medicare_tax_withheld = medicare_tax_withheld 
        if social_security_tips is not APIHelper.SKIP:
            self.social_security_tips = social_security_tips 
        if allocated_tips is not APIHelper.SKIP:
            self.allocated_tips = allocated_tips 
        if dependent_care_benefit is not APIHelper.SKIP:
            self.dependent_care_benefit = dependent_care_benefit 
        if non_qualified_plan is not APIHelper.SKIP:
            self.non_qualified_plan = non_qualified_plan 
        if codes is not APIHelper.SKIP:
            self.codes = codes 
        if statutory is not APIHelper.SKIP:
            self.statutory = statutory 
        if retirement_plan is not APIHelper.SKIP:
            self.retirement_plan = retirement_plan 
        if third_party_sick_pay is not APIHelper.SKIP:
            self.third_party_sick_pay = third_party_sick_pay 
        if espp_qualified is not APIHelper.SKIP:
            self.espp_qualified = espp_qualified 
        if espp_non_qualified is not APIHelper.SKIP:
            self.espp_non_qualified = espp_non_qualified 
        if other is not APIHelper.SKIP:
            self.other = other 
        if state_and_local is not APIHelper.SKIP:
            self.state_and_local = state_and_local 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        tax_year = dictionary.get("taxYear") if dictionary.get("taxYear") else APIHelper.SKIP
        corrected = dictionary.get("corrected") if "corrected" in dictionary.keys() else APIHelper.SKIP
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        tax_form_id = dictionary.get("taxFormId") if dictionary.get("taxFormId") else APIHelper.SKIP
        tax_form_date = dateutil.parser.parse(dictionary.get('taxFormDate')).date() if dictionary.get('taxFormDate') else APIHelper.SKIP
        additional_information = dictionary.get("additionalInformation") if dictionary.get("additionalInformation") else APIHelper.SKIP
        tax_form_type = dictionary.get("taxFormType") if dictionary.get("taxFormType") else APIHelper.SKIP
        issuer = TaxParty8.from_dictionary(dictionary.get('issuer')) if 'issuer' in dictionary.keys() else APIHelper.SKIP
        recipient = TaxParty1.from_dictionary(dictionary.get('recipient')) if 'recipient' in dictionary.keys() else APIHelper.SKIP
        attributes = None
        if dictionary.get('attributes') is not None:
            attributes = [TaxFormAttribute.from_dictionary(x) for x in dictionary.get('attributes')]
        else:
            attributes = APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        control_number = dictionary.get("controlNumber") if dictionary.get("controlNumber") else APIHelper.SKIP
        wages = dictionary.get("wages") if dictionary.get("wages") else APIHelper.SKIP
        federal_tax_withheld = dictionary.get("federalTaxWithheld") if dictionary.get("federalTaxWithheld") else APIHelper.SKIP
        social_security_wages = dictionary.get("socialSecurityWages") if dictionary.get("socialSecurityWages") else APIHelper.SKIP
        social_security_tax_withheld = dictionary.get("socialSecurityTaxWithheld") if dictionary.get("socialSecurityTaxWithheld") else APIHelper.SKIP
        medicare_wages = dictionary.get("medicareWages") if dictionary.get("medicareWages") else APIHelper.SKIP
        medicare_tax_withheld = dictionary.get("medicareTaxWithheld") if dictionary.get("medicareTaxWithheld") else APIHelper.SKIP
        social_security_tips = dictionary.get("socialSecurityTips") if dictionary.get("socialSecurityTips") else APIHelper.SKIP
        allocated_tips = dictionary.get("allocatedTips") if dictionary.get("allocatedTips") else APIHelper.SKIP
        dependent_care_benefit = dictionary.get("dependentCareBenefit") if dictionary.get("dependentCareBenefit") else APIHelper.SKIP
        non_qualified_plan = dictionary.get("nonQualifiedPlan") if dictionary.get("nonQualifiedPlan") else APIHelper.SKIP
        codes = None
        if dictionary.get('codes') is not None:
            codes = [CodeAndAmount.from_dictionary(x) for x in dictionary.get('codes')]
        else:
            codes = APIHelper.SKIP
        statutory = dictionary.get("statutory") if "statutory" in dictionary.keys() else APIHelper.SKIP
        retirement_plan = dictionary.get("retirementPlan") if "retirementPlan" in dictionary.keys() else APIHelper.SKIP
        third_party_sick_pay = dictionary.get("thirdPartySickPay") if "thirdPartySickPay" in dictionary.keys() else APIHelper.SKIP
        espp_qualified = dictionary.get("esppQualified") if dictionary.get("esppQualified") else APIHelper.SKIP
        espp_non_qualified = dictionary.get("esppNonQualified") if dictionary.get("esppNonQualified") else APIHelper.SKIP
        other = None
        if dictionary.get('other') is not None:
            other = [DescriptionAndAmount.from_dictionary(x) for x in dictionary.get('other')]
        else:
            other = APIHelper.SKIP
        state_and_local = None
        if dictionary.get('stateAndLocal') is not None:
            state_and_local = [StateAndLocalTaxWithholding.from_dictionary(x) for x in dictionary.get('stateAndLocal')]
        else:
            state_and_local = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(tax_year,
                   corrected,
                   account_id,
                   tax_form_id,
                   tax_form_date,
                   additional_information,
                   tax_form_type,
                   issuer,
                   recipient,
                   attributes,
                   error,
                   links,
                   control_number,
                   wages,
                   federal_tax_withheld,
                   social_security_wages,
                   social_security_tax_withheld,
                   medicare_wages,
                   medicare_tax_withheld,
                   social_security_tips,
                   allocated_tips,
                   dependent_care_benefit,
                   non_qualified_plan,
                   codes,
                   statutory,
                   retirement_plan,
                   third_party_sick_pay,
                   espp_qualified,
                   espp_non_qualified,
                   other,
                   state_and_local,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!r}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!r}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!r}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!r}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!r}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!r}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!r}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!r}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!r}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!r}, '
                f'error={(self.error if hasattr(self, "error") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'control_number={(self.control_number if hasattr(self, "control_number") else None)!r}, '
                f'wages={(self.wages if hasattr(self, "wages") else None)!r}, '
                f'federal_tax_withheld={(self.federal_tax_withheld if hasattr(self, "federal_tax_withheld") else None)!r}, '
                f'social_security_wages={(self.social_security_wages if hasattr(self, "social_security_wages") else None)!r}, '
                f'social_security_tax_withheld={(self.social_security_tax_withheld if hasattr(self, "social_security_tax_withheld") else None)!r}, '
                f'medicare_wages={(self.medicare_wages if hasattr(self, "medicare_wages") else None)!r}, '
                f'medicare_tax_withheld={(self.medicare_tax_withheld if hasattr(self, "medicare_tax_withheld") else None)!r}, '
                f'social_security_tips={(self.social_security_tips if hasattr(self, "social_security_tips") else None)!r}, '
                f'allocated_tips={(self.allocated_tips if hasattr(self, "allocated_tips") else None)!r}, '
                f'dependent_care_benefit={(self.dependent_care_benefit if hasattr(self, "dependent_care_benefit") else None)!r}, '
                f'non_qualified_plan={(self.non_qualified_plan if hasattr(self, "non_qualified_plan") else None)!r}, '
                f'codes={(self.codes if hasattr(self, "codes") else None)!r}, '
                f'statutory={(self.statutory if hasattr(self, "statutory") else None)!r}, '
                f'retirement_plan={(self.retirement_plan if hasattr(self, "retirement_plan") else None)!r}, '
                f'third_party_sick_pay={(self.third_party_sick_pay if hasattr(self, "third_party_sick_pay") else None)!r}, '
                f'espp_qualified={(self.espp_qualified if hasattr(self, "espp_qualified") else None)!r}, '
                f'espp_non_qualified={(self.espp_non_qualified if hasattr(self, "espp_non_qualified") else None)!r}, '
                f'other={(self.other if hasattr(self, "other") else None)!r}, '
                f'state_and_local={(self.state_and_local if hasattr(self, "state_and_local") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!s}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!s}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!s}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!s}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!s}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!s}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!s}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!s}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!s}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!s}, '
                f'error={(self.error if hasattr(self, "error") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'control_number={(self.control_number if hasattr(self, "control_number") else None)!s}, '
                f'wages={(self.wages if hasattr(self, "wages") else None)!s}, '
                f'federal_tax_withheld={(self.federal_tax_withheld if hasattr(self, "federal_tax_withheld") else None)!s}, '
                f'social_security_wages={(self.social_security_wages if hasattr(self, "social_security_wages") else None)!s}, '
                f'social_security_tax_withheld={(self.social_security_tax_withheld if hasattr(self, "social_security_tax_withheld") else None)!s}, '
                f'medicare_wages={(self.medicare_wages if hasattr(self, "medicare_wages") else None)!s}, '
                f'medicare_tax_withheld={(self.medicare_tax_withheld if hasattr(self, "medicare_tax_withheld") else None)!s}, '
                f'social_security_tips={(self.social_security_tips if hasattr(self, "social_security_tips") else None)!s}, '
                f'allocated_tips={(self.allocated_tips if hasattr(self, "allocated_tips") else None)!s}, '
                f'dependent_care_benefit={(self.dependent_care_benefit if hasattr(self, "dependent_care_benefit") else None)!s}, '
                f'non_qualified_plan={(self.non_qualified_plan if hasattr(self, "non_qualified_plan") else None)!s}, '
                f'codes={(self.codes if hasattr(self, "codes") else None)!s}, '
                f'statutory={(self.statutory if hasattr(self, "statutory") else None)!s}, '
                f'retirement_plan={(self.retirement_plan if hasattr(self, "retirement_plan") else None)!s}, '
                f'third_party_sick_pay={(self.third_party_sick_pay if hasattr(self, "third_party_sick_pay") else None)!s}, '
                f'espp_qualified={(self.espp_qualified if hasattr(self, "espp_qualified") else None)!s}, '
                f'espp_non_qualified={(self.espp_non_qualified if hasattr(self, "espp_non_qualified") else None)!s}, '
                f'other={(self.other if hasattr(self, "other") else None)!s}, '
                f'state_and_local={(self.state_and_local if hasattr(self, "state_and_local") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
