# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper


class GainOrLossFromCryptocurrencyTransaction(object):

    """Implementation of the 'Gain or loss from cryptocurrency transaction' model.

    Tax information for a single cryptocurrency transaction. If reported on
    Form 1099-B, use Tax1099B and SecurityDetail instead of this entity.

    Attributes:
        cryptocurrency_name (str): Cryptocurrency name (e.g. Bitcoin)
        symbol (str): Cryptocurrency abbreviation or symbol (e.g. BTC)
        quantity (float): Quantity (e.g. 0.0125662)
        sale_description (str): Description of property (1099-B box 1a)
        date_acquired (date): Date acquired (1099-B box 1b)
        various_dates_acquired (bool): Acquired on various dates (1099-B box
            1b)
        date_of_sale (date): Date sold or disposed (1099-B box 1c)
        sales_price (float): Proceeds (not price per share, 1099-B box 1d)
        cost_basis (float): Cost or other basis (1099-B box 1e)
        long_or_short (PositionType): LONG or SHORT (1099-B box 2)
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "cryptocurrency_name": 'cryptocurrencyName',
        "symbol": 'symbol',
        "quantity": 'quantity',
        "sale_description": 'saleDescription',
        "date_acquired": 'dateAcquired',
        "various_dates_acquired": 'variousDatesAcquired',
        "date_of_sale": 'dateOfSale',
        "sales_price": 'salesPrice',
        "cost_basis": 'costBasis',
        "long_or_short": 'longOrShort'
    }

    _optionals = [
        'cryptocurrency_name',
        'symbol',
        'quantity',
        'sale_description',
        'date_acquired',
        'various_dates_acquired',
        'date_of_sale',
        'sales_price',
        'cost_basis',
        'long_or_short',
    ]

    def __init__(self,
                 cryptocurrency_name=APIHelper.SKIP,
                 symbol=APIHelper.SKIP,
                 quantity=APIHelper.SKIP,
                 sale_description=APIHelper.SKIP,
                 date_acquired=APIHelper.SKIP,
                 various_dates_acquired=APIHelper.SKIP,
                 date_of_sale=APIHelper.SKIP,
                 sales_price=APIHelper.SKIP,
                 cost_basis=APIHelper.SKIP,
                 long_or_short=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the GainOrLossFromCryptocurrencyTransaction class"""

        # Initialize members of the class
        if cryptocurrency_name is not APIHelper.SKIP:
            self.cryptocurrency_name = cryptocurrency_name 
        if symbol is not APIHelper.SKIP:
            self.symbol = symbol 
        if quantity is not APIHelper.SKIP:
            self.quantity = quantity 
        if sale_description is not APIHelper.SKIP:
            self.sale_description = sale_description 
        if date_acquired is not APIHelper.SKIP:
            self.date_acquired = date_acquired 
        if various_dates_acquired is not APIHelper.SKIP:
            self.various_dates_acquired = various_dates_acquired 
        if date_of_sale is not APIHelper.SKIP:
            self.date_of_sale = date_of_sale 
        if sales_price is not APIHelper.SKIP:
            self.sales_price = sales_price 
        if cost_basis is not APIHelper.SKIP:
            self.cost_basis = cost_basis 
        if long_or_short is not APIHelper.SKIP:
            self.long_or_short = long_or_short 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        cryptocurrency_name = dictionary.get("cryptocurrencyName") if dictionary.get("cryptocurrencyName") else APIHelper.SKIP
        symbol = dictionary.get("symbol") if dictionary.get("symbol") else APIHelper.SKIP
        quantity = dictionary.get("quantity") if dictionary.get("quantity") else APIHelper.SKIP
        sale_description = dictionary.get("saleDescription") if dictionary.get("saleDescription") else APIHelper.SKIP
        date_acquired = dateutil.parser.parse(dictionary.get('dateAcquired')).date() if dictionary.get('dateAcquired') else APIHelper.SKIP
        various_dates_acquired = dictionary.get("variousDatesAcquired") if "variousDatesAcquired" in dictionary.keys() else APIHelper.SKIP
        date_of_sale = dateutil.parser.parse(dictionary.get('dateOfSale')).date() if dictionary.get('dateOfSale') else APIHelper.SKIP
        sales_price = dictionary.get("salesPrice") if dictionary.get("salesPrice") else APIHelper.SKIP
        cost_basis = dictionary.get("costBasis") if dictionary.get("costBasis") else APIHelper.SKIP
        long_or_short = dictionary.get("longOrShort") if dictionary.get("longOrShort") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(cryptocurrency_name,
                   symbol,
                   quantity,
                   sale_description,
                   date_acquired,
                   various_dates_acquired,
                   date_of_sale,
                   sales_price,
                   cost_basis,
                   long_or_short,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'cryptocurrency_name={(self.cryptocurrency_name if hasattr(self, "cryptocurrency_name") else None)!r}, '
                f'symbol={(self.symbol if hasattr(self, "symbol") else None)!r}, '
                f'quantity={(self.quantity if hasattr(self, "quantity") else None)!r}, '
                f'sale_description={(self.sale_description if hasattr(self, "sale_description") else None)!r}, '
                f'date_acquired={(self.date_acquired if hasattr(self, "date_acquired") else None)!r}, '
                f'various_dates_acquired={(self.various_dates_acquired if hasattr(self, "various_dates_acquired") else None)!r}, '
                f'date_of_sale={(self.date_of_sale if hasattr(self, "date_of_sale") else None)!r}, '
                f'sales_price={(self.sales_price if hasattr(self, "sales_price") else None)!r}, '
                f'cost_basis={(self.cost_basis if hasattr(self, "cost_basis") else None)!r}, '
                f'long_or_short={(self.long_or_short if hasattr(self, "long_or_short") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'cryptocurrency_name={(self.cryptocurrency_name if hasattr(self, "cryptocurrency_name") else None)!s}, '
                f'symbol={(self.symbol if hasattr(self, "symbol") else None)!s}, '
                f'quantity={(self.quantity if hasattr(self, "quantity") else None)!s}, '
                f'sale_description={(self.sale_description if hasattr(self, "sale_description") else None)!s}, '
                f'date_acquired={(self.date_acquired if hasattr(self, "date_acquired") else None)!s}, '
                f'various_dates_acquired={(self.various_dates_acquired if hasattr(self, "various_dates_acquired") else None)!s}, '
                f'date_of_sale={(self.date_of_sale if hasattr(self, "date_of_sale") else None)!s}, '
                f'sales_price={(self.sales_price if hasattr(self, "sales_price") else None)!s}, '
                f'cost_basis={(self.cost_basis if hasattr(self, "cost_basis") else None)!s}, '
                f'long_or_short={(self.long_or_short if hasattr(self, "long_or_short") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
