# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class GovernmentIssuedPartyIdentificationEntity(object):

    """Implementation of the 'Government Issued Party Identification entity' model.

    Government issued identification document that is used to uniquely
    identify a person or business

    Attributes:
        id_number (str): Identification number
        issued_date (str): Issued date
        expiry_date (str): Expiry date
        mtype (GovernmentIssuedIdType2): Type of the identification
        issuing_country_name (str): Name of the issuing country
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "id_number": 'idNumber',
        "issued_date": 'issuedDate',
        "expiry_date": 'expiryDate',
        "mtype": 'type',
        "issuing_country_name": 'issuingCountryName'
    }

    _optionals = [
        'id_number',
        'issued_date',
        'expiry_date',
        'mtype',
        'issuing_country_name',
    ]

    def __init__(self,
                 id_number=APIHelper.SKIP,
                 issued_date=APIHelper.SKIP,
                 expiry_date=APIHelper.SKIP,
                 mtype=APIHelper.SKIP,
                 issuing_country_name=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the GovernmentIssuedPartyIdentificationEntity class"""

        # Initialize members of the class
        if id_number is not APIHelper.SKIP:
            self.id_number = id_number 
        if issued_date is not APIHelper.SKIP:
            self.issued_date = issued_date 
        if expiry_date is not APIHelper.SKIP:
            self.expiry_date = expiry_date 
        if mtype is not APIHelper.SKIP:
            self.mtype = mtype 
        if issuing_country_name is not APIHelper.SKIP:
            self.issuing_country_name = issuing_country_name 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        id_number = dictionary.get("idNumber") if dictionary.get("idNumber") else APIHelper.SKIP
        issued_date = dictionary.get("issuedDate") if dictionary.get("issuedDate") else APIHelper.SKIP
        expiry_date = dictionary.get("expiryDate") if dictionary.get("expiryDate") else APIHelper.SKIP
        mtype = dictionary.get("type") if dictionary.get("type") else APIHelper.SKIP
        issuing_country_name = dictionary.get("issuingCountryName") if dictionary.get("issuingCountryName") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(id_number,
                   issued_date,
                   expiry_date,
                   mtype,
                   issuing_country_name,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'id_number={(self.id_number if hasattr(self, "id_number") else None)!r}, '
                f'issued_date={(self.issued_date if hasattr(self, "issued_date") else None)!r}, '
                f'expiry_date={(self.expiry_date if hasattr(self, "expiry_date") else None)!r}, '
                f'mtype={(self.mtype if hasattr(self, "mtype") else None)!r}, '
                f'issuing_country_name={(self.issuing_country_name if hasattr(self, "issuing_country_name") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'id_number={(self.id_number if hasattr(self, "id_number") else None)!s}, '
                f'issued_date={(self.issued_date if hasattr(self, "issued_date") else None)!s}, '
                f'expiry_date={(self.expiry_date if hasattr(self, "expiry_date") else None)!s}, '
                f'mtype={(self.mtype if hasattr(self, "mtype") else None)!s}, '
                f'issuing_country_name={(self.issuing_country_name if hasattr(self, "issuing_country_name") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
