# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class HealthInsuranceCoverage(object):

    """Implementation of the 'Health Insurance Coverage' model.

    Used on Form 1095-A Part III

    Attributes:
        enrollment_premium (float): Monthly enrollment premiums
        slcsp_premium (float): Monthly second lowest cost silver plan (SLCSP)
            premium
        advance_premium_tax_credit_payment (float): Monthly advance payment of
            premium tax credit
        month (CoverageMonth3): Month of coverage
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "enrollment_premium": 'enrollmentPremium',
        "slcsp_premium": 'slcspPremium',
        "advance_premium_tax_credit_payment": 'advancePremiumTaxCreditPayment',
        "month": 'month'
    }

    _optionals = [
        'enrollment_premium',
        'slcsp_premium',
        'advance_premium_tax_credit_payment',
        'month',
    ]

    def __init__(self,
                 enrollment_premium=APIHelper.SKIP,
                 slcsp_premium=APIHelper.SKIP,
                 advance_premium_tax_credit_payment=APIHelper.SKIP,
                 month=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the HealthInsuranceCoverage class"""

        # Initialize members of the class
        if enrollment_premium is not APIHelper.SKIP:
            self.enrollment_premium = enrollment_premium 
        if slcsp_premium is not APIHelper.SKIP:
            self.slcsp_premium = slcsp_premium 
        if advance_premium_tax_credit_payment is not APIHelper.SKIP:
            self.advance_premium_tax_credit_payment = advance_premium_tax_credit_payment 
        if month is not APIHelper.SKIP:
            self.month = month 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        enrollment_premium = dictionary.get("enrollmentPremium") if dictionary.get("enrollmentPremium") else APIHelper.SKIP
        slcsp_premium = dictionary.get("slcspPremium") if dictionary.get("slcspPremium") else APIHelper.SKIP
        advance_premium_tax_credit_payment = dictionary.get("advancePremiumTaxCreditPayment") if dictionary.get("advancePremiumTaxCreditPayment") else APIHelper.SKIP
        month = dictionary.get("month") if dictionary.get("month") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(enrollment_premium,
                   slcsp_premium,
                   advance_premium_tax_credit_payment,
                   month,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'enrollment_premium={(self.enrollment_premium if hasattr(self, "enrollment_premium") else None)!r}, '
                f'slcsp_premium={(self.slcsp_premium if hasattr(self, "slcsp_premium") else None)!r}, '
                f'advance_premium_tax_credit_payment={(self.advance_premium_tax_credit_payment if hasattr(self, "advance_premium_tax_credit_payment") else None)!r}, '
                f'month={(self.month if hasattr(self, "month") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'enrollment_premium={(self.enrollment_premium if hasattr(self, "enrollment_premium") else None)!s}, '
                f'slcsp_premium={(self.slcsp_premium if hasattr(self, "slcsp_premium") else None)!s}, '
                f'advance_premium_tax_credit_payment={(self.advance_premium_tax_credit_payment if hasattr(self, "advance_premium_tax_credit_payment") else None)!s}, '
                f'month={(self.month if hasattr(self, "month") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
