# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper


class HealthInsuranceMarketplaceCoveredIndividual(object):

    """Implementation of the 'Health Insurance Marketplace Covered Individual' model.

    Used on Form 1095-A Part II

    Attributes:
        name (str): Covered individual name
        tin (str): Covered individual SSN
        date_of_birth (date): Covered individual date of birth
        policy_start_date (date): Coverage start date
        policy_termination_date (date): Coverage termination date
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "name": 'name',
        "tin": 'tin',
        "date_of_birth": 'dateOfBirth',
        "policy_start_date": 'policyStartDate',
        "policy_termination_date": 'policyTerminationDate'
    }

    _optionals = [
        'name',
        'tin',
        'date_of_birth',
        'policy_start_date',
        'policy_termination_date',
    ]

    def __init__(self,
                 name=APIHelper.SKIP,
                 tin=APIHelper.SKIP,
                 date_of_birth=APIHelper.SKIP,
                 policy_start_date=APIHelper.SKIP,
                 policy_termination_date=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the HealthInsuranceMarketplaceCoveredIndividual class"""

        # Initialize members of the class
        if name is not APIHelper.SKIP:
            self.name = name 
        if tin is not APIHelper.SKIP:
            self.tin = tin 
        if date_of_birth is not APIHelper.SKIP:
            self.date_of_birth = date_of_birth 
        if policy_start_date is not APIHelper.SKIP:
            self.policy_start_date = policy_start_date 
        if policy_termination_date is not APIHelper.SKIP:
            self.policy_termination_date = policy_termination_date 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        name = dictionary.get("name") if dictionary.get("name") else APIHelper.SKIP
        tin = dictionary.get("tin") if dictionary.get("tin") else APIHelper.SKIP
        date_of_birth = dateutil.parser.parse(dictionary.get('dateOfBirth')).date() if dictionary.get('dateOfBirth') else APIHelper.SKIP
        policy_start_date = dateutil.parser.parse(dictionary.get('policyStartDate')).date() if dictionary.get('policyStartDate') else APIHelper.SKIP
        policy_termination_date = dateutil.parser.parse(dictionary.get('policyTerminationDate')).date() if dictionary.get('policyTerminationDate') else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(name,
                   tin,
                   date_of_birth,
                   policy_start_date,
                   policy_termination_date,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'name={(self.name if hasattr(self, "name") else None)!r}, '
                f'tin={(self.tin if hasattr(self, "tin") else None)!r}, '
                f'date_of_birth={(self.date_of_birth if hasattr(self, "date_of_birth") else None)!r}, '
                f'policy_start_date={(self.policy_start_date if hasattr(self, "policy_start_date") else None)!r}, '
                f'policy_termination_date={(self.policy_termination_date if hasattr(self, "policy_termination_date") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'name={(self.name if hasattr(self, "name") else None)!s}, '
                f'tin={(self.tin if hasattr(self, "tin") else None)!s}, '
                f'date_of_birth={(self.date_of_birth if hasattr(self, "date_of_birth") else None)!s}, '
                f'policy_start_date={(self.policy_start_date if hasattr(self, "policy_start_date") else None)!s}, '
                f'policy_termination_date={(self.policy_termination_date if hasattr(self, "policy_termination_date") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
