# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""


class HoldingType(object):

    """Implementation of the 'Holding Type' enum.

    The type of an investment holding
      | Value | Description |
      |-----|-----|
      | ANNUITY | Financial product that pays out a fixed stream of payments |
      | BOND | Debt security as a loan to a government, agency or company,
    repaid with interest |
      | CD | Certificate of Deposit, a savings account with a fixed rate and
    term |
      | DIGITALASSET | Digital representation of an asset or right that is
    stored and transferred on a digital network such as the internet or a
    blockchain |
      | MUTUALFUND | Pooled collection of assets invested in stocks, bonds,
    and other securities |
      | OPTION | The right to buy a specific number of stock shares at a
    pre-set price |
      | OTHER | Another type of holding not listed here |
      | STOCK | A share in the ownership of a company |

    Attributes:
        ANNUITY: The enum member of type str.
        BOND: The enum member of type str.
        CD: The enum member of type str.
        DIGITALASSET: The enum member of type str.
        MUTUALFUND: The enum member of type str.
        OPTION: The enum member of type str.
        OTHER: The enum member of type str.
        STOCK: The enum member of type str.
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """
    ANNUITY = 'ANNUITY'

    BOND = 'BOND'

    CD = 'CD'

    DIGITALASSET = 'DIGITALASSET'

    MUTUALFUND = 'MUTUALFUND'

    OPTION = 'OPTION'

    OTHER = 'OTHER'

    STOCK = 'STOCK'

    @classmethod
    def validate(cls, value):
        """Validates value contains in enum

        Args:
            value: the value to be validated

        Returns:
            boolean : if value is valid enum values.

        """
        return True if value else False 
