# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.base_payroll_rate_1 import BasePayrollRate1
from fdxapi.models.payment_amounts_1 import PaymentAmounts1


class Income(object):

    """Implementation of the 'Income' model.

    Provides a person's employment income details. Applicable only for VOIE
    (Verification of Income and Employment) data retrieval

    Attributes:
        base_rate (BasePayrollRate1): The employee's base payroll rate
        payroll_frequency (PayrollFrequencyType2): The frequency of payments
        latest_pay_date (date): The date of employee's most recent pay
        latest_pay_period_end_date (date): The end date of employee's most
            recent pay period
        annual_pay (PaymentAmounts1): Year-to-date pay for current year and
            total annual pay for previous years
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "payroll_frequency": 'payrollFrequency',
        "base_rate": 'baseRate',
        "latest_pay_date": 'latestPayDate',
        "latest_pay_period_end_date": 'latestPayPeriodEndDate',
        "annual_pay": 'annualPay'
    }

    _optionals = [
        'base_rate',
        'latest_pay_date',
        'latest_pay_period_end_date',
        'annual_pay',
    ]

    def __init__(self,
                 payroll_frequency=None,
                 base_rate=APIHelper.SKIP,
                 latest_pay_date=APIHelper.SKIP,
                 latest_pay_period_end_date=APIHelper.SKIP,
                 annual_pay=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the Income class"""

        # Initialize members of the class
        if base_rate is not APIHelper.SKIP:
            self.base_rate = base_rate 
        self.payroll_frequency = payroll_frequency 
        if latest_pay_date is not APIHelper.SKIP:
            self.latest_pay_date = latest_pay_date 
        if latest_pay_period_end_date is not APIHelper.SKIP:
            self.latest_pay_period_end_date = latest_pay_period_end_date 
        if annual_pay is not APIHelper.SKIP:
            self.annual_pay = annual_pay 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        payroll_frequency = dictionary.get("payrollFrequency") if dictionary.get("payrollFrequency") else None
        base_rate = BasePayrollRate1.from_dictionary(dictionary.get('baseRate')) if 'baseRate' in dictionary.keys() else APIHelper.SKIP
        latest_pay_date = dateutil.parser.parse(dictionary.get('latestPayDate')).date() if dictionary.get('latestPayDate') else APIHelper.SKIP
        latest_pay_period_end_date = dateutil.parser.parse(dictionary.get('latestPayPeriodEndDate')).date() if dictionary.get('latestPayPeriodEndDate') else APIHelper.SKIP
        annual_pay = PaymentAmounts1.from_dictionary(dictionary.get('annualPay')) if 'annualPay' in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(payroll_frequency,
                   base_rate,
                   latest_pay_date,
                   latest_pay_period_end_date,
                   annual_pay,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'base_rate={(self.base_rate if hasattr(self, "base_rate") else None)!r}, '
                f'payroll_frequency={self.payroll_frequency!r}, '
                f'latest_pay_date={(self.latest_pay_date if hasattr(self, "latest_pay_date") else None)!r}, '
                f'latest_pay_period_end_date={(self.latest_pay_period_end_date if hasattr(self, "latest_pay_period_end_date") else None)!r}, '
                f'annual_pay={(self.annual_pay if hasattr(self, "annual_pay") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'base_rate={(self.base_rate if hasattr(self, "base_rate") else None)!s}, '
                f'payroll_frequency={self.payroll_frequency!s}, '
                f'latest_pay_date={(self.latest_pay_date if hasattr(self, "latest_pay_date") else None)!s}, '
                f'latest_pay_period_end_date={(self.latest_pay_period_end_date if hasattr(self, "latest_pay_period_end_date") else None)!s}, '
                f'annual_pay={(self.annual_pay if hasattr(self, "annual_pay") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
