# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.time_and_occurrence_based_transfer_limits_1 import TimeAndOccurrenceBasedTransferLimits1
from fdxapi.models.time_and_occurrence_based_transfer_limits_3 import TimeAndOccurrenceBasedTransferLimits3


class IncomingAndOutgoingTransferLimits2(object):

    """Implementation of the 'Incoming and outgoing transfer limits2' model.

    The amount limits for transfers

    Attributes:
        out (TimeAndOccurrenceBasedTransferLimits3): Limits for outgoing
            transfers from the account
        min (TimeAndOccurrenceBasedTransferLimits1): Limits for incoming
            transfers to the account
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "out": 'out',
        "min": 'in'
    }

    _optionals = [
        'out',
        'min',
    ]

    def __init__(self,
                 out=APIHelper.SKIP,
                 min=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the IncomingAndOutgoingTransferLimits2 class"""

        # Initialize members of the class
        if out is not APIHelper.SKIP:
            self.out = out 
        if min is not APIHelper.SKIP:
            self.min = min 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        out = TimeAndOccurrenceBasedTransferLimits3.from_dictionary(dictionary.get('out')) if 'out' in dictionary.keys() else APIHelper.SKIP
        min = TimeAndOccurrenceBasedTransferLimits1.from_dictionary(dictionary.get('in')) if 'in' in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(out,
                   min,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'out={(self.out if hasattr(self, "out") else None)!r}, '
                f'min={(self.min if hasattr(self, "min") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'out={(self.out if hasattr(self, "out") else None)!s}, '
                f'min={(self.min if hasattr(self, "min") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
