# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.hateoas_link import HateoasLink


class LineItemEntity(object):

    """Implementation of the 'Line Item entity' model.

    A line item within a transaction

    Attributes:
        description (str): The description of the line item
        amount (float): The amount of money attributable to this line item
        check_number (int): Check number
        memo (str): Secondary item description
        reference (str): A reference number
        image_ids (List[str]): Array of image identifiers (unique to
            transaction) used to retrieve images of check or transaction
            receipt
        links (List[HateoasLink]): Links (unique to this Transaction) used to
            retrieve images of checks or transaction receipts, or invoke other
            APIs
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "description": 'description',
        "amount": 'amount',
        "check_number": 'checkNumber',
        "memo": 'memo',
        "reference": 'reference',
        "image_ids": 'imageIds',
        "links": 'links'
    }

    _optionals = [
        'description',
        'amount',
        'check_number',
        'memo',
        'reference',
        'image_ids',
        'links',
    ]

    def __init__(self,
                 description=APIHelper.SKIP,
                 amount=APIHelper.SKIP,
                 check_number=APIHelper.SKIP,
                 memo=APIHelper.SKIP,
                 reference=APIHelper.SKIP,
                 image_ids=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the LineItemEntity class"""

        # Initialize members of the class
        if description is not APIHelper.SKIP:
            self.description = description 
        if amount is not APIHelper.SKIP:
            self.amount = amount 
        if check_number is not APIHelper.SKIP:
            self.check_number = check_number 
        if memo is not APIHelper.SKIP:
            self.memo = memo 
        if reference is not APIHelper.SKIP:
            self.reference = reference 
        if image_ids is not APIHelper.SKIP:
            self.image_ids = image_ids 
        if links is not APIHelper.SKIP:
            self.links = links 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        amount = dictionary.get("amount") if dictionary.get("amount") else APIHelper.SKIP
        check_number = dictionary.get("checkNumber") if dictionary.get("checkNumber") else APIHelper.SKIP
        memo = dictionary.get("memo") if dictionary.get("memo") else APIHelper.SKIP
        reference = dictionary.get("reference") if dictionary.get("reference") else APIHelper.SKIP
        image_ids = dictionary.get("imageIds") if dictionary.get("imageIds") else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(description,
                   amount,
                   check_number,
                   memo,
                   reference,
                   image_ids,
                   links,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'description={(self.description if hasattr(self, "description") else None)!r}, '
                f'amount={(self.amount if hasattr(self, "amount") else None)!r}, '
                f'check_number={(self.check_number if hasattr(self, "check_number") else None)!r}, '
                f'memo={(self.memo if hasattr(self, "memo") else None)!r}, '
                f'reference={(self.reference if hasattr(self, "reference") else None)!r}, '
                f'image_ids={(self.image_ids if hasattr(self, "image_ids") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'description={(self.description if hasattr(self, "description") else None)!s}, '
                f'amount={(self.amount if hasattr(self, "amount") else None)!s}, '
                f'check_number={(self.check_number if hasattr(self, "check_number") else None)!s}, '
                f'memo={(self.memo if hasattr(self, "memo") else None)!s}, '
                f'reference={(self.reference if hasattr(self, "reference") else None)!s}, '
                f'image_ids={(self.image_ids if hasattr(self, "image_ids") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
