# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""


class LoanTransactionType(object):

    """Implementation of the 'Loan Transaction Type' enum.

    Defines the type of a loan transaction:
      * `ADJUSTMENT`: Adjustment or correction
      * `DOUBLE_UP_PAYMENT`: Additional payment beyond the required payment to
    reduce the principal
      * `FEE`: Fee charge. For example, a late payment fee
      * `INTEREST`: Interest charge
      * `LUMP_SUM_PAYMENT`: A single payment of money, as opposed to a series
    of payments made over time
      * `PAYMENT`: Required payment that satisfies the minimum payment (e.g.
    principal + interest for mortgages)
      * `PAYOFF`: Payment that satisfies the terms of the mortgage loan and
    completely pays off the debt
      * `SKIP_PAYMENT`: Payment that satisfies deferral of a required payment

    Attributes:
        ADJUSTMENT: The enum member of type str.
        DOUBLE_UP_PAYMENT: The enum member of type str.
        FEE: The enum member of type str.
        INTEREST: The enum member of type str.
        LUMP_SUM_PAYMENT: The enum member of type str.
        PAYMENT: The enum member of type str.
        PAYOFF: The enum member of type str.
        SKIP_PAYMENT: The enum member of type str.
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """
    ADJUSTMENT = 'ADJUSTMENT'

    DOUBLE_UP_PAYMENT = 'DOUBLE_UP_PAYMENT'

    FEE = 'FEE'

    INTEREST = 'INTEREST'

    LUMP_SUM_PAYMENT = 'LUMP_SUM_PAYMENT'

    PAYMENT = 'PAYMENT'

    PAYOFF = 'PAYOFF'

    SKIP_PAYMENT = 'SKIP_PAYMENT'

    @classmethod
    def validate(cls, value):
        """Validates value contains in enum

        Args:
            value: the value to be validated

        Returns:
            boolean : if value is valid enum values.

        """
        return True if value else False 
