# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.customer_name_entity import CustomerNameEntity
from fdxapi.models.delivery_address_1 import DeliveryAddress1
from fdxapi.models.telephone_number import TelephoneNumber


class MerchantForUpdateEntity(object):

    """Implementation of the 'Merchant For Update entity' model.

    Merchant's fields to be updated. Describes the fields that can be updated
    by the client. Supported fields could be server dependent

    Attributes:
        display_name (str): User defined name for the merchant. Used by the
            customer to identify the merchant. Not used by the system to
            process payments
        name (CustomerNameEntity): Name of the merchant used to execute the
            payment
        address (DeliveryAddress1): Address of the merchant used to execute
            the payment
        phone (TelephoneNumber): Phone number of the merchant used to execute
            the payment
        merchant_account_ids (List[str]): Account identifier(s) the customer
            has with the merchant
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "display_name": 'displayName',
        "name": 'name',
        "address": 'address',
        "phone": 'phone',
        "merchant_account_ids": 'merchantAccountIds'
    }

    _optionals = [
        'display_name',
        'name',
        'address',
        'phone',
        'merchant_account_ids',
    ]

    def __init__(self,
                 display_name=APIHelper.SKIP,
                 name=APIHelper.SKIP,
                 address=APIHelper.SKIP,
                 phone=APIHelper.SKIP,
                 merchant_account_ids=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the MerchantForUpdateEntity class"""

        # Initialize members of the class
        if display_name is not APIHelper.SKIP:
            self.display_name = display_name 
        if name is not APIHelper.SKIP:
            self.name = name 
        if address is not APIHelper.SKIP:
            self.address = address 
        if phone is not APIHelper.SKIP:
            self.phone = phone 
        if merchant_account_ids is not APIHelper.SKIP:
            self.merchant_account_ids = merchant_account_ids 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        display_name = dictionary.get("displayName") if dictionary.get("displayName") else APIHelper.SKIP
        name = CustomerNameEntity.from_dictionary(dictionary.get('name')) if 'name' in dictionary.keys() else APIHelper.SKIP
        address = DeliveryAddress1.from_dictionary(dictionary.get('address')) if 'address' in dictionary.keys() else APIHelper.SKIP
        phone = TelephoneNumber.from_dictionary(dictionary.get('phone')) if 'phone' in dictionary.keys() else APIHelper.SKIP
        merchant_account_ids = dictionary.get("merchantAccountIds") if dictionary.get("merchantAccountIds") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(display_name,
                   name,
                   address,
                   phone,
                   merchant_account_ids,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'display_name={(self.display_name if hasattr(self, "display_name") else None)!r}, '
                f'name={(self.name if hasattr(self, "name") else None)!r}, '
                f'address={(self.address if hasattr(self, "address") else None)!r}, '
                f'phone={(self.phone if hasattr(self, "phone") else None)!r}, '
                f'merchant_account_ids={(self.merchant_account_ids if hasattr(self, "merchant_account_ids") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'display_name={(self.display_name if hasattr(self, "display_name") else None)!s}, '
                f'name={(self.name if hasattr(self, "name") else None)!s}, '
                f'address={(self.address if hasattr(self, "address") else None)!s}, '
                f'phone={(self.phone if hasattr(self, "phone") else None)!s}, '
                f'merchant_account_ids={(self.merchant_account_ids if hasattr(self, "merchant_account_ids") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
