# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class MonetaryAmount4(object):

    """Implementation of the 'Monetary Amount4' model.

    Commission for covered period

    Attributes:
        amount (float): The monetary amount
        currency (Iso4217CurrencyCode): Currency code of the monetary amount
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "amount": 'amount',
        "currency": 'currency'
    }

    _optionals = [
        'currency',
    ]

    def __init__(self,
                 amount=None,
                 currency=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the MonetaryAmount4 class"""

        # Initialize members of the class
        self.amount = amount 
        if currency is not APIHelper.SKIP:
            self.currency = currency 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        amount = dictionary.get("amount") if dictionary.get("amount") else None
        currency = dictionary.get("currency") if dictionary.get("currency") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(amount,
                   currency,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'amount={self.amount!r}, '
                f'currency={(self.currency if hasattr(self, "currency") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'amount={self.amount!s}, '
                f'currency={(self.currency if hasattr(self, "currency") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
