# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class OccurrenceBasedLimitsForAPaymentNetwork2(object):

    """Implementation of the 'Occurrence based limits for a Payment Network2' model.

    The transfer limits taking effect from all the timeframe limits

    Attributes:
        transfer_max_amount (float): Maximum limit of funds that can be
            transferred to/from the account using the timeframe limits
        transfer_remaining_amount (float): Remaining value of the maximum
            limit of funds that can be transferred to/from the account using
            the timeframe limits
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "transfer_max_amount": 'transferMaxAmount',
        "transfer_remaining_amount": 'transferRemainingAmount'
    }

    _optionals = [
        'transfer_max_amount',
        'transfer_remaining_amount',
    ]

    def __init__(self,
                 transfer_max_amount=APIHelper.SKIP,
                 transfer_remaining_amount=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the OccurrenceBasedLimitsForAPaymentNetwork2 class"""

        # Initialize members of the class
        if transfer_max_amount is not APIHelper.SKIP:
            self.transfer_max_amount = transfer_max_amount 
        if transfer_remaining_amount is not APIHelper.SKIP:
            self.transfer_remaining_amount = transfer_remaining_amount 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        transfer_max_amount = dictionary.get("transferMaxAmount") if dictionary.get("transferMaxAmount") else APIHelper.SKIP
        transfer_remaining_amount = dictionary.get("transferRemainingAmount") if dictionary.get("transferRemainingAmount") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(transfer_max_amount,
                   transfer_remaining_amount,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'transfer_max_amount={(self.transfer_max_amount if hasattr(self, "transfer_max_amount") else None)!r}, '
                f'transfer_remaining_amount={(self.transfer_remaining_amount if hasattr(self, "transfer_remaining_amount") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'transfer_max_amount={(self.transfer_max_amount if hasattr(self, "transfer_max_amount") else None)!s}, '
                f'transfer_remaining_amount={(self.transfer_remaining_amount if hasattr(self, "transfer_remaining_amount") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
