# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class OfferOfHealthInsuranceCoverage(object):

    """Implementation of the 'Offer of Health Insurance Coverage' model.

    Health insurance coverage offer for part II of IRS Form 1095-C

    Attributes:
        coverage_code (str): Offer of Coverage (enter required code)
        required_contribution (float): Employee required contribution
        section_4980_h_code (str): Section 4980H Safe Harbor and Other Relief
            (enter code)
        postal_code (str): Box 17, ZIP Code
        month (CoverageMonth1): Month
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "coverage_code": 'coverageCode',
        "required_contribution": 'requiredContribution',
        "section_4980_h_code": 'section4980HCode',
        "postal_code": 'postalCode',
        "month": 'month'
    }

    _optionals = [
        'coverage_code',
        'required_contribution',
        'section_4980_h_code',
        'postal_code',
        'month',
    ]

    def __init__(self,
                 coverage_code=APIHelper.SKIP,
                 required_contribution=APIHelper.SKIP,
                 section_4980_h_code=APIHelper.SKIP,
                 postal_code=APIHelper.SKIP,
                 month=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the OfferOfHealthInsuranceCoverage class"""

        # Initialize members of the class
        if coverage_code is not APIHelper.SKIP:
            self.coverage_code = coverage_code 
        if required_contribution is not APIHelper.SKIP:
            self.required_contribution = required_contribution 
        if section_4980_h_code is not APIHelper.SKIP:
            self.section_4980_h_code = section_4980_h_code 
        if postal_code is not APIHelper.SKIP:
            self.postal_code = postal_code 
        if month is not APIHelper.SKIP:
            self.month = month 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        coverage_code = dictionary.get("coverageCode") if dictionary.get("coverageCode") else APIHelper.SKIP
        required_contribution = dictionary.get("requiredContribution") if dictionary.get("requiredContribution") else APIHelper.SKIP
        section_4980_h_code = dictionary.get("section4980HCode") if dictionary.get("section4980HCode") else APIHelper.SKIP
        postal_code = dictionary.get("postalCode") if dictionary.get("postalCode") else APIHelper.SKIP
        month = dictionary.get("month") if dictionary.get("month") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(coverage_code,
                   required_contribution,
                   section_4980_h_code,
                   postal_code,
                   month,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'coverage_code={(self.coverage_code if hasattr(self, "coverage_code") else None)!r}, '
                f'required_contribution={(self.required_contribution if hasattr(self, "required_contribution") else None)!r}, '
                f'section_4980_h_code={(self.section_4980_h_code if hasattr(self, "section_4980_h_code") else None)!r}, '
                f'postal_code={(self.postal_code if hasattr(self, "postal_code") else None)!r}, '
                f'month={(self.month if hasattr(self, "month") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'coverage_code={(self.coverage_code if hasattr(self, "coverage_code") else None)!s}, '
                f'required_contribution={(self.required_contribution if hasattr(self, "required_contribution") else None)!s}, '
                f'section_4980_h_code={(self.section_4980_h_code if hasattr(self, "section_4980_h_code") else None)!s}, '
                f'postal_code={(self.postal_code if hasattr(self, "postal_code") else None)!s}, '
                f'month={(self.month if hasattr(self, "month") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
