# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper


class OpenOrderEntity(object):

    """Implementation of the 'Open Order entity' model.

    An open investment transaction order

    Attributes:
        order_id (str): Long-term persistent identity of the order. Id for
            this order transaction
        security_id (str): Unique identifier of security
        security_id_type (SecurityIdType1): CINS, CMC, CME, CUSIP, ISIN, ITSA,
            NASDAQ, SEDOL, SICC, VALOR, WKN
        symbol (str): Market symbol
        description (str): Description of order
        units (float): Number of units (shares or bonds etc.)
        order_type (OrderType2): Type of order. One of BUY, SELL, BUYTOCOVER,
            BUYTOOPEN, SELLTOCOVER, SELLTOOPEN,  SELLSHORT, SELLCLOSE
        order_date (date): Order date
        unit_price (float): Unit price
        unit_type (UnitType3): Type of unit. One of SHARES, CURRENCY
        order_duration (OrderDuration2): This order is good for DAY,
            GOODTILLCANCEL, IMMEDIATE
        sub_account (SubAccountType4): CASH, MARGIN, SHORT, OTHER
        limit_price (float): Limit price
        stop_price (float): Stop price
        inv_401_k_source (Investment401KSourceType1): For 401(k) accounts,
            source of money for this order. PRETAX, AFTERTAX, MATCH,
            PROFITSHARING, ROLLOVER, OTHERVEST, OTHERNONVEST. Default if not
            present is OTHERNONVEST
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "order_id": 'orderId',
        "security_id": 'securityId',
        "security_id_type": 'securityIdType',
        "symbol": 'symbol',
        "description": 'description',
        "units": 'units',
        "order_type": 'orderType',
        "order_date": 'orderDate',
        "unit_price": 'unitPrice',
        "unit_type": 'unitType',
        "order_duration": 'orderDuration',
        "sub_account": 'subAccount',
        "limit_price": 'limitPrice',
        "stop_price": 'stopPrice',
        "inv_401_k_source": 'inv401kSource'
    }

    _optionals = [
        'order_id',
        'security_id',
        'security_id_type',
        'symbol',
        'description',
        'units',
        'order_type',
        'order_date',
        'unit_price',
        'unit_type',
        'order_duration',
        'sub_account',
        'limit_price',
        'stop_price',
        'inv_401_k_source',
    ]

    def __init__(self,
                 order_id=APIHelper.SKIP,
                 security_id=APIHelper.SKIP,
                 security_id_type=APIHelper.SKIP,
                 symbol=APIHelper.SKIP,
                 description=APIHelper.SKIP,
                 units=APIHelper.SKIP,
                 order_type=APIHelper.SKIP,
                 order_date=APIHelper.SKIP,
                 unit_price=APIHelper.SKIP,
                 unit_type=APIHelper.SKIP,
                 order_duration=APIHelper.SKIP,
                 sub_account=APIHelper.SKIP,
                 limit_price=APIHelper.SKIP,
                 stop_price=APIHelper.SKIP,
                 inv_401_k_source=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the OpenOrderEntity class"""

        # Initialize members of the class
        if order_id is not APIHelper.SKIP:
            self.order_id = order_id 
        if security_id is not APIHelper.SKIP:
            self.security_id = security_id 
        if security_id_type is not APIHelper.SKIP:
            self.security_id_type = security_id_type 
        if symbol is not APIHelper.SKIP:
            self.symbol = symbol 
        if description is not APIHelper.SKIP:
            self.description = description 
        if units is not APIHelper.SKIP:
            self.units = units 
        if order_type is not APIHelper.SKIP:
            self.order_type = order_type 
        if order_date is not APIHelper.SKIP:
            self.order_date = order_date 
        if unit_price is not APIHelper.SKIP:
            self.unit_price = unit_price 
        if unit_type is not APIHelper.SKIP:
            self.unit_type = unit_type 
        if order_duration is not APIHelper.SKIP:
            self.order_duration = order_duration 
        if sub_account is not APIHelper.SKIP:
            self.sub_account = sub_account 
        if limit_price is not APIHelper.SKIP:
            self.limit_price = limit_price 
        if stop_price is not APIHelper.SKIP:
            self.stop_price = stop_price 
        if inv_401_k_source is not APIHelper.SKIP:
            self.inv_401_k_source = inv_401_k_source 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        order_id = dictionary.get("orderId") if dictionary.get("orderId") else APIHelper.SKIP
        security_id = dictionary.get("securityId") if dictionary.get("securityId") else APIHelper.SKIP
        security_id_type = dictionary.get("securityIdType") if dictionary.get("securityIdType") else APIHelper.SKIP
        symbol = dictionary.get("symbol") if dictionary.get("symbol") else APIHelper.SKIP
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        units = dictionary.get("units") if dictionary.get("units") else APIHelper.SKIP
        order_type = dictionary.get("orderType") if dictionary.get("orderType") else APIHelper.SKIP
        order_date = dateutil.parser.parse(dictionary.get('orderDate')).date() if dictionary.get('orderDate') else APIHelper.SKIP
        unit_price = dictionary.get("unitPrice") if dictionary.get("unitPrice") else APIHelper.SKIP
        unit_type = dictionary.get("unitType") if dictionary.get("unitType") else APIHelper.SKIP
        order_duration = dictionary.get("orderDuration") if dictionary.get("orderDuration") else APIHelper.SKIP
        sub_account = dictionary.get("subAccount") if dictionary.get("subAccount") else APIHelper.SKIP
        limit_price = dictionary.get("limitPrice") if dictionary.get("limitPrice") else APIHelper.SKIP
        stop_price = dictionary.get("stopPrice") if dictionary.get("stopPrice") else APIHelper.SKIP
        inv_401_k_source = dictionary.get("inv401kSource") if dictionary.get("inv401kSource") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(order_id,
                   security_id,
                   security_id_type,
                   symbol,
                   description,
                   units,
                   order_type,
                   order_date,
                   unit_price,
                   unit_type,
                   order_duration,
                   sub_account,
                   limit_price,
                   stop_price,
                   inv_401_k_source,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'order_id={(self.order_id if hasattr(self, "order_id") else None)!r}, '
                f'security_id={(self.security_id if hasattr(self, "security_id") else None)!r}, '
                f'security_id_type={(self.security_id_type if hasattr(self, "security_id_type") else None)!r}, '
                f'symbol={(self.symbol if hasattr(self, "symbol") else None)!r}, '
                f'description={(self.description if hasattr(self, "description") else None)!r}, '
                f'units={(self.units if hasattr(self, "units") else None)!r}, '
                f'order_type={(self.order_type if hasattr(self, "order_type") else None)!r}, '
                f'order_date={(self.order_date if hasattr(self, "order_date") else None)!r}, '
                f'unit_price={(self.unit_price if hasattr(self, "unit_price") else None)!r}, '
                f'unit_type={(self.unit_type if hasattr(self, "unit_type") else None)!r}, '
                f'order_duration={(self.order_duration if hasattr(self, "order_duration") else None)!r}, '
                f'sub_account={(self.sub_account if hasattr(self, "sub_account") else None)!r}, '
                f'limit_price={(self.limit_price if hasattr(self, "limit_price") else None)!r}, '
                f'stop_price={(self.stop_price if hasattr(self, "stop_price") else None)!r}, '
                f'inv_401_k_source={(self.inv_401_k_source if hasattr(self, "inv_401_k_source") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'order_id={(self.order_id if hasattr(self, "order_id") else None)!s}, '
                f'security_id={(self.security_id if hasattr(self, "security_id") else None)!s}, '
                f'security_id_type={(self.security_id_type if hasattr(self, "security_id_type") else None)!s}, '
                f'symbol={(self.symbol if hasattr(self, "symbol") else None)!s}, '
                f'description={(self.description if hasattr(self, "description") else None)!s}, '
                f'units={(self.units if hasattr(self, "units") else None)!s}, '
                f'order_type={(self.order_type if hasattr(self, "order_type") else None)!s}, '
                f'order_date={(self.order_date if hasattr(self, "order_date") else None)!s}, '
                f'unit_price={(self.unit_price if hasattr(self, "unit_price") else None)!s}, '
                f'unit_type={(self.unit_type if hasattr(self, "unit_type") else None)!s}, '
                f'order_duration={(self.order_duration if hasattr(self, "order_duration") else None)!s}, '
                f'sub_account={(self.sub_account if hasattr(self, "sub_account") else None)!s}, '
                f'limit_price={(self.limit_price if hasattr(self, "limit_price") else None)!s}, '
                f'stop_price={(self.stop_price if hasattr(self, "stop_price") else None)!s}, '
                f'inv_401_k_source={(self.inv_401_k_source if hasattr(self, "inv_401_k_source") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
