# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.hateoas_link import HateoasLink


class PageMetadataLinks1(object):

    """Implementation of the 'Page Metadata Links1' model.

    Links used to paginate results

    Attributes:
        next (HateoasLink): Resource URL for retrieving next dataset
        prev (HateoasLink): Resource URL for retrieving previous dataset
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "next": 'next',
        "prev": 'prev'
    }

    _optionals = [
        'next',
        'prev',
    ]

    def __init__(self,
                 next=APIHelper.SKIP,
                 prev=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the PageMetadataLinks1 class"""

        # Initialize members of the class
        if next is not APIHelper.SKIP:
            self.next = next 
        if prev is not APIHelper.SKIP:
            self.prev = prev 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        next = HateoasLink.from_dictionary(dictionary.get('next')) if 'next' in dictionary.keys() else APIHelper.SKIP
        prev = HateoasLink.from_dictionary(dictionary.get('prev')) if 'prev' in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(next,
                   prev,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'next={(self.next if hasattr(self, "next") else None)!r}, '
                f'prev={(self.prev if hasattr(self, "prev") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'next={(self.next if hasattr(self, "next") else None)!s}, '
                f'prev={(self.prev if hasattr(self, "prev") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
