# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class PartyEntity(object):

    """Implementation of the 'Party entity' model.

    FDX Participant - an entity or person that is a part of a FDX API
    transaction

    Attributes:
        name (str): Human recognizable common name
        mtype (PartyType): Extensible string enum identifying the type of the
            party
        home_uri (str): URI for party, where an end user could learn more
            about the company or application involved in the data sharing chain
        logo_uri (str): URI for a logo asset to be displayed to the end user
        registry (Registry): The registry containing the party's registration
            with name and id: FDX, GLEIF, ICANN, PRIVATE
        registered_entity_name (str): Registered name of party
        registered_entity_id (str): Registered id of party
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "name": 'name',
        "mtype": 'type',
        "home_uri": 'homeUri',
        "logo_uri": 'logoUri',
        "registry": 'registry',
        "registered_entity_name": 'registeredEntityName',
        "registered_entity_id": 'registeredEntityId'
    }

    _optionals = [
        'home_uri',
        'logo_uri',
        'registry',
        'registered_entity_name',
        'registered_entity_id',
    ]

    def __init__(self,
                 name=None,
                 mtype=None,
                 home_uri=APIHelper.SKIP,
                 logo_uri=APIHelper.SKIP,
                 registry=APIHelper.SKIP,
                 registered_entity_name=APIHelper.SKIP,
                 registered_entity_id=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the PartyEntity class"""

        # Initialize members of the class
        self.name = name 
        self.mtype = mtype 
        if home_uri is not APIHelper.SKIP:
            self.home_uri = home_uri 
        if logo_uri is not APIHelper.SKIP:
            self.logo_uri = logo_uri 
        if registry is not APIHelper.SKIP:
            self.registry = registry 
        if registered_entity_name is not APIHelper.SKIP:
            self.registered_entity_name = registered_entity_name 
        if registered_entity_id is not APIHelper.SKIP:
            self.registered_entity_id = registered_entity_id 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        name = dictionary.get("name") if dictionary.get("name") else None
        mtype = dictionary.get("type") if dictionary.get("type") else None
        home_uri = dictionary.get("homeUri") if dictionary.get("homeUri") else APIHelper.SKIP
        logo_uri = dictionary.get("logoUri") if dictionary.get("logoUri") else APIHelper.SKIP
        registry = dictionary.get("registry") if dictionary.get("registry") else APIHelper.SKIP
        registered_entity_name = dictionary.get("registeredEntityName") if dictionary.get("registeredEntityName") else APIHelper.SKIP
        registered_entity_id = dictionary.get("registeredEntityId") if dictionary.get("registeredEntityId") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(name,
                   mtype,
                   home_uri,
                   logo_uri,
                   registry,
                   registered_entity_name,
                   registered_entity_id,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'name={self.name!r}, '
                f'mtype={self.mtype!r}, '
                f'home_uri={(self.home_uri if hasattr(self, "home_uri") else None)!r}, '
                f'logo_uri={(self.logo_uri if hasattr(self, "logo_uri") else None)!r}, '
                f'registry={(self.registry if hasattr(self, "registry") else None)!r}, '
                f'registered_entity_name={(self.registered_entity_name if hasattr(self, "registered_entity_name") else None)!r}, '
                f'registered_entity_id={(self.registered_entity_id if hasattr(self, "registered_entity_id") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'name={self.name!s}, '
                f'mtype={self.mtype!s}, '
                f'home_uri={(self.home_uri if hasattr(self, "home_uri") else None)!s}, '
                f'logo_uri={(self.logo_uri if hasattr(self, "logo_uri") else None)!s}, '
                f'registry={(self.registry if hasattr(self, "registry") else None)!s}, '
                f'registered_entity_name={(self.registered_entity_name if hasattr(self, "registered_entity_name") else None)!s}, '
                f'registered_entity_id={(self.registered_entity_id if hasattr(self, "registered_entity_id") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
