# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class PartyGroupEntity(object):

    """Implementation of the 'Party Group entity' model.

    Entity that allows payment initiation parties to be grouped using
    specific business rules. Each payment initiation party can belong to
    many groups.

    Attributes:
        group_id (str): Unique identifier of a group of payment initiation
            parties
        name (str): Associated name with the group of payment initiation
            parties
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "group_id": 'groupId',
        "name": 'name'
    }

    _optionals = [
        'group_id',
        'name',
    ]

    def __init__(self,
                 group_id=APIHelper.SKIP,
                 name=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the PartyGroupEntity class"""

        # Initialize members of the class
        if group_id is not APIHelper.SKIP:
            self.group_id = group_id 
        if name is not APIHelper.SKIP:
            self.name = name 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        group_id = dictionary.get("groupId") if dictionary.get("groupId") else APIHelper.SKIP
        name = dictionary.get("name") if dictionary.get("name") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(group_id,
                   name,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'group_id={(self.group_id if hasattr(self, "group_id") else None)!r}, '
                f'name={(self.name if hasattr(self, "name") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'group_id={(self.group_id if hasattr(self, "group_id") else None)!s}, '
                f'name={(self.name if hasattr(self, "name") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
