# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.merchant_for_update_entity_1 import MerchantForUpdateEntity1


class PayeeForUpdateEntity(object):

    """Implementation of the 'Payee For Update entity' model.

    Payee's fields to be updated

    Attributes:
        merchant (MerchantForUpdateEntity1): When payee is a merchant,
            typically a business from which goods or services are rendered,
            this field will be populated
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "merchant": 'merchant'
    }

    def __init__(self,
                 merchant=None,
                 additional_properties=None):
        """Constructor for the PayeeForUpdateEntity class"""

        # Initialize members of the class
        self.merchant = merchant 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        merchant = MerchantForUpdateEntity1.from_dictionary(dictionary.get('merchant')) if dictionary.get('merchant') else None
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(merchant,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'merchant={self.merchant!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'merchant={self.merchant!s}, '
                f'additional_properties={self.additional_properties!s})')
