# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.page_metadata import PageMetadata
from fdxapi.models.payee_entity import PayeeEntity
from fdxapi.models.synchronizable_array_links_entity_2 import SynchronizableArrayLinksEntity2
from fdxapi.models.updates_metadata_entity_2 import UpdatesMetadataEntity2


class PayeesEntity(object):

    """Implementation of the 'Payees entity' model.

    A list of payees

    Attributes:
        page (PageMetadata): Offset IDs for navigating result sets
        updates (UpdatesMetadataEntity2): Update IDs for retrieving updates
            since query
        links (SynchronizableArrayLinksEntity2): Resource URLs for navigating
            result sets
        payees (List[PayeeEntity]): Payees retrieved by the operation
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "payees": 'payees',
        "page": 'page',
        "updates": 'updates',
        "links": 'links'
    }

    _optionals = [
        'page',
        'updates',
        'links',
    ]

    def __init__(self,
                 payees=None,
                 page=APIHelper.SKIP,
                 updates=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the PayeesEntity class"""

        # Initialize members of the class
        if page is not APIHelper.SKIP:
            self.page = page 
        if updates is not APIHelper.SKIP:
            self.updates = updates 
        if links is not APIHelper.SKIP:
            self.links = links 
        self.payees = payees 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        payees = None
        if dictionary.get('payees') is not None:
            payees = [PayeeEntity.from_dictionary(x) for x in dictionary.get('payees')]
        page = PageMetadata.from_dictionary(dictionary.get('page')) if 'page' in dictionary.keys() else APIHelper.SKIP
        updates = UpdatesMetadataEntity2.from_dictionary(dictionary.get('updates')) if 'updates' in dictionary.keys() else APIHelper.SKIP
        links = SynchronizableArrayLinksEntity2.from_dictionary(dictionary.get('links')) if 'links' in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(payees,
                   page,
                   updates,
                   links,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'page={(self.page if hasattr(self, "page") else None)!r}, '
                f'updates={(self.updates if hasattr(self, "updates") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'payees={self.payees!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'page={(self.page if hasattr(self, "page") else None)!s}, '
                f'updates={(self.updates if hasattr(self, "updates") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'payees={self.payees!s}, '
                f'additional_properties={self.additional_properties!s})')
