# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.monetary_amount_1 import MonetaryAmount1
from fdxapi.models.monetary_amount_2 import MonetaryAmount2
from fdxapi.models.monetary_amount_3 import MonetaryAmount3
from fdxapi.models.monetary_amount_4 import MonetaryAmount4
from fdxapi.models.monetary_amount_5 import MonetaryAmount5
from fdxapi.models.other_monetary_amount import OtherMonetaryAmount


class PaymentAmounts(object):

    """Implementation of the 'Payment Amounts' model.

    Year to date amounts for current and previous years

    Attributes:
        total (MonetaryAmount1): Total gross pay for covered period
        base (MonetaryAmount2): Base pay part of Gross pay for covered period
        bonus (MonetaryAmount3): Bonus pay for covered period
        commission (MonetaryAmount4): Commission for covered period
        overtime (MonetaryAmount5): Overtime pay for covered period
        other_earnings (List[OtherMonetaryAmount]): Other earnings received in
            covered period
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "total": 'total',
        "base": 'base',
        "bonus": 'bonus',
        "commission": 'commission',
        "overtime": 'overtime',
        "other_earnings": 'otherEarnings'
    }

    _optionals = [
        'base',
        'bonus',
        'commission',
        'overtime',
        'other_earnings',
    ]

    def __init__(self,
                 total=None,
                 base=APIHelper.SKIP,
                 bonus=APIHelper.SKIP,
                 commission=APIHelper.SKIP,
                 overtime=APIHelper.SKIP,
                 other_earnings=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the PaymentAmounts class"""

        # Initialize members of the class
        self.total = total 
        if base is not APIHelper.SKIP:
            self.base = base 
        if bonus is not APIHelper.SKIP:
            self.bonus = bonus 
        if commission is not APIHelper.SKIP:
            self.commission = commission 
        if overtime is not APIHelper.SKIP:
            self.overtime = overtime 
        if other_earnings is not APIHelper.SKIP:
            self.other_earnings = other_earnings 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        total = MonetaryAmount1.from_dictionary(dictionary.get('total')) if dictionary.get('total') else None
        base = MonetaryAmount2.from_dictionary(dictionary.get('base')) if 'base' in dictionary.keys() else APIHelper.SKIP
        bonus = MonetaryAmount3.from_dictionary(dictionary.get('bonus')) if 'bonus' in dictionary.keys() else APIHelper.SKIP
        commission = MonetaryAmount4.from_dictionary(dictionary.get('commission')) if 'commission' in dictionary.keys() else APIHelper.SKIP
        overtime = MonetaryAmount5.from_dictionary(dictionary.get('overtime')) if 'overtime' in dictionary.keys() else APIHelper.SKIP
        other_earnings = None
        if dictionary.get('otherEarnings') is not None:
            other_earnings = [OtherMonetaryAmount.from_dictionary(x) for x in dictionary.get('otherEarnings')]
        else:
            other_earnings = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(total,
                   base,
                   bonus,
                   commission,
                   overtime,
                   other_earnings,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'total={self.total!r}, '
                f'base={(self.base if hasattr(self, "base") else None)!r}, '
                f'bonus={(self.bonus if hasattr(self, "bonus") else None)!r}, '
                f'commission={(self.commission if hasattr(self, "commission") else None)!r}, '
                f'overtime={(self.overtime if hasattr(self, "overtime") else None)!r}, '
                f'other_earnings={(self.other_earnings if hasattr(self, "other_earnings") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'total={self.total!s}, '
                f'base={(self.base if hasattr(self, "base") else None)!s}, '
                f'bonus={(self.bonus if hasattr(self, "bonus") else None)!s}, '
                f'commission={(self.commission if hasattr(self, "commission") else None)!s}, '
                f'overtime={(self.overtime if hasattr(self, "overtime") else None)!s}, '
                f'other_earnings={(self.other_earnings if hasattr(self, "other_earnings") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
