# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.monetary_amount_6 import MonetaryAmount6
from fdxapi.models.payment_amounts_2 import PaymentAmounts2


class PaymentAmounts1(object):

    """Implementation of the 'Payment Amounts1' model.

    Year-to-date pay for current year and total annual pay for previous years

    Attributes:
        year (int): The year in which this income was earned
        gross_pay (PaymentAmounts2): Gross pay for covered period
        net_pay (MonetaryAmount6): Net pay for covered period
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "year": 'year',
        "gross_pay": 'grossPay',
        "net_pay": 'netPay'
    }

    _optionals = [
        'net_pay',
    ]

    def __init__(self,
                 year=None,
                 gross_pay=None,
                 net_pay=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the PaymentAmounts1 class"""

        # Initialize members of the class
        self.year = year 
        self.gross_pay = gross_pay 
        if net_pay is not APIHelper.SKIP:
            self.net_pay = net_pay 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        year = dictionary.get("year") if dictionary.get("year") else None
        gross_pay = PaymentAmounts2.from_dictionary(dictionary.get('grossPay')) if dictionary.get('grossPay') else None
        net_pay = MonetaryAmount6.from_dictionary(dictionary.get('netPay')) if 'netPay' in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(year,
                   gross_pay,
                   net_pay,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'year={self.year!r}, '
                f'gross_pay={self.gross_pay!r}, '
                f'net_pay={(self.net_pay if hasattr(self, "net_pay") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'year={self.year!s}, '
                f'gross_pay={self.gross_pay!s}, '
                f'net_pay={(self.net_pay if hasattr(self, "net_pay") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
