# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class PaymentDeliveryAddressEntity(object):

    """Implementation of the 'Payment Delivery Address entity' model.

    A single location for a party. A party (e.g. Branch) can have multiple
    registered
    locations; street addresses, email addresses and/or telephone numbers

    Attributes:
        mtype (DeliveryAddressType): Type of delivery address
        address (ElectronicAddressEntity | TelephoneNumber | Address | None):
            Value of the address
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "mtype": 'type',
        "address": 'address'
    }

    _optionals = [
        'mtype',
        'address',
    ]

    def __init__(self,
                 mtype=APIHelper.SKIP,
                 address=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the PaymentDeliveryAddressEntity class"""

        # Initialize members of the class
        if mtype is not APIHelper.SKIP:
            self.mtype = mtype 
        if address is not APIHelper.SKIP:
            self.address = address 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        from fdxapi.utilities.union_type_lookup import UnionTypeLookUp

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        mtype = dictionary.get("type") if dictionary.get("type") else APIHelper.SKIP
        address = APIHelper.deserialize_union_type(UnionTypeLookUp.get('PaymentDeliveryAddressEntityAddress'), dictionary.get('address'), False) if dictionary.get('address') is not None else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(mtype,
                   address,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'mtype={(self.mtype if hasattr(self, "mtype") else None)!r}, '
                f'address={(self.address if hasattr(self, "address") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'mtype={(self.mtype if hasattr(self, "mtype") else None)!s}, '
                f'address={(self.address if hasattr(self, "address") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
